/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.Collections;
import java.util.Iterator;
import net.sf.mpxj.ProjectEntityWithIDContainer;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.Task;
import net.sf.mpxj.common.NumberHelper;

public class TaskContainer
extends ProjectEntityWithIDContainer<Task> {
    public TaskContainer(ProjectFile projectFile) {
        super(projectFile);
    }

    public Task add() {
        Task task = new Task(this.m_projectFile, null);
        this.add(task);
        this.m_projectFile.getChildTasks().add(task);
        return task;
    }

    @Override
    public void removed(Task task) {
        Object object;
        this.m_uniqueIDMap.remove(task.getUniqueID());
        this.m_idMap.remove(task.getID());
        Task task2 = task.getParentTask();
        if (task2 != null) {
            task2.removeChildTask(task);
        } else {
            this.m_projectFile.getChildTasks().remove(task);
        }
        Iterator iterator = this.m_projectFile.getResourceAssignments().iterator();
        while (iterator.hasNext()) {
            object = (ResourceAssignment)iterator.next();
            if (((ResourceAssignment)object).getTask() != task) continue;
            Resource resource = ((ResourceAssignment)object).getResource();
            if (resource != null) {
                resource.removeResourceAssignment((ResourceAssignment)object);
            }
            iterator.remove();
        }
        while (!(object = task.getChildTasks()).isEmpty()) {
            this.remove(object.get(0));
        }
    }

    public void synchronizeTaskIDToHierarchy() {
        this.clear();
        int n = this.getByID(0) == null ? 1 : 0;
        for (Task task : this.m_projectFile.getChildTasks()) {
            task.setID(n++);
            this.add(task);
            n = this.synchroizeTaskIDToHierarchy(task, n);
        }
    }

    private int synchroizeTaskIDToHierarchy(Task task, int n) {
        for (Task task2 : task.getChildTasks()) {
            task2.setID(n++);
            this.add(task2);
            n = this.synchroizeTaskIDToHierarchy(task2, n);
        }
        return n;
    }

    public void updateStructure() {
        if (this.size() > 1) {
            Collections.sort(this);
            this.m_projectFile.getChildTasks().clear();
            Task task = null;
            int n = -1;
            boolean bl = this.m_projectFile.getProjectConfig().getAutoWBS();
            boolean bl2 = this.m_projectFile.getProjectConfig().getAutoOutlineNumber();
            for (Task task2 : this) {
                task2.clearChildTasks();
                Task task3 = null;
                if (!task2.getNull()) {
                    int n2 = NumberHelper.getInt(task2.getOutlineLevel());
                    if (task != null) {
                        if (n2 == n || task2.getNull()) {
                            task3 = task.getParentTask();
                            n2 = n;
                        } else if (n2 > n) {
                            task3 = task;
                        } else {
                            while (n2 <= n && (task3 = task.getParentTask()) != null) {
                                n = NumberHelper.getInt(task3.getOutlineLevel());
                                task = task3;
                            }
                        }
                    }
                    task = task2;
                    n = n2;
                    if (bl || task2.getWBS() == null) {
                        task2.generateWBS(task3);
                    }
                    if (bl2) {
                        task2.generateOutlineNumber(task3);
                    }
                }
                if (task3 == null) {
                    this.m_projectFile.getChildTasks().add(task2);
                    continue;
                }
                task3.addChildTask(task2);
            }
        }
    }

    @Override
    protected int firstUniqueID() {
        Task task = (Task)this.getByID(0);
        return task == null ? 1 : 0;
    }
}

