'''OpenGL extension ATI.pn_triangles

This module customises the behaviour of the 
OpenGL.raw.GL.ATI.pn_triangles to provide a more 
Python-friendly API

Overview (from the spec)
	
	ATI_pn_triangles provides a path for enabling the GL to internally 
	tessellate input geometry into curved patches.  The extension allows the 
	user to tune the amount of tessellation to be performed on each triangle as 
	a global state value.  The intent of PN Triangle tessellation is 
	typically to produce geometry with a smoother silhouette and more organic 
	shape.
	
	The tessellated patch will replace the triangles input into the GL.  
	The GL will generate new vertices in object-space, prior to geometry 
	transformation.  Only the vertices and normals are required to produce 
	proper results, and the rest of the information per vertex is interpolated 
	linearly across the patch.  

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/ATI/pn_triangles.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.ATI.pn_triangles import *
from OpenGL.raw.GL.ATI.pn_triangles import _EXTENSION_NAME

def glInitPnTrianglesATI():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION