/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser.extension;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.protocol.message.extension.PreSharedKeyExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.psk.PSKBinder;
import de.rub.nds.tlsattacker.core.protocol.message.extension.psk.PSKIdentity;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.PSKBinderParser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.PSKIdentityParser;
import java.util.LinkedList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PreSharedKeyExtensionParser
extends ExtensionParser<PreSharedKeyExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public PreSharedKeyExtensionParser(int startposition, byte[] array) {
        super(startposition, array);
    }

    @Override
    public void parseExtensionMessageContent(PreSharedKeyExtensionMessage msg) {
        LOGGER.debug("Parsing PreSharedKeyExtensionMessage");
        if (super.getBytesLeft() > 2) {
            this.parsePreSharedKeyIdentitiyListLength(msg);
            this.parsePreSharedKeyIdentityListBytes(msg);
            this.parsePreSharedKeyBinderListLength(msg);
            this.parsePreSharedKeyBinderListBytes(msg);
        } else {
            this.parseSelectedIdentity(msg);
        }
    }

    @Override
    protected PreSharedKeyExtensionMessage createExtensionMessage() {
        return new PreSharedKeyExtensionMessage();
    }

    private void parsePreSharedKeyIdentitiyListLength(PreSharedKeyExtensionMessage msg) {
        msg.setIdentityListLength(this.parseIntField(2));
        LOGGER.debug("PreSharedKeyIdentityListLength: " + msg.getIdentityListLength().getValue());
    }

    private void parsePreSharedKeyIdentityListBytes(PreSharedKeyExtensionMessage msg) {
        msg.setIdentityListBytes(this.parseByteArrayField((Integer)msg.getIdentityListLength().getValue()));
        LOGGER.debug("Identity list bytes: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getIdentityListBytes().getValue())));
        LinkedList<PSKIdentity> identities = new LinkedList<PSKIdentity>();
        int parsed = 0;
        while (parsed < (Integer)msg.getIdentityListLength().getValue()) {
            PSKIdentityParser parser = new PSKIdentityParser(parsed, (byte[])msg.getIdentityListBytes().getValue());
            identities.add(parser.parse());
            parsed = parser.getPointer();
        }
        msg.setIdentities(identities);
    }

    private void parsePreSharedKeyBinderListLength(PreSharedKeyExtensionMessage msg) {
        msg.setBinderListLength(this.parseIntField(2));
        LOGGER.debug("PreSharedKeyBinderListLength: " + msg.getBinderListLength().getValue());
    }

    private void parsePreSharedKeyBinderListBytes(PreSharedKeyExtensionMessage msg) {
        msg.setBinderListBytes(this.parseByteArrayField((Integer)msg.getBinderListLength().getValue()));
        LOGGER.debug("Binder list bytes: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getBinderListBytes().getValue())));
        LinkedList<PSKBinder> binders = new LinkedList<PSKBinder>();
        int parsed = 0;
        while (parsed < (Integer)msg.getBinderListLength().getValue()) {
            PSKBinderParser parser = new PSKBinderParser(parsed, (byte[])msg.getBinderListBytes().getValue());
            binders.add(parser.parse());
            parsed = parser.getPointer();
        }
        msg.setBinders(binders);
    }

    private void parseSelectedIdentity(PreSharedKeyExtensionMessage msg) {
        msg.setSelectedIdentity(this.parseIntField(2));
        LOGGER.debug("SelectedIdentity:" + msg.getSelectedIdentity().getValue());
    }
}

