/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.state.serializer;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.constants.ClientAuthenticationType;
import de.rub.nds.tlsattacker.core.constants.CompressionMethod;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.serializer.Serializer;
import de.rub.nds.tlsattacker.core.state.StatePlaintext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StatePlaintextSerializer
extends Serializer<StatePlaintext> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final StatePlaintext statePlaintext;

    public StatePlaintextSerializer(StatePlaintext statePlaintext) {
        this.statePlaintext = statePlaintext;
    }

    @Override
    protected byte[] serializeBytes() {
        LOGGER.debug("Serializing StatePlaintext");
        this.writeProtocolVersion(this.statePlaintext);
        this.writeCipherSuite(this.statePlaintext);
        this.writeCompressionMethod(this.statePlaintext);
        this.writeMasterSecret(this.statePlaintext);
        this.writeClientAuthentication(this.statePlaintext);
        this.writeTimestamp(this.statePlaintext);
        return this.getAlreadySerialized();
    }

    private void writeProtocolVersion(StatePlaintext statePlaintext) {
        this.appendBytes((byte[])statePlaintext.getProtocolVersion().getValue());
        LOGGER.debug("ProtocolVersion: " + ProtocolVersion.getProtocolVersion((byte[])statePlaintext.getProtocolVersion().getValue()).name());
    }

    private void writeCipherSuite(StatePlaintext statePlaintext) {
        this.appendInt((Integer)statePlaintext.getCipherSuite().getValue(), 2);
        LOGGER.debug("CipherSuite: " + CipherSuite.getCipherSuite((Integer)statePlaintext.getCipherSuite().getValue()).name());
    }

    private void writeCompressionMethod(StatePlaintext statePlaintext) {
        this.appendByte((Byte)statePlaintext.getCompressionMethod().getValue());
        LOGGER.debug("CompressionMethod: " + CompressionMethod.getCompressionMethod((Byte)statePlaintext.getCompressionMethod().getValue()).name());
    }

    private void writeMasterSecret(StatePlaintext statePlaintext) {
        this.appendBytes((byte[])statePlaintext.getMasterSecret().getValue());
        LOGGER.debug("MasterSecret: " + ArrayConverter.bytesToHexString((byte[])((byte[])statePlaintext.getMasterSecret().getValue()), (boolean)true, (boolean)true));
    }

    private void writeClientAuthentication(StatePlaintext statePlaintext) {
        byte clientAuthenticationType = (Byte)statePlaintext.getClientAuthenticationType().getValue();
        if (clientAuthenticationType == ClientAuthenticationType.ANONYMOUS.getValue()) {
            this.appendByte(clientAuthenticationType);
            LOGGER.debug("ClientAuthenticationType: " + ClientAuthenticationType.getClientAuthenticationType(clientAuthenticationType).name());
        } else if (clientAuthenticationType == ClientAuthenticationType.CERTIFICATE_BASED.getValue()) {
            this.appendByte(clientAuthenticationType);
            this.appendBytes(statePlaintext.getClientAuthenticationDataLength().getByteArray(3));
            this.appendBytes((byte[])statePlaintext.getClientAuthenticationData().getValue());
            LOGGER.debug("ClientAuthenticationType: " + ClientAuthenticationType.getClientAuthenticationType(clientAuthenticationType).name());
            LOGGER.debug("ClientAuthenticationDataLength: " + statePlaintext.getClientAuthenticationDataLength().getValue());
            LOGGER.debug("ClientAuthenticationData: " + ArrayConverter.bytesToHexString((byte[])((byte[])statePlaintext.getClientAuthenticationData().getValue()), (boolean)true, (boolean)true));
        } else if (clientAuthenticationType == ClientAuthenticationType.PSK.getValue()) {
            this.appendByte(clientAuthenticationType);
            this.appendBytes(statePlaintext.getClientAuthenticationDataLength().getByteArray(2));
            this.appendBytes((byte[])statePlaintext.getClientAuthenticationData().getValue());
            LOGGER.debug("ClientAuthenticationType: " + ClientAuthenticationType.getClientAuthenticationType(clientAuthenticationType).name());
            LOGGER.debug("ClientAuthenticationDataLength: " + statePlaintext.getClientAuthenticationDataLength().getValue());
            LOGGER.debug("ClientAuthenticationData: " + ArrayConverter.bytesToHexString((byte[])((byte[])statePlaintext.getClientAuthenticationData().getValue()), (boolean)true, (boolean)true));
        } else {
            this.appendByte(clientAuthenticationType);
            LOGGER.warn("Can't serialize ClientAuthticationData because the choosen ClientAuthType is unknown: " + clientAuthenticationType);
        }
    }

    private void writeTimestamp(StatePlaintext statePlaintext) {
        this.appendBytes(statePlaintext.getTimestamp().getByteArray(4));
        LOGGER.debug("Timestamp: " + ArrayConverter.bytesToHexString((byte[])statePlaintext.getTimestamp().getByteArray(4)));
    }
}

