untrusted comment: verify with openbsd-67-base.pub
RWRmkIA877Io3qxe1hxMcLSSKTabiqnUu9XDP4EvP51HtjNcr+Fr1OTHxLHzWkezMfV3iTxT6OqUOsa6BAStJ/43Ipq9ySn6DQ8=

OpenBSD 6.7 errata 019, August 11, 2020:

Assorted interoperability and bug fixes for the TLSv1.3 client.

Apply by doing:
    signify -Vep /etc/signify/openbsd-67-base.pub -x 019_libssl.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install libssl and unwind:
    cd /usr/src/lib/libssl
    make obj
    make
    make install
    cd /usr/src/sbin/unwind
    make obj
    make
    make install

Index: lib/libssl/ssl_locl.h
===================================================================
RCS file: /cvs/src/lib/libssl/ssl_locl.h,v
retrieving revision 1.272
diff -u -p -r1.272 ssl_locl.h
--- lib/libssl/ssl_locl.h	18 Apr 2020 14:07:56 -0000	1.272
+++ lib/libssl/ssl_locl.h	19 Jul 2020 14:56:02 -0000
@@ -433,6 +433,12 @@ typedef struct ssl_handshake_st {
 	uint8_t *sigalgs;
 } SSL_HANDSHAKE;
 
+typedef struct cert_pkey_st {
+	X509 *x509;
+	EVP_PKEY *privatekey;
+	STACK_OF(X509) *chain;
+} CERT_PKEY;
+
 typedef struct ssl_handshake_tls13_st {
 	uint16_t min_version;
 	uint16_t max_version;
@@ -441,6 +447,10 @@ typedef struct ssl_handshake_tls13_st {
 	int use_legacy;
 	int hrr;
 
+	/* Certificate and sigalg selected for use (static pointers) */
+	const CERT_PKEY *cpk;
+	const struct ssl_sigalg *sigalg;
+
 	/* Version proposed by peer server. */
 	uint16_t server_version;
 
@@ -987,12 +997,6 @@ typedef struct dtls1_state_internal_st {
 	unsigned int change_cipher_spec_ok;
 } DTLS1_STATE_INTERNAL;
 #define D1I(s) (s->d1->internal)
-
-typedef struct cert_pkey_st {
-	X509 *x509;
-	EVP_PKEY *privatekey;
-	STACK_OF(X509) *chain;
-} CERT_PKEY;
 
 typedef struct cert_st {
 	/* Current active set */
Index: lib/libssl/ssl_sigalgs.c
===================================================================
RCS file: /cvs/src/lib/libssl/ssl_sigalgs.c,v
retrieving revision 1.20
diff -u -p -r1.20 ssl_sigalgs.c
--- lib/libssl/ssl_sigalgs.c	1 Apr 2019 02:09:21 -0000	1.20
+++ lib/libssl/ssl_sigalgs.c	5 Aug 2020 17:53:32 -0000
@@ -322,6 +322,12 @@ ssl_sigalg_select(SSL *s, EVP_PKEY *pkey
 		    tls_sigalgs_len)) == NULL)
 			continue;
 
+		/* RSA cannot be used without PSS in TLSv1.3. */
+		if (TLS1_get_version(s) >= TLS1_3_VERSION &&
+		    sigalg->key_type == EVP_PKEY_RSA &&
+		    (sigalg->flags & SIGALG_FLAG_RSA_PSS) == 0)
+			continue;
+
 		if (ssl_sigalg_pkey_ok(sigalg, pkey, check_curve))
 			return sigalg;
 	}
Index: lib/libssl/ssl_tlsext.c
===================================================================
RCS file: /cvs/src/lib/libssl/ssl_tlsext.c,v
retrieving revision 1.63
diff -u -p -r1.63 ssl_tlsext.c
--- lib/libssl/ssl_tlsext.c	21 Apr 2020 17:06:16 -0000	1.63
+++ lib/libssl/ssl_tlsext.c	6 Aug 2020 15:04:31 -0000
@@ -896,12 +896,49 @@ tlsext_ocsp_server_build(SSL *s, CBB *cb
 int
 tlsext_ocsp_client_parse(SSL *s, CBS *cbs, int *alert)
 {
-	if (s->tlsext_status_type == -1) {
-		*alert = TLS1_AD_UNSUPPORTED_EXTENSION;
-		return 0;
+	CBS response;
+	size_t resp_len;
+	uint16_t version = TLS1_get_client_version(s);
+	uint8_t status_type;
+
+	if (version >= TLS1_3_VERSION) {
+		/*
+		 * RFC 8446, 4.4.2.1 - the server may request an OCSP
+		 * response with an empty status_request.
+		 */
+		if (CBS_len(cbs) == 0)
+			return 1;
+
+		if (!CBS_get_u8(cbs, &status_type)) {
+			SSLerror(s, SSL_R_LENGTH_MISMATCH);
+			return 0;
+		}
+		if (status_type != TLSEXT_STATUSTYPE_ocsp) {
+			SSLerror(s, SSL_R_UNSUPPORTED_STATUS_TYPE);
+			return 0;
+		}
+		if (!CBS_get_u24_length_prefixed(cbs, &response)) {
+			SSLerror(s, SSL_R_LENGTH_MISMATCH);
+			return 0;
+		}
+		if (CBS_len(&response) > 65536) {
+			SSLerror(s, SSL_R_DATA_LENGTH_TOO_LONG);
+			return 0;
+		}
+		if (!CBS_stow(&response, &s->internal->tlsext_ocsp_resp,
+		    &resp_len)) {
+			*alert = SSL_AD_INTERNAL_ERROR;
+			return 0;
+		}
+		s->internal->tlsext_ocsp_resplen = (int)resp_len;
+	} else {
+		if (s->tlsext_status_type == -1) {
+			*alert = TLS1_AD_UNSUPPORTED_EXTENSION;
+			return 0;
+		}
+		/* Set flag to expect CertificateStatus message */
+		s->internal->tlsext_status_expected = 1;
 	}
-	/* Set flag to expect CertificateStatus message */
-	s->internal->tlsext_status_expected = 1;
 	return 1;
 }
 
Index: lib/libssl/t1_lib.c
===================================================================
RCS file: /cvs/src/lib/libssl/t1_lib.c,v
retrieving revision 1.165
diff -u -p -r1.165 t1_lib.c
--- lib/libssl/t1_lib.c	10 Mar 2020 17:02:21 -0000	1.165
+++ lib/libssl/t1_lib.c	7 Aug 2020 17:51:13 -0000
@@ -250,7 +250,14 @@ static const uint16_t eccurves_list[] = 
 };
 #endif
 
-static const uint16_t eccurves_default[] = {
+static const uint16_t eccurves_client_default[] = {
+	29,			/* X25519 (29) */
+	23,			/* secp256r1 (23) */
+	24,			/* secp384r1 (24) */
+	25,			/* secp521r1 (25) */
+};
+
+static const uint16_t eccurves_server_default[] = {
 	29,			/* X25519 (29) */
 	23,			/* secp256r1 (23) */
 	24,			/* secp384r1 (24) */
@@ -374,9 +381,15 @@ tls1_get_group_list(SSL *s, int client_g
 
 	*pgroups = s->internal->tlsext_supportedgroups;
 	*pgroupslen = s->internal->tlsext_supportedgroups_length;
-	if (*pgroups == NULL) {
-		*pgroups = eccurves_default;
-		*pgroupslen = sizeof(eccurves_default) / 2;
+	if (*pgroups != NULL)
+		return;
+
+	if (!s->server) {
+		*pgroups = eccurves_client_default;
+		*pgroupslen = sizeof(eccurves_client_default) / 2;
+	} else {
+		*pgroups = eccurves_server_default;
+		*pgroupslen = sizeof(eccurves_server_default) / 2;
 	}
 }
 
Index: lib/libssl/tls13_client.c
===================================================================
RCS file: /cvs/src/lib/libssl/tls13_client.c,v
retrieving revision 1.54.4.1
diff -u -p -r1.54.4.1 tls13_client.c
--- lib/libssl/tls13_client.c	19 May 2020 20:22:33 -0000	1.54.4.1
+++ lib/libssl/tls13_client.c	20 Jul 2020 08:44:53 -0000
@@ -811,30 +811,92 @@ tls13_server_finished_recv(struct tls13_
 	return ret;
 }
 
+static int
+tls13_client_check_certificate(struct tls13_ctx *ctx, CERT_PKEY *cpk,
+    int *ok, const struct ssl_sigalg **out_sigalg)
+{
+	const struct ssl_sigalg *sigalg;
+	SSL *s = ctx->ssl;
+
+	*ok = 0;
+	*out_sigalg = NULL;
+
+	if (cpk->x509 == NULL || cpk->privatekey == NULL)
+		goto done;
+
+	if ((sigalg = ssl_sigalg_select(s, cpk->privatekey)) == NULL)
+		goto done;
+
+	*ok = 1;
+	*out_sigalg = sigalg;
+
+ done:
+	return 1;
+}
+
+static int
+tls13_client_select_certificate(struct tls13_ctx *ctx, CERT_PKEY **out_cpk,
+    const struct ssl_sigalg **out_sigalg)
+{
+	SSL *s = ctx->ssl;
+	const struct ssl_sigalg *sigalg;
+	CERT_PKEY *cpk;
+	int cert_ok;
+
+	*out_cpk = NULL;
+	*out_sigalg = NULL;
+
+	cpk = &s->cert->pkeys[SSL_PKEY_ECC];
+	if (!tls13_client_check_certificate(ctx, cpk, &cert_ok, &sigalg))
+		return 0;
+	if (cert_ok)
+		goto done;
+
+	cpk = &s->cert->pkeys[SSL_PKEY_RSA_ENC];
+	if (!tls13_client_check_certificate(ctx, cpk, &cert_ok, &sigalg))
+		return 0;
+	if (cert_ok)
+		goto done;
+
+	cpk = NULL;
+	sigalg = NULL;
+
+ done:
+	*out_cpk = cpk;
+	*out_sigalg = sigalg;
+
+	return 1;
+}
+
 int
 tls13_client_certificate_send(struct tls13_ctx *ctx, CBB *cbb)
 {
 	SSL *s = ctx->ssl;
 	CBB cert_request_context, cert_list;
+	const struct ssl_sigalg *sigalg;
 	STACK_OF(X509) *chain;
 	CERT_PKEY *cpk;
 	X509 *cert;
 	int i, ret = 0;
 
-	/* XXX - Need to revisit certificate selection. */
-	cpk = &s->cert->pkeys[SSL_PKEY_RSA_ENC];
+	if (!tls13_client_select_certificate(ctx, &cpk, &sigalg))
+		goto err;
 
-	if ((chain = cpk->chain) == NULL)
-		chain = s->ctx->extra_certs;
+	ctx->hs->cpk = cpk;
+	ctx->hs->sigalg = sigalg;
 
 	if (!CBB_add_u8_length_prefixed(cbb, &cert_request_context))
 		goto err;
 	if (!CBB_add_u24_length_prefixed(cbb, &cert_list))
 		goto err;
 
-	if (cpk->x509 == NULL)
+	/* No certificate selected. */
+	if (cpk == NULL)
 		goto done;
 
+	if ((chain = cpk->chain) == NULL)
+		chain = s->ctx->extra_certs;
+
 	if (!tls13_cert_add(&cert_list, cpk->x509))
 		goto err;
 
@@ -858,27 +920,23 @@ tls13_client_certificate_send(struct tls
 int
 tls13_client_certificate_verify_send(struct tls13_ctx *ctx, CBB *cbb)
 {
-	SSL *s = ctx->ssl;
-	const struct ssl_sigalg *sigalg = NULL;
+	const struct ssl_sigalg *sigalg;
 	uint8_t *sig = NULL, *sig_content = NULL;
 	size_t sig_len, sig_content_len;
 	EVP_MD_CTX *mdctx = NULL;
 	EVP_PKEY_CTX *pctx;
 	EVP_PKEY *pkey;
-	CERT_PKEY *cpk;
+	const CERT_PKEY *cpk;
 	CBB sig_cbb;
 	int ret = 0;
 
 	memset(&sig_cbb, 0, sizeof(sig_cbb));
 
-	/* XXX - Need to revisit certificate selection. */
-	cpk = &s->cert->pkeys[SSL_PKEY_RSA_ENC];
-	pkey = cpk->privatekey;
-
-	if ((sigalg = ssl_sigalg_select(s, pkey)) == NULL) {
-		/* XXX - SSL_R_SIGNATURE_ALGORITHMS_ERROR */
+	if ((cpk = ctx->hs->cpk) == NULL)
 		goto err;
-	}
+	if ((sigalg = ctx->hs->sigalg) == NULL)
+		goto err;
+	pkey = cpk->privatekey;
 
 	if (!CBB_init(&sig_cbb, 0))
 		goto err;
Index: lib/libssl/tls13_legacy.c
===================================================================
RCS file: /cvs/src/lib/libssl/tls13_legacy.c,v
retrieving revision 1.3.4.1
diff -u -p -r1.3.4.1 tls13_legacy.c
--- lib/libssl/tls13_legacy.c	19 May 2020 20:22:33 -0000	1.3.4.1
+++ lib/libssl/tls13_legacy.c	19 Jul 2020 12:02:58 -0000
@@ -486,29 +486,30 @@ tls13_legacy_shutdown(SSL *ssl)
 		return 1;
 	}
 
-	/* Send close notify. */
 	if (!ctx->close_notify_sent) {
-		ctx->close_notify_sent = 1;
-		if ((ret = tls13_send_alert(ctx->rl, SSL_AD_CLOSE_NOTIFY)) < 0)
+		/* Enqueue and send close notify. */
+		if (!(ssl->internal->shutdown & SSL_SENT_SHUTDOWN)) {
+			ssl->internal->shutdown |= SSL_SENT_SHUTDOWN;
+			if ((ret = tls13_send_alert(ctx->rl,
+			    SSL_AD_CLOSE_NOTIFY)) < 0)
+				return tls13_legacy_return_code(ssl, ret);
+		}
+		if ((ret = tls13_record_layer_send_pending(ctx->rl)) !=
+		    TLS13_IO_SUCCESS)
 			return tls13_legacy_return_code(ssl, ret);
-	}
-
-	/* Ensure close notify has been sent. */
-	if ((ret = tls13_record_layer_send_pending(ctx->rl)) != TLS13_IO_SUCCESS)
-		return tls13_legacy_return_code(ssl, ret);
-
-	/* Receive close notify. */
-	if (!ctx->close_notify_recv) {
+	} else if (!ctx->close_notify_recv) {
 		/*
-		 * If there is still application data pending then we have no
-		 * option but to discard it here. The application should have
-		 * continued to call SSL_read() instead of SSL_shutdown().
+		 * If there is no application data pending, attempt to read more
+		 * data in order to receive a close notify. This should trigger
+		 * a record to be read from the wire, which may be application
+		 * handshake or alert data. Only one attempt is made to match
+		 * previous semantics.
 		 */
-		/* XXX - tls13_drain_application_data()? */
-		if ((ret = tls13_read_application_data(ctx->rl, buf, sizeof(buf))) > 0)
-			ret = TLS13_IO_WANT_POLLIN;
-		if (ret != TLS13_IO_EOF)
-			return tls13_legacy_return_code(ssl, ret);
+		if (tls13_pending_application_data(ctx->rl) == 0) {
+			if ((ret = tls13_read_application_data(ctx->rl, buf,
+			    sizeof(buf))) < 0)
+				return tls13_legacy_return_code(ssl, ret);
+		}
 	}
 
 	if (ctx->close_notify_recv)
Index: lib/libssl/tls13_lib.c
===================================================================
RCS file: /cvs/src/lib/libssl/tls13_lib.c,v
retrieving revision 1.36
diff -u -p -r1.36 tls13_lib.c
--- lib/libssl/tls13_lib.c	28 Apr 2020 20:30:41 -0000	1.36
+++ lib/libssl/tls13_lib.c	5 Aug 2020 06:19:28 -0000
@@ -227,8 +227,9 @@ tls13_key_update_recv(struct tls13_ctx *
 		CBB cbb;
 		CBS cbs; /* XXX */
 
-		free(ctx->hs_msg);
-		ctx->hs_msg = tls13_handshake_msg_new();
+		tls13_handshake_msg_free(ctx->hs_msg);
+		if ((ctx->hs_msg = tls13_handshake_msg_new()) == NULL)
+			goto err;
 		if (!tls13_handshake_msg_start(ctx->hs_msg, &cbb, TLS13_MT_KEY_UPDATE))
 			goto err;
 		if (!CBB_add_u8(&cbb, 0))
Index: lib/libssl/tls13_record_layer.c
===================================================================
RCS file: /cvs/src/lib/libssl/tls13_record_layer.c,v
retrieving revision 1.33
diff -u -p -r1.33 tls13_record_layer.c
--- lib/libssl/tls13_record_layer.c	3 May 2020 15:57:25 -0000	1.33
+++ lib/libssl/tls13_record_layer.c	7 Aug 2020 13:38:54 -0000
@@ -435,6 +435,8 @@ tls13_record_layer_set_traffic_key(const
 	struct tls13_secret key = { .data = NULL, .len = 0 };
 	int ret = 0;
 
+	EVP_AEAD_CTX_cleanup(aead_ctx);
+
 	freezero(iv->data, iv->len);
 	iv->data = NULL;
 	iv->len = 0;
@@ -523,8 +525,9 @@ static int
 tls13_record_layer_open_record_protected(struct tls13_record_layer *rl)
 {
 	CBS header, enc_record;
+	ssize_t inner_len;
 	uint8_t *content = NULL;
-	ssize_t content_len = 0;
+	size_t content_len = 0;
 	uint8_t content_type;
 	size_t out_len;
 
@@ -560,18 +563,18 @@ tls13_record_layer_open_record_protected
 	 * Time to hunt for that elusive content type!
 	 */
 	/* XXX - CBS from end? CBS_get_end_u8()? */
-	content_len = out_len - 1;
-	while (content_len >= 0 && content[content_len] == 0)
-		content_len--;
-	if (content_len < 0)
+	inner_len = out_len - 1;
+	while (inner_len >= 0 && content[inner_len] == 0)
+		inner_len--;
+	if (inner_len < 0)
 		goto err;
-	content_type = content[content_len];
+	content_type = content[inner_len];
 
 	tls13_record_layer_rbuf_free(rl);
 
 	rl->rbuf_content_type = content_type;
 	rl->rbuf = content;
-	rl->rbuf_len = content_len;
+	rl->rbuf_len = inner_len;
 
 	CBS_init(&rl->rbuf_cbs, rl->rbuf, rl->rbuf_len);
 
Index: regress/lib/libssl/client/clienttest.c
===================================================================
RCS file: /cvs/src/regress/lib/libssl/client/clienttest.c,v
retrieving revision 1.23
diff -u -p -r1.23 clienttest.c
--- regress/lib/libssl/client/clienttest.c	6 Apr 2020 16:53:09 -0000	1.23
+++ regress/lib/libssl/client/clienttest.c	8 Aug 2020 11:43:27 -0000
@@ -66,21 +66,21 @@ static unsigned char cipher_list_tls10[]
 };
 
 static unsigned char client_hello_tls10[] = {
-	0x16, 0x03, 0x01, 0x00, 0x71, 0x01, 0x00, 0x00,
-	0x6d, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
+	0x16, 0x03, 0x01, 0x00, 0x73, 0x01, 0x00, 0x00,
+	0x6f, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
 	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 	0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0xc0, 0x14,
-	0xc0, 0x0a, 0x00, 0x39, 0xff, 0x85, 0x00, 0x88,
+	0x00, 0x00, 0x00, 0x00, 0xff, 0x85, 0x00, 0x88,
 	0x00, 0x81, 0x00, 0x35, 0x00, 0x84, 0xc0, 0x13,
 	0xc0, 0x09, 0x00, 0x33, 0x00, 0x45, 0x00, 0x2f,
 	0x00, 0x41, 0xc0, 0x11, 0xc0, 0x07, 0x00, 0x05,
 	0x00, 0x04, 0xc0, 0x12, 0xc0, 0x08, 0x00, 0x16,
-	0x00, 0x0a, 0x00, 0xff, 0x01, 0x00, 0x00, 0x16,
+	0x00, 0x0a, 0x00, 0xff, 0x01, 0x00, 0x00, 0x18,
 	0x00, 0x0b, 0x00, 0x02, 0x01, 0x00, 0x00, 0x0a,
-	0x00, 0x08, 0x00, 0x06, 0x00, 0x1d, 0x00, 0x17,
-	0x00, 0x18, 0x00, 0x23, 0x00, 0x00,
+	0x00, 0x0a, 0x00, 0x08, 0x00, 0x1d, 0x00, 0x17,
+	0x00, 0x18, 0x00, 0x19, 0x00, 0x23, 0x00, 0x00,
 };
 
 static unsigned char cipher_list_tls11[] = {
@@ -93,8 +93,8 @@ static unsigned char cipher_list_tls11[]
 };
 
 static unsigned char client_hello_tls11[] = {
-	0x16, 0x03, 0x01, 0x00, 0x71, 0x01, 0x00, 0x00,
-	0x6d, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
+	0x16, 0x03, 0x01, 0x00, 0x73, 0x01, 0x00, 0x00,
+	0x6f, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
 	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
@@ -104,10 +104,10 @@ static unsigned char client_hello_tls11[
 	0xc0, 0x09, 0x00, 0x33, 0x00, 0x45, 0x00, 0x2f,
 	0x00, 0x41, 0xc0, 0x11, 0xc0, 0x07, 0x00, 0x05,
 	0x00, 0x04, 0xc0, 0x12, 0xc0, 0x08, 0x00, 0x16,
-	0x00, 0x0a, 0x00, 0xff, 0x01, 0x00, 0x00, 0x16,
+	0x00, 0x0a, 0x00, 0xff, 0x01, 0x00, 0x00, 0x18,
 	0x00, 0x0b, 0x00, 0x02, 0x01, 0x00, 0x00, 0x0a,
-	0x00, 0x08, 0x00, 0x06, 0x00, 0x1d, 0x00, 0x17,
-	0x00, 0x18, 0x00, 0x23, 0x00, 0x00,
+	0x00, 0x0a, 0x00, 0x08, 0x00, 0x1d, 0x00, 0x17,
+	0x00, 0x18, 0x00, 0x19, 0x00, 0x23, 0x00, 0x00,
 };
 
 static unsigned char cipher_list_tls12_aes[] = {
@@ -141,8 +141,8 @@ static unsigned char cipher_list_tls12_c
 };
 
 static unsigned char client_hello_tls12[] = {
-	0x16, 0x03, 0x01, 0x00, 0xbb, 0x01, 0x00, 0x00,
-	0xb7, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00,
+	0x16, 0x03, 0x01, 0x00, 0xbd, 0x01, 0x00, 0x00,
+	0xb9, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00,
 	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
@@ -158,13 +158,14 @@ static unsigned char client_hello_tls12[
 	0x00, 0x3c, 0x00, 0x2f, 0x00, 0xba, 0x00, 0x41,
 	0xc0, 0x11, 0xc0, 0x07, 0x00, 0x05, 0x00, 0x04,
 	0xc0, 0x12, 0xc0, 0x08, 0x00, 0x16, 0x00, 0x0a,
-	0x00, 0xff, 0x01, 0x00, 0x00, 0x32, 0x00, 0x0b,
-	0x00, 0x02, 0x01, 0x00, 0x00, 0x0a, 0x00, 0x08,
-	0x00, 0x06, 0x00, 0x1d, 0x00, 0x17, 0x00, 0x18,
-	0x00, 0x23, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x18,
-	0x00, 0x16, 0x08, 0x06, 0x06, 0x01, 0x06, 0x03,
-	0x08, 0x05, 0x05, 0x01, 0x05, 0x03, 0x08, 0x04,
-	0x04, 0x01, 0x04, 0x03, 0x02, 0x01, 0x02, 0x03,
+	0x00, 0xff, 0x01, 0x00, 0x00, 0x34, 0x00, 0x0b,
+	0x00, 0x02, 0x01, 0x00, 0x00, 0x0a, 0x00, 0x0a,
+	0x00, 0x08, 0x00, 0x1d, 0x00, 0x17, 0x00, 0x18,
+	0x00, 0x19, 0x00, 0x23, 0x00, 0x00, 0x00, 0x0d,
+	0x00, 0x18, 0x00, 0x16, 0x08, 0x06, 0x06, 0x01,
+	0x06, 0x03, 0x08, 0x05, 0x05, 0x01, 0x05, 0x03,
+	0x08, 0x04, 0x04, 0x01, 0x04, 0x03, 0x02, 0x01,
+	0x02, 0x03,
 };
 
 struct client_hello_test {
Index: regress/lib/libssl/tlsext/tlsexttest.c
===================================================================
RCS file: /cvs/src/regress/lib/libssl/tlsext/tlsexttest.c,v
retrieving revision 1.35
diff -u -p -r1.35 tlsexttest.c
--- regress/lib/libssl/tlsext/tlsexttest.c	17 Apr 2020 17:24:03 -0000	1.35
+++ regress/lib/libssl/tlsext/tlsexttest.c	8 Aug 2020 11:43:27 -0000
@@ -470,10 +470,11 @@ test_tlsext_alpn_server(void)
  */
 
 static uint8_t tlsext_supportedgroups_client_default[] = {
-	0x00, 0x06,
+	0x00, 0x08,
 	0x00, 0x1d,  /* X25519 (29) */
 	0x00, 0x17,  /* secp256r1 (23) */
-	0x00, 0x18   /* secp384r1 (24) */
+	0x00, 0x18,  /* secp384r1 (24) */
+	0x00, 0x19,  /* secp521r1 (25) */
 };
 
 static uint16_t tlsext_supportedgroups_client_secp384r1_val[] = {
@@ -2712,13 +2713,13 @@ test_tlsext_srtp_server(void)
 #endif /* OPENSSL_NO_SRTP */
 
 unsigned char tlsext_clienthello_default[] = {
-	0x00, 0x32, 0x00, 0x0b, 0x00, 0x02, 0x01, 0x00,
-	0x00, 0x0a, 0x00, 0x08, 0x00, 0x06, 0x00, 0x1d,
-	0x00, 0x17, 0x00, 0x18, 0x00, 0x23, 0x00, 0x00,
-	0x00, 0x0d, 0x00, 0x18, 0x00, 0x16, 0x08, 0x06,
-	0x06, 0x01, 0x06, 0x03, 0x08, 0x05, 0x05, 0x01,
-	0x05, 0x03, 0x08, 0x04, 0x04, 0x01, 0x04, 0x03,
-	0x02, 0x01, 0x02, 0x03,
+	0x00, 0x34, 0x00, 0x0b, 0x00, 0x02, 0x01, 0x00,
+	0x00, 0x0a, 0x00, 0x0a, 0x00, 0x08, 0x00, 0x1d,
+	0x00, 0x17, 0x00, 0x18, 0x00, 0x19, 0x00, 0x23,
+	0x00, 0x00, 0x00, 0x0d, 0x00, 0x18, 0x00, 0x16,
+	0x08, 0x06, 0x06, 0x01, 0x06, 0x03, 0x08, 0x05,
+	0x05, 0x01, 0x05, 0x03, 0x08, 0x04, 0x04, 0x01,
+	0x04, 0x03, 0x02, 0x01, 0x02, 0x03,
 };
 
 unsigned char tlsext_clienthello_disabled[] = {};
