/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.conf.codec;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.server.conf.codec.EncodingOptions;
import org.apache.accumulo.server.conf.codec.VersionedPropGzipCodec;
import org.apache.accumulo.server.conf.codec.VersionedProperties;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class VersionedPropCodec {
    private final EncodingOptions encodingOpts;

    public VersionedPropCodec(EncodingOptions encodingOpts) {
        this.encodingOpts = encodingOpts;
    }

    public static VersionedPropCodec getDefault() {
        return VersionedPropGzipCodec.codec(true);
    }

    public EncodingOptions getEncodingOpts() {
        return this.encodingOpts;
    }

    public byte[] toBytes(VersionedProperties vProps) throws IOException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (DataOutputStream dos = new DataOutputStream(bos);){
                this.encodingOpts.encode(dos);
                dos.writeUTF(VersionedProperties.TIMESTAMP_FORMATTER.format(vProps.getTimestamp()));
                this.encodePayload(bos, vProps, this.encodingOpts);
                byArray = bos.toByteArray();
            }
            return byArray;
        }
    }

    abstract void encodePayload(OutputStream var1, VersionedProperties var2, EncodingOptions var3) throws IOException;

    /*
     * Enabled aggressive exception aggregation
     */
    public @NonNull VersionedProperties fromBytes(int version, byte[] bytes) throws IOException {
        try (ByteArrayInputStream bis = new ByteArrayInputStream(bytes);){
            VersionedProperties versionedProperties;
            try (DataInputStream dis = new DataInputStream(bis);){
                EncodingOptions encodingOpts = EncodingOptions.fromDataStream(dis);
                if (!this.checkCanDecodeVersion(encodingOpts)) {
                    throw new IllegalArgumentException("Invalid data version - cannot process the version read: " + encodingOpts.getEncodingVersion());
                }
                Instant timestamp = VersionedProperties.TIMESTAMP_FORMATTER.parse((CharSequence)dis.readUTF(), Instant::from);
                Map<String, String> props = this.decodePayload(bis, encodingOpts);
                versionedProperties = new VersionedProperties(version, timestamp, props);
            }
            return versionedProperties;
        }
        catch (NullPointerException | DateTimeParseException ex) {
            throw new IllegalArgumentException("Invalid data cannot decode byte array", ex);
        }
    }

    abstract boolean checkCanDecodeVersion(EncodingOptions var1);

    /*
     * Enabled aggressive exception aggregation
     */
    public static int getEncodingVersion(byte[] bytes) {
        try (ByteArrayInputStream bis = new ByteArrayInputStream(bytes);){
            int n;
            try (DataInputStream dis = new DataInputStream(bis);){
                n = EncodingOptions.fromDataStream(dis).getEncodingVersion();
            }
            return n;
        }
        catch (IOException | NullPointerException ex) {
            throw new IllegalArgumentException("Failed to read encoding version from byte array provided", ex);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Instant readTimestamp(byte[] bytes) {
        try (ByteArrayInputStream bis = new ByteArrayInputStream(bytes);){
            Instant instant;
            try (DataInputStream dis = new DataInputStream(bis);){
                EncodingOptions.fromDataStream(dis);
                instant = VersionedProperties.TIMESTAMP_FORMATTER.parse((CharSequence)dis.readUTF(), Instant::from);
            }
            return instant;
        }
        catch (IOException | NullPointerException | DateTimeParseException ex) {
            throw new IllegalArgumentException("Failed to read timestamp from byte array provided", ex);
        }
    }

    abstract Map<String, String> decodePayload(InputStream var1, EncodingOptions var2) throws IOException;

    Map<String, String> readMapAsUTF(DataInputStream dis) throws IOException {
        HashMap<String, String> aMap = new HashMap<String, String>();
        int items = dis.readInt();
        for (int i = 0; i < items; ++i) {
            String k = dis.readUTF();
            String v = dis.readUTF();
            aMap.put(k, v);
        }
        return aMap;
    }

    void writeMapAsUTF(DataOutputStream dos, Map<String, String> aMap) throws IOException {
        dos.writeInt(aMap.size());
        for (Map.Entry<String, String> e : aMap.entrySet()) {
            dos.writeUTF(e.getKey());
            dos.writeUTF(e.getValue());
        }
        dos.flush();
    }
}

