/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.manager.state;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.server.manager.state.MergeState;
import org.apache.hadoop.io.Writable;

public class MergeInfo
implements Writable {
    MergeState state = MergeState.NONE;
    KeyExtent extent;
    Operation operation = Operation.MERGE;

    public MergeInfo() {
    }

    public void readFields(DataInput in) throws IOException {
        this.extent = KeyExtent.readFrom((DataInput)in);
        this.state = MergeState.values()[in.readInt()];
        this.operation = Operation.values()[in.readInt()];
    }

    public void write(DataOutput out) throws IOException {
        this.extent.writeTo(out);
        out.writeInt(this.state.ordinal());
        out.writeInt(this.operation.ordinal());
    }

    public MergeInfo(KeyExtent range, Operation op) {
        this.extent = range;
        this.operation = op;
    }

    public MergeState getState() {
        return this.state;
    }

    public KeyExtent getExtent() {
        return this.extent;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public void setState(MergeState state) {
        this.state = state;
    }

    public boolean isDelete() {
        return this.operation.equals((Object)Operation.DELETE);
    }

    public boolean needsToBeChopped(KeyExtent otherExtent) {
        if (!otherExtent.tableId().equals((Object)this.extent.tableId())) {
            return false;
        }
        if (this.isDelete()) {
            return otherExtent.prevEndRow() != null && otherExtent.prevEndRow().equals((Object)this.extent.endRow());
        }
        return this.extent.overlaps(otherExtent);
    }

    public boolean overlaps(KeyExtent otherExtent) {
        boolean result = this.extent.overlaps(otherExtent);
        if (!result && this.needsToBeChopped(otherExtent)) {
            return true;
        }
        return result;
    }

    public String toString() {
        if (!this.state.equals((Object)MergeState.NONE)) {
            return "Merge " + String.valueOf((Object)this.operation) + " of " + String.valueOf(this.extent) + " State: " + String.valueOf((Object)this.state);
        }
        return "No Merge in progress";
    }

    public static enum Operation {
        MERGE,
        DELETE;

    }
}

