/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.shell.Shell;
import org.apache.accumulo.shell.Token;
import org.apache.commons.cli.CommandLine;

public class UserCommand
extends Shell.Command {
    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws AccumuloException, AccumuloSecurityException, IOException {
        String user = cl.getArgs()[0];
        String p = shellState.readMaskedLine("Enter password for user " + user + ": ", Character.valueOf('*'));
        if (p == null) {
            shellState.getWriter().println();
            return 0;
        }
        byte[] pass = p.getBytes(StandardCharsets.UTF_8);
        shellState.updateUser(user, (AuthenticationToken)new PasswordToken(pass));
        return 0;
    }

    @Override
    public String description() {
        return "switches to the specified user";
    }

    @Override
    public void registerCompletion(Token root, Map<Shell.Command.CompletionSet, Set<String>> special) {
        this.registerCompletionForUsers(root, special);
    }

    @Override
    public String usage() {
        return this.getName() + " <username>";
    }

    @Override
    public int numArgs() {
        return 1;
    }
}

