/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import java.io.IOException;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.security.NamespacePermission;
import org.apache.accumulo.core.security.SystemPermission;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.shell.Shell;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class UserPermissionsCommand
extends Shell.Command {
    private Option userOpt;

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws AccumuloException, AccumuloSecurityException, IOException {
        String user = cl.getOptionValue(this.userOpt.getOpt(), shellState.getAccumuloClient().whoami());
        String delim = "";
        shellState.getWriter().print("System permissions: ");
        for (SystemPermission p : SystemPermission.values()) {
            if (p == null || !shellState.getAccumuloClient().securityOperations().hasSystemPermission(user, p)) continue;
            shellState.getWriter().print(delim + "System." + p.name());
            delim = ", ";
        }
        shellState.getWriter().println();
        boolean runOnce = true;
        for (String n : shellState.getAccumuloClient().namespaceOperations().list()) {
            delim = "";
            for (NamespacePermission namespacePermission : NamespacePermission.values()) {
                if (namespacePermission == null || !shellState.getAccumuloClient().securityOperations().hasNamespacePermission(user, n, namespacePermission)) continue;
                if (runOnce) {
                    shellState.getWriter().print("\nNamespace permissions (" + n + "): ");
                    runOnce = false;
                }
                shellState.getWriter().print(delim + "Namespace." + namespacePermission.name());
                delim = ", ";
            }
            runOnce = true;
        }
        shellState.getWriter().println();
        runOnce = true;
        for (String t : shellState.getAccumuloClient().tableOperations().list()) {
            delim = "";
            for (NamespacePermission namespacePermission : TablePermission.values()) {
                if (!shellState.getAccumuloClient().securityOperations().hasTablePermission(user, t, (TablePermission)namespacePermission) || namespacePermission == null) continue;
                if (runOnce) {
                    shellState.getWriter().print("\nTable permissions (" + t + "): ");
                    runOnce = false;
                }
                shellState.getWriter().print(delim + "Table." + namespacePermission.name());
                delim = ", ";
            }
            runOnce = true;
        }
        shellState.getWriter().println();
        return 0;
    }

    @Override
    public String description() {
        return "displays a user's system, table, and namespace permissions";
    }

    @Override
    public Options getOptions() {
        Options o = new Options();
        this.userOpt = new Option("u", "user", true, "user to operate on");
        this.userOpt.setArgName("user");
        o.addOption(this.userOpt);
        return o;
    }

    @Override
    public int numArgs() {
        return 0;
    }
}

