/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.lexicoder;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import org.apache.accumulo.core.client.lexicoder.AbstractLexicoder;
import org.apache.accumulo.core.clientImpl.lexicoder.FixedByteArrayOutputStream;

public class BigIntegerLexicoder
extends AbstractLexicoder<BigInteger> {
    @Override
    public byte[] encode(BigInteger v) {
        try {
            byte[] bytes = v.toByteArray();
            byte[] ret = new byte[4 + bytes.length];
            DataOutputStream dos = new DataOutputStream(new FixedByteArrayOutputStream(ret));
            bytes[0] = (byte)(0x80 ^ bytes[0]);
            int len = bytes.length;
            if (v.signum() < 0) {
                len = -len;
            }
            dos.writeInt(len ^= Integer.MIN_VALUE);
            dos.write(bytes);
            dos.close();
            return ret;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public BigInteger decode(byte[] b) {
        return (BigInteger)super.decode(b);
    }

    @Override
    protected BigInteger decodeUnchecked(byte[] b, int offset, int origLen) {
        try {
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(b, offset, origLen));
            int newLen = dis.readInt();
            newLen ^= Integer.MIN_VALUE;
            newLen = Math.abs(newLen);
            byte[] bytes = new byte[newLen];
            dis.readFully(bytes);
            bytes[0] = (byte)(0x80 ^ bytes[0]);
            return new BigInteger(bytes);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

