/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.spi.balancer;

import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.accumulo.core.conf.ConfigurationTypeHelper;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.TabletId;
import org.apache.accumulo.core.spi.balancer.GroupBalancer;
import org.apache.accumulo.core.spi.common.ServiceEnvironment;
import org.apache.hadoop.io.Text;

public class RegexGroupBalancer
extends GroupBalancer {
    public static final String REGEX_PROPERTY = Property.TABLE_ARBITRARY_PROP_PREFIX.getKey() + "balancer.group.regex.pattern";
    public static final String DEFAUT_GROUP_PROPERTY = Property.TABLE_ARBITRARY_PROP_PREFIX.getKey() + "balancer.group.regex.default";
    public static final String WAIT_TIME_PROPERTY = Property.TABLE_ARBITRARY_PROP_PREFIX.getKey() + "balancer.group.regex.wait.time";
    private final TableId tableId;

    public RegexGroupBalancer(TableId tableId) {
        super(tableId);
        this.tableId = tableId;
    }

    @Override
    protected long getWaitTime() {
        ServiceEnvironment.Configuration conf = this.environment.getConfiguration(this.tableId);
        if (conf.isSet(WAIT_TIME_PROPERTY)) {
            return ConfigurationTypeHelper.getTimeInMillis(conf.get(WAIT_TIME_PROPERTY));
        }
        return super.getWaitTime();
    }

    @Override
    protected Function<TabletId, String> getPartitioner() {
        ServiceEnvironment.Configuration conf = this.environment.getConfiguration(this.tableId);
        String regex = conf.get(REGEX_PROPERTY);
        String defaultGroup = conf.get(DEFAUT_GROUP_PROPERTY);
        Pattern pattern = Pattern.compile(regex);
        return input -> {
            Text er = input.getEndRow();
            if (er == null) {
                return defaultGroup;
            }
            Matcher matcher = pattern.matcher(er.toString());
            if (matcher.matches() && matcher.groupCount() == 1) {
                return matcher.group(1);
            }
            return defaultGroup;
        };
    }
}

