/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.NamedNode;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.model.InterceptFromDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.FilterProcessor;
import org.apache.camel.processor.Pipeline;
import org.apache.camel.reifier.ProcessorReifier;

public class InterceptFromReifier
extends ProcessorReifier<InterceptFromDefinition> {
    public InterceptFromReifier(Route route, ProcessorDefinition<?> definition) {
        super(route, (InterceptFromDefinition)definition);
    }

    @Override
    public Processor createProcessor() throws Exception {
        Processor child = this.createChildProcessor(true);
        Predicate when = ((InterceptFromDefinition)this.definition).getOnWhen() != null ? this.createPredicate(((InterceptFromDefinition)this.definition).getOnWhen().getExpression()) : e -> true;
        Processor p = exchange -> {
            exchange.setProperty(ExchangePropertyKey.INTERCEPTED_ROUTE_ID, (Object)this.route.getId());
            exchange.setProperty(ExchangePropertyKey.INTERCEPTED_ROUTE_ENDPOINT_URI, (Object)this.route.getEndpoint().getEndpointUri());
            if (exchange.getFromEndpoint() != null) {
                exchange.setProperty(ExchangePropertyKey.INTERCEPTED_ENDPOINT, (Object)exchange.getFromEndpoint().getEndpointUri());
            }
        };
        FilterProcessor answer = new FilterProcessor(this.getCamelContext(), when, Pipeline.newInstance((CamelContext)this.getCamelContext(), (Processor[])new Processor[]{p, child}));
        answer.setDisabled(InterceptFromReifier.isDisabled(this.camelContext, (NamedNode)this.definition));
        return answer;
    }
}

