/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.List;
import org.apache.camel.builder.DataFormatBuilder;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(firstVersion="1.3.0", label="dataformat,transformation,csv", title="CSV")
@XmlRootElement(name="csv")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CsvDataFormat
extends DataFormatDefinition {
    @XmlAttribute
    @Metadata(label="advanced")
    private String formatRef;
    @XmlAttribute
    @Metadata(label="advanced", enums="DEFAULT,EXCEL,INFORMIX_UNLOAD,INFORMIX_UNLOAD_CSV,MYSQL,RFC4180", defaultValue="DEFAULT")
    private String formatName;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String commentMarkerDisabled;
    @XmlAttribute
    @Metadata(label="advanced")
    private String commentMarker;
    @XmlAttribute
    private String delimiter;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String escapeDisabled;
    @XmlAttribute
    @Metadata(label="advanced")
    private String escape;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String headerDisabled;
    @XmlElement
    private List<String> header;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String allowMissingColumnNames;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String ignoreEmptyLines;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String ignoreSurroundingSpaces;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String nullStringDisabled;
    @XmlAttribute
    @Metadata(label="advanced")
    private String nullString;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String quoteDisabled;
    @XmlAttribute
    private String quote;
    @XmlAttribute
    private String recordSeparatorDisabled;
    @XmlAttribute
    private String recordSeparator;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String skipHeaderRecord;
    @XmlAttribute
    @Metadata(enums="ALL,ALL_NON_NULL,MINIMAL,NON_NUMERIC,NONE")
    private String quoteMode;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String ignoreHeaderCase;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String trim;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String trailingDelimiter;
    @XmlAttribute
    @Metadata(label="advanced")
    private String marshallerFactoryRef;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String lazyLoad;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String useMaps;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String useOrderedMaps;
    @XmlAttribute
    @Metadata(label="advanced")
    private String recordConverterRef;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String captureHeaderRecord;

    public CsvDataFormat() {
        super("csv");
    }

    protected CsvDataFormat(CsvDataFormat source) {
        super(source);
        this.formatRef = source.formatRef;
        this.formatName = source.formatName;
        this.commentMarkerDisabled = source.commentMarkerDisabled;
        this.commentMarker = source.commentMarker;
        this.delimiter = source.delimiter;
        this.escapeDisabled = source.escapeDisabled;
        this.escape = source.escape;
        this.headerDisabled = source.headerDisabled;
        this.header = source.header;
        this.allowMissingColumnNames = source.allowMissingColumnNames;
        this.ignoreEmptyLines = source.ignoreEmptyLines;
        this.ignoreSurroundingSpaces = source.ignoreSurroundingSpaces;
        this.nullStringDisabled = source.nullStringDisabled;
        this.nullString = source.nullString;
        this.quoteDisabled = source.quoteDisabled;
        this.quote = source.quote;
        this.recordSeparatorDisabled = source.recordSeparatorDisabled;
        this.recordSeparator = source.recordSeparator;
        this.skipHeaderRecord = source.skipHeaderRecord;
        this.quoteMode = source.quoteMode;
        this.ignoreHeaderCase = source.ignoreHeaderCase;
        this.trim = source.trim;
        this.trailingDelimiter = source.trailingDelimiter;
        this.marshallerFactoryRef = source.marshallerFactoryRef;
        this.lazyLoad = source.lazyLoad;
        this.useMaps = source.useMaps;
        this.useOrderedMaps = source.useOrderedMaps;
        this.recordConverterRef = source.recordConverterRef;
        this.captureHeaderRecord = source.captureHeaderRecord;
    }

    public CsvDataFormat(String delimiter) {
        this();
        this.setDelimiter(delimiter);
    }

    public CsvDataFormat(boolean lazyLoad) {
        this();
        this.setLazyLoad(Boolean.toString(lazyLoad));
    }

    private CsvDataFormat(Builder builder) {
        this();
        this.formatRef = builder.formatRef;
        this.formatName = builder.formatName;
        this.commentMarkerDisabled = builder.commentMarkerDisabled;
        this.commentMarker = builder.commentMarker;
        this.delimiter = builder.delimiter;
        this.escapeDisabled = builder.escapeDisabled;
        this.escape = builder.escape;
        this.headerDisabled = builder.headerDisabled;
        this.header = builder.header;
        this.allowMissingColumnNames = builder.allowMissingColumnNames;
        this.ignoreEmptyLines = builder.ignoreEmptyLines;
        this.ignoreSurroundingSpaces = builder.ignoreSurroundingSpaces;
        this.nullStringDisabled = builder.nullStringDisabled;
        this.nullString = builder.nullString;
        this.quoteDisabled = builder.quoteDisabled;
        this.quote = builder.quote;
        this.recordSeparatorDisabled = builder.recordSeparatorDisabled;
        this.recordSeparator = builder.recordSeparator;
        this.skipHeaderRecord = builder.skipHeaderRecord;
        this.quoteMode = builder.quoteMode;
        this.ignoreHeaderCase = builder.ignoreHeaderCase;
        this.trim = builder.trim;
        this.trailingDelimiter = builder.trailingDelimiter;
        this.marshallerFactoryRef = builder.marshallerFactoryRef;
        this.lazyLoad = builder.lazyLoad;
        this.useMaps = builder.useMaps;
        this.useOrderedMaps = builder.useOrderedMaps;
        this.recordConverterRef = builder.recordConverterRef;
        this.captureHeaderRecord = builder.captureHeaderRecord;
    }

    @Override
    public CsvDataFormat copyDefinition() {
        return new CsvDataFormat(this);
    }

    public void setMarshallerFactoryRef(String marshallerFactoryRef) {
        this.marshallerFactoryRef = marshallerFactoryRef;
    }

    public String getMarshallerFactoryRef() {
        return this.marshallerFactoryRef;
    }

    public String getFormatRef() {
        return this.formatRef;
    }

    public void setFormatRef(String formatRef) {
        this.formatRef = formatRef;
    }

    public String getFormatName() {
        return this.formatName;
    }

    public void setFormatName(String formatName) {
        this.formatName = formatName;
    }

    public String getCommentMarkerDisabled() {
        return this.commentMarkerDisabled;
    }

    public void setCommentMarkerDisabled(String commentMarkerDisabled) {
        this.commentMarkerDisabled = commentMarkerDisabled;
    }

    public String getCommentMarker() {
        return this.commentMarker;
    }

    public void setCommentMarker(String commentMarker) {
        this.commentMarker = commentMarker;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getEscapeDisabled() {
        return this.escapeDisabled;
    }

    public void setEscapeDisabled(String escapeDisabled) {
        this.escapeDisabled = escapeDisabled;
    }

    public String getEscape() {
        return this.escape;
    }

    public void setEscape(String escape) {
        this.escape = escape;
    }

    public String getHeaderDisabled() {
        return this.headerDisabled;
    }

    public void setHeaderDisabled(String headerDisabled) {
        this.headerDisabled = headerDisabled;
    }

    public List<String> getHeader() {
        return this.header;
    }

    public void setHeader(List<String> header) {
        this.header = header;
    }

    public String getAllowMissingColumnNames() {
        return this.allowMissingColumnNames;
    }

    public void setAllowMissingColumnNames(String allowMissingColumnNames) {
        this.allowMissingColumnNames = allowMissingColumnNames;
    }

    public String getIgnoreEmptyLines() {
        return this.ignoreEmptyLines;
    }

    public void setIgnoreEmptyLines(String ignoreEmptyLines) {
        this.ignoreEmptyLines = ignoreEmptyLines;
    }

    public String getIgnoreSurroundingSpaces() {
        return this.ignoreSurroundingSpaces;
    }

    public void setIgnoreSurroundingSpaces(String ignoreSurroundingSpaces) {
        this.ignoreSurroundingSpaces = ignoreSurroundingSpaces;
    }

    public String getNullStringDisabled() {
        return this.nullStringDisabled;
    }

    public void setNullStringDisabled(String nullStringDisabled) {
        this.nullStringDisabled = nullStringDisabled;
    }

    public String getNullString() {
        return this.nullString;
    }

    public void setNullString(String nullString) {
        this.nullString = nullString;
    }

    public String getQuoteDisabled() {
        return this.quoteDisabled;
    }

    public void setQuoteDisabled(String quoteDisabled) {
        this.quoteDisabled = quoteDisabled;
    }

    public String getQuote() {
        return this.quote;
    }

    public void setQuote(String quote) {
        this.quote = quote;
    }

    public String getRecordSeparatorDisabled() {
        return this.recordSeparatorDisabled;
    }

    public void setRecordSeparatorDisabled(String recordSeparatorDisabled) {
        this.recordSeparatorDisabled = recordSeparatorDisabled;
    }

    public String getRecordSeparator() {
        return this.recordSeparator;
    }

    public void setRecordSeparator(String recordSeparator) {
        this.recordSeparator = recordSeparator;
    }

    public String getSkipHeaderRecord() {
        return this.skipHeaderRecord;
    }

    public void setSkipHeaderRecord(String skipHeaderRecord) {
        this.skipHeaderRecord = skipHeaderRecord;
    }

    public String getQuoteMode() {
        return this.quoteMode;
    }

    public void setQuoteMode(String quoteMode) {
        this.quoteMode = quoteMode;
    }

    public String getLazyLoad() {
        return this.lazyLoad;
    }

    public void setLazyLoad(String lazyLoad) {
        this.lazyLoad = lazyLoad;
    }

    public String getUseMaps() {
        return this.useMaps;
    }

    public void setUseMaps(String useMaps) {
        this.useMaps = useMaps;
    }

    public String getUseOrderedMaps() {
        return this.useOrderedMaps;
    }

    public void setUseOrderedMaps(String useOrderedMaps) {
        this.useOrderedMaps = useOrderedMaps;
    }

    public String getRecordConverterRef() {
        return this.recordConverterRef;
    }

    public void setRecordConverterRef(String recordConverterRef) {
        this.recordConverterRef = recordConverterRef;
    }

    public void setTrim(String trim) {
        this.trim = trim;
    }

    public String getTrim() {
        return this.trim;
    }

    public void setIgnoreHeaderCase(String ignoreHeaderCase) {
        this.ignoreHeaderCase = ignoreHeaderCase;
    }

    public String getIgnoreHeaderCase() {
        return this.ignoreHeaderCase;
    }

    public void setTrailingDelimiter(String trailingDelimiter) {
        this.trailingDelimiter = trailingDelimiter;
    }

    public String getTrailingDelimiter() {
        return this.trailingDelimiter;
    }

    public String getCaptureHeaderRecord() {
        return this.captureHeaderRecord;
    }

    public void setCaptureHeaderRecord(String captureHeaderRecord) {
        this.captureHeaderRecord = captureHeaderRecord;
    }

    @XmlTransient
    public static class Builder
    implements DataFormatBuilder<CsvDataFormat> {
        private String formatRef;
        private String formatName;
        private String commentMarkerDisabled;
        private String commentMarker;
        private String delimiter;
        private String escapeDisabled;
        private String escape;
        private String headerDisabled;
        private List<String> header;
        private String allowMissingColumnNames;
        private String ignoreEmptyLines;
        private String ignoreSurroundingSpaces;
        private String nullStringDisabled;
        private String nullString;
        private String quoteDisabled;
        private String quote;
        private String recordSeparatorDisabled;
        private String recordSeparator;
        private String skipHeaderRecord;
        private String quoteMode;
        private String ignoreHeaderCase;
        private String trim;
        private String trailingDelimiter;
        private String marshallerFactoryRef;
        private String lazyLoad;
        private String useMaps;
        private String useOrderedMaps;
        private String recordConverterRef;
        private String captureHeaderRecord;

        public Builder marshallerFactoryRef(String marshallerFactoryRef) {
            this.marshallerFactoryRef = marshallerFactoryRef;
            return this;
        }

        public Builder formatRef(String formatRef) {
            this.formatRef = formatRef;
            return this;
        }

        public Builder formatName(String formatName) {
            this.formatName = formatName;
            return this;
        }

        public Builder commentMarkerDisabled(String commentMarkerDisabled) {
            this.commentMarkerDisabled = commentMarkerDisabled;
            return this;
        }

        public Builder commentMarkerDisabled(boolean commentMarkerDisabled) {
            this.commentMarkerDisabled = Boolean.toString(commentMarkerDisabled);
            return this;
        }

        public Builder commentMarker(String commentMarker) {
            this.commentMarker = commentMarker;
            return this;
        }

        public Builder delimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public Builder escapeDisabled(String escapeDisabled) {
            this.escapeDisabled = escapeDisabled;
            return this;
        }

        public Builder escapeDisabled(boolean escapeDisabled) {
            this.escapeDisabled = Boolean.toString(escapeDisabled);
            return this;
        }

        public Builder escape(String escape) {
            this.escape = escape;
            return this;
        }

        public Builder headerDisabled(String headerDisabled) {
            this.headerDisabled = headerDisabled;
            return this;
        }

        public Builder headerDisabled(boolean headerDisabled) {
            this.headerDisabled = Boolean.toString(headerDisabled);
            return this;
        }

        public Builder header(List<String> header) {
            this.header = header;
            return this;
        }

        public Builder allowMissingColumnNames(String allowMissingColumnNames) {
            this.allowMissingColumnNames = allowMissingColumnNames;
            return this;
        }

        public Builder allowMissingColumnNames(boolean allowMissingColumnNames) {
            this.allowMissingColumnNames = Boolean.toString(allowMissingColumnNames);
            return this;
        }

        public Builder ignoreEmptyLines(String ignoreEmptyLines) {
            this.ignoreEmptyLines = ignoreEmptyLines;
            return this;
        }

        public Builder ignoreEmptyLines(boolean ignoreEmptyLines) {
            this.ignoreEmptyLines = Boolean.toString(ignoreEmptyLines);
            return this;
        }

        public Builder ignoreSurroundingSpaces(String ignoreSurroundingSpaces) {
            this.ignoreSurroundingSpaces = ignoreSurroundingSpaces;
            return this;
        }

        public Builder ignoreSurroundingSpaces(boolean ignoreSurroundingSpaces) {
            this.ignoreSurroundingSpaces = Boolean.toString(ignoreSurroundingSpaces);
            return this;
        }

        public Builder nullStringDisabled(String nullStringDisabled) {
            this.nullStringDisabled = nullStringDisabled;
            return this;
        }

        public Builder nullStringDisabled(boolean nullStringDisabled) {
            this.nullStringDisabled = Boolean.toString(nullStringDisabled);
            return this;
        }

        public Builder nullString(String nullString) {
            this.nullString = nullString;
            return this;
        }

        public Builder quoteDisabled(String quoteDisabled) {
            this.quoteDisabled = quoteDisabled;
            return this;
        }

        public Builder quoteDisabled(boolean quoteDisabled) {
            this.quoteDisabled = Boolean.toString(quoteDisabled);
            return this;
        }

        public Builder quote(String quote) {
            this.quote = quote;
            return this;
        }

        public Builder recordSeparatorDisabled(String recordSeparatorDisabled) {
            this.recordSeparatorDisabled = recordSeparatorDisabled;
            return this;
        }

        public Builder recordSeparator(String recordSeparator) {
            this.recordSeparator = recordSeparator;
            return this;
        }

        public Builder skipHeaderRecord(String skipHeaderRecord) {
            this.skipHeaderRecord = skipHeaderRecord;
            return this;
        }

        public Builder skipHeaderRecord(boolean skipHeaderRecord) {
            this.skipHeaderRecord = Boolean.toString(skipHeaderRecord);
            return this;
        }

        public Builder quoteMode(String quoteMode) {
            this.quoteMode = quoteMode;
            return this;
        }

        public Builder lazyLoad(String lazyLoad) {
            this.lazyLoad = lazyLoad;
            return this;
        }

        public Builder lazyLoad(boolean lazyLoad) {
            this.lazyLoad = Boolean.toString(lazyLoad);
            return this;
        }

        public Builder useMaps(String useMaps) {
            this.useMaps = useMaps;
            return this;
        }

        public Builder useMaps(boolean useMaps) {
            this.useMaps = Boolean.toString(useMaps);
            return this;
        }

        public Builder useOrderedMaps(String useOrderedMaps) {
            this.useOrderedMaps = useOrderedMaps;
            return this;
        }

        public Builder useOrderedMaps(boolean useOrderedMaps) {
            this.useOrderedMaps = Boolean.toString(useOrderedMaps);
            return this;
        }

        public Builder recordConverterRef(String recordConverterRef) {
            this.recordConverterRef = recordConverterRef;
            return this;
        }

        public Builder trim(String trim) {
            this.trim = trim;
            return this;
        }

        public Builder trim(boolean trim) {
            this.trim = Boolean.toString(trim);
            return this;
        }

        public Builder ignoreHeaderCase(String ignoreHeaderCase) {
            this.ignoreHeaderCase = ignoreHeaderCase;
            return this;
        }

        public Builder ignoreHeaderCase(boolean ignoreHeaderCase) {
            this.ignoreHeaderCase = Boolean.toString(ignoreHeaderCase);
            return this;
        }

        public Builder trailingDelimiter(String trailingDelimiter) {
            this.trailingDelimiter = trailingDelimiter;
            return this;
        }

        public Builder trailingDelimiter(boolean trailingDelimiter) {
            this.trailingDelimiter = Boolean.toString(trailingDelimiter);
            return this;
        }

        public Builder captureHeaderRecord(String captureHeaderRecord) {
            this.captureHeaderRecord = captureHeaderRecord;
            return this;
        }

        public Builder captureHeaderRecord(boolean captureHeaderRecord) {
            this.captureHeaderRecord = Boolean.toString(captureHeaderRecord);
            return this;
        }

        @Override
        public CsvDataFormat end() {
            return new CsvDataFormat(this);
        }
    }
}

