/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.querybuilder.select;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.SimpleStatementBuilder;
import com.datastax.oss.driver.api.core.data.CqlVector;
import com.datastax.oss.driver.api.core.metadata.schema.ClusteringOrder;
import com.datastax.oss.driver.api.querybuilder.BindMarker;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.relation.Relation;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.select.SelectFrom;
import com.datastax.oss.driver.api.querybuilder.select.Selector;
import com.datastax.oss.driver.internal.querybuilder.CqlHelper;
import com.datastax.oss.driver.internal.querybuilder.ImmutableCollections;
import com.datastax.oss.driver.internal.querybuilder.select.AllSelector;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public class DefaultSelect
implements SelectFrom,
Select {
    private static final ImmutableList<Selector> SELECT_ALL = ImmutableList.of((Object)AllSelector.INSTANCE);
    private final CqlIdentifier keyspace;
    private final CqlIdentifier table;
    private final boolean isJson;
    private final boolean isDistinct;
    private final ImmutableList<Selector> selectors;
    private final ImmutableList<Relation> relations;
    private final ImmutableList<Selector> groupByClauses;
    private final ImmutableMap<CqlIdentifier, ClusteringOrder> orderings;
    private final Ann ann;
    private final Object limit;
    private final Object perPartitionLimit;
    private final boolean allowsFiltering;

    public DefaultSelect(@Nullable CqlIdentifier keyspace, @NonNull CqlIdentifier table) {
        this(keyspace, table, false, false, (ImmutableList<Selector>)ImmutableList.of(), (ImmutableList<Relation>)ImmutableList.of(), (ImmutableList<Selector>)ImmutableList.of(), (ImmutableMap<CqlIdentifier, ClusteringOrder>)ImmutableMap.of(), null, null, null, false);
    }

    public DefaultSelect(@Nullable CqlIdentifier keyspace, @NonNull CqlIdentifier table, boolean isJson, boolean isDistinct, @NonNull ImmutableList<Selector> selectors, @NonNull ImmutableList<Relation> relations, @NonNull ImmutableList<Selector> groupByClauses, @NonNull ImmutableMap<CqlIdentifier, ClusteringOrder> orderings, @Nullable Ann ann, @Nullable Object limit, @Nullable Object perPartitionLimit, boolean allowsFiltering) {
        this.groupByClauses = groupByClauses;
        this.orderings = orderings;
        Preconditions.checkArgument((limit == null || limit instanceof Integer && (Integer)limit > 0 || limit instanceof BindMarker ? 1 : 0) != 0, (Object)"limit must be a strictly positive integer or a bind marker");
        Preconditions.checkArgument((orderings.isEmpty() || ann == null ? 1 : 0) != 0, (Object)"ANN ordering does not support secondary ordering");
        this.ann = ann;
        this.keyspace = keyspace;
        this.table = table;
        this.isJson = isJson;
        this.isDistinct = isDistinct;
        this.selectors = selectors;
        this.relations = relations;
        this.limit = limit;
        this.perPartitionLimit = perPartitionLimit;
        this.allowsFiltering = allowsFiltering;
    }

    @Override
    @NonNull
    public SelectFrom json() {
        return new DefaultSelect(this.keyspace, this.table, true, this.isDistinct, this.selectors, this.relations, this.groupByClauses, this.orderings, this.ann, this.limit, this.perPartitionLimit, this.allowsFiltering);
    }

    @Override
    @NonNull
    public SelectFrom distinct() {
        return new DefaultSelect(this.keyspace, this.table, this.isJson, true, this.selectors, this.relations, this.groupByClauses, this.orderings, this.ann, this.limit, this.perPartitionLimit, this.allowsFiltering);
    }

    @Override
    @NonNull
    public Select selector(@NonNull Selector selector) {
        ImmutableList<Selector> newSelectors = selector == AllSelector.INSTANCE ? SELECT_ALL : (SELECT_ALL.equals(this.selectors) ? ImmutableList.of((Object)selector) : ImmutableCollections.append(this.selectors, selector));
        return this.withSelectors(newSelectors);
    }

    @Override
    @NonNull
    public Select selectors(@NonNull Iterable<Selector> additionalSelectors) {
        ImmutableList.Builder newSelectors = ImmutableList.builder();
        if (!SELECT_ALL.equals(this.selectors)) {
            newSelectors.addAll(this.selectors);
        }
        for (Selector selector : additionalSelectors) {
            if (selector == AllSelector.INSTANCE) {
                throw new IllegalArgumentException("Can't pass the * selector to selectors()");
            }
            newSelectors.add((Object)selector);
        }
        return this.withSelectors((ImmutableList<Selector>)newSelectors.build());
    }

    @Override
    @NonNull
    public Select as(@NonNull CqlIdentifier alias) {
        if (SELECT_ALL.equals(this.selectors)) {
            throw new IllegalStateException("Can't alias the * selector");
        }
        if (this.selectors.isEmpty()) {
            throw new IllegalStateException("Can't alias, no selectors defined");
        }
        return this.withSelectors(ImmutableCollections.modifyLast(this.selectors, last -> last.as(alias)));
    }

    @NonNull
    public Select withSelectors(@NonNull ImmutableList<Selector> newSelectors) {
        return new DefaultSelect(this.keyspace, this.table, this.isJson, this.isDistinct, newSelectors, this.relations, this.groupByClauses, this.orderings, this.ann, this.limit, this.perPartitionLimit, this.allowsFiltering);
    }

    @Override
    @NonNull
    public Select where(@NonNull Relation relation) {
        return this.withRelations(ImmutableCollections.append(this.relations, relation));
    }

    @Override
    @NonNull
    public Select where(@NonNull Iterable<Relation> additionalRelations) {
        return this.withRelations(ImmutableCollections.concat(this.relations, additionalRelations));
    }

    @NonNull
    public Select withRelations(@NonNull ImmutableList<Relation> newRelations) {
        return new DefaultSelect(this.keyspace, this.table, this.isJson, this.isDistinct, this.selectors, newRelations, this.groupByClauses, this.orderings, this.ann, this.limit, this.perPartitionLimit, this.allowsFiltering);
    }

    @Override
    @NonNull
    public Select groupBy(@NonNull Selector groupByClause) {
        return this.withGroupByClauses(ImmutableCollections.append(this.groupByClauses, groupByClause));
    }

    @Override
    @NonNull
    public Select groupBy(@NonNull Iterable<Selector> newGroupByClauses) {
        return this.withGroupByClauses(ImmutableCollections.concat(this.groupByClauses, newGroupByClauses));
    }

    @NonNull
    public Select withGroupByClauses(@NonNull ImmutableList<Selector> newGroupByClauses) {
        return new DefaultSelect(this.keyspace, this.table, this.isJson, this.isDistinct, this.selectors, this.relations, newGroupByClauses, this.orderings, this.ann, this.limit, this.perPartitionLimit, this.allowsFiltering);
    }

    @Override
    @NonNull
    public Select orderBy(@NonNull CqlIdentifier columnId, @NonNull ClusteringOrder order) {
        return this.withOrderings(ImmutableCollections.append(this.orderings, columnId, order));
    }

    @Override
    @NonNull
    public Select orderByAnnOf(@NonNull String columnName, @NonNull CqlVector<?> ann) {
        return this.withAnn(new Ann(CqlIdentifier.fromCql((String)columnName), ann));
    }

    @Override
    @NonNull
    public Select orderByAnnOf(@NonNull CqlIdentifier columnId, @NonNull CqlVector<?> ann) {
        return this.withAnn(new Ann(columnId, ann));
    }

    @Override
    @NonNull
    public Select orderByIds(@NonNull Map<CqlIdentifier, ClusteringOrder> newOrderings) {
        return this.withOrderings(ImmutableCollections.concat(this.orderings, newOrderings));
    }

    @NonNull
    public Select withOrderings(@NonNull ImmutableMap<CqlIdentifier, ClusteringOrder> newOrderings) {
        return new DefaultSelect(this.keyspace, this.table, this.isJson, this.isDistinct, this.selectors, this.relations, this.groupByClauses, newOrderings, this.ann, this.limit, this.perPartitionLimit, this.allowsFiltering);
    }

    @NonNull
    Select withAnn(@NonNull Ann ann) {
        return new DefaultSelect(this.keyspace, this.table, this.isJson, this.isDistinct, this.selectors, this.relations, this.groupByClauses, this.orderings, ann, this.limit, this.perPartitionLimit, this.allowsFiltering);
    }

    @Override
    @NonNull
    public Select limit(int limit) {
        Preconditions.checkArgument((limit > 0 ? 1 : 0) != 0, (Object)"Limit must be strictly positive");
        return new DefaultSelect(this.keyspace, this.table, this.isJson, this.isDistinct, this.selectors, this.relations, this.groupByClauses, this.orderings, this.ann, limit, this.perPartitionLimit, this.allowsFiltering);
    }

    @Override
    @NonNull
    public Select limit(@Nullable BindMarker bindMarker) {
        return new DefaultSelect(this.keyspace, this.table, this.isJson, this.isDistinct, this.selectors, this.relations, this.groupByClauses, this.orderings, this.ann, bindMarker, this.perPartitionLimit, this.allowsFiltering);
    }

    @Override
    @NonNull
    public Select perPartitionLimit(int perPartitionLimit) {
        Preconditions.checkArgument((perPartitionLimit > 0 ? 1 : 0) != 0, (Object)"perPartitionLimit must be strictly positive");
        return new DefaultSelect(this.keyspace, this.table, this.isJson, this.isDistinct, this.selectors, this.relations, this.groupByClauses, this.orderings, this.ann, this.limit, perPartitionLimit, this.allowsFiltering);
    }

    @Override
    @NonNull
    public Select perPartitionLimit(@Nullable BindMarker bindMarker) {
        return new DefaultSelect(this.keyspace, this.table, this.isJson, this.isDistinct, this.selectors, this.relations, this.groupByClauses, this.orderings, this.ann, this.limit, bindMarker, this.allowsFiltering);
    }

    @Override
    @NonNull
    public Select allowFiltering() {
        return new DefaultSelect(this.keyspace, this.table, this.isJson, this.isDistinct, this.selectors, this.relations, this.groupByClauses, this.orderings, this.ann, this.limit, this.perPartitionLimit, true);
    }

    @Override
    @NonNull
    public String asCql() {
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT");
        if (this.isJson) {
            builder.append(" JSON");
        }
        if (this.isDistinct) {
            builder.append(" DISTINCT");
        }
        CqlHelper.append(this.selectors, builder, " ", ",", null);
        builder.append(" FROM ");
        CqlHelper.qualify(this.keyspace, this.table, builder);
        CqlHelper.append(this.relations, builder, " WHERE ", " AND ", null);
        CqlHelper.append(this.groupByClauses, builder, " GROUP BY ", ",", null);
        if (this.ann != null) {
            builder.append(" ORDER BY ").append(this.ann.columnId.asCql(true)).append(" ANN OF ");
            QueryBuilder.literal(this.ann.vector).appendTo(builder);
        } else {
            boolean first = true;
            for (Map.Entry entry : this.orderings.entrySet()) {
                if (first) {
                    builder.append(" ORDER BY ");
                    first = false;
                } else {
                    builder.append(",");
                }
                builder.append(((CqlIdentifier)entry.getKey()).asCql(true)).append(" ").append(((ClusteringOrder)entry.getValue()).name());
            }
        }
        if (this.limit != null) {
            builder.append(" LIMIT ");
            if (this.limit instanceof BindMarker) {
                ((BindMarker)this.limit).appendTo(builder);
            } else {
                builder.append(this.limit);
            }
        }
        if (this.perPartitionLimit != null) {
            builder.append(" PER PARTITION LIMIT ");
            if (this.perPartitionLimit instanceof BindMarker) {
                ((BindMarker)this.perPartitionLimit).appendTo(builder);
            } else {
                builder.append(this.perPartitionLimit);
            }
        }
        if (this.allowsFiltering) {
            builder.append(" ALLOW FILTERING");
        }
        return builder.toString();
    }

    @Override
    @NonNull
    public SimpleStatement build() {
        return this.builder().build();
    }

    @Override
    @NonNull
    public SimpleStatement build(Object ... values) {
        return this.builder().addPositionalValues(values).build();
    }

    @Override
    @NonNull
    public SimpleStatement build(@NonNull Map<String, Object> namedValues) {
        SimpleStatementBuilder builder = this.builder();
        for (Map.Entry<String, Object> entry : namedValues.entrySet()) {
            builder.addNamedValue(entry.getKey(), entry.getValue());
        }
        return builder.build();
    }

    @Override
    @NonNull
    public SimpleStatementBuilder builder() {
        return (SimpleStatementBuilder)SimpleStatement.builder((String)this.asCql()).setIdempotence(Boolean.valueOf(true));
    }

    @Nullable
    public CqlIdentifier getKeyspace() {
        return this.keyspace;
    }

    @NonNull
    public CqlIdentifier getTable() {
        return this.table;
    }

    public boolean isJson() {
        return this.isJson;
    }

    public boolean isDistinct() {
        return this.isDistinct;
    }

    @NonNull
    public ImmutableList<Selector> getSelectors() {
        return this.selectors;
    }

    @NonNull
    public ImmutableList<Relation> getRelations() {
        return this.relations;
    }

    @NonNull
    public ImmutableList<Selector> getGroupByClauses() {
        return this.groupByClauses;
    }

    @NonNull
    public ImmutableMap<CqlIdentifier, ClusteringOrder> getOrderings() {
        return this.orderings;
    }

    @Nullable
    public Object getLimit() {
        return this.limit;
    }

    @Nullable
    public Ann getAnn() {
        return this.ann;
    }

    @Nullable
    public Object getPerPartitionLimit() {
        return this.perPartitionLimit;
    }

    public boolean allowsFiltering() {
        return this.allowsFiltering;
    }

    public String toString() {
        return this.asCql();
    }

    public static class Ann {
        private final CqlVector<?> vector;
        private final CqlIdentifier columnId;

        private Ann(CqlIdentifier columnId, CqlVector<?> vector) {
            this.vector = vector;
            this.columnId = columnId;
        }
    }
}

