/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.acl.authentication;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.auth.authentication.CertificateCredentials;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.mtls.MutualTlsAuthentication;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.impl.AuthenticationHandlerImpl;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.sidecar.acl.IdentityToRoleCache;
import org.apache.cassandra.sidecar.common.utils.StringUtils;
import org.apache.cassandra.sidecar.utils.AuthUtils;
import org.apache.cassandra.sidecar.utils.HttpExceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MutualTlsAuthenticationHandler
extends AuthenticationHandlerImpl<MutualTlsAuthentication> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MutualTlsAuthenticationHandler.class);
    private final IdentityToRoleCache identityToRoleCache;

    public MutualTlsAuthenticationHandler(MutualTlsAuthentication authProvider, IdentityToRoleCache identityToRoleCache) {
        super((AuthenticationProvider)authProvider);
        this.identityToRoleCache = identityToRoleCache;
    }

    public void authenticate(RoutingContext ctx, Handler<AsyncResult<User>> handler) {
        if (!ctx.request().isSSL()) {
            handler.handle((Object)Future.failedFuture((Throwable)HttpExceptions.wrapHttpException(HttpResponseStatus.BAD_REQUEST, "SSL connection expected for mTLS auth")));
            return;
        }
        CertificateCredentials certificateCredentials = CertificateCredentials.fromHttpRequest((HttpServerRequest)ctx.request());
        if (certificateCredentials == null) {
            handler.handle((Object)Future.failedFuture((Throwable)HttpExceptions.wrapHttpException(HttpResponseStatus.UNAUTHORIZED, "Could not extract certificates from request")));
            return;
        }
        ((MutualTlsAuthentication)this.authProvider).authenticate((Credentials)certificateCredentials).recover(cause -> {
            throw HttpExceptions.wrapHttpException(HttpResponseStatus.UNAUTHORIZED, cause);
        }).andThen(authN -> {
            if (authN.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)HttpExceptions.wrapHttpException(HttpResponseStatus.UNAUTHORIZED, authN.cause())));
                return;
            }
            List<String> identities = AuthUtils.extractIdentities((User)authN.result());
            List<String> roles = this.extractCassandraRoles(identities);
            String roleIntended = ctx.request().getHeader("cassandra-auth-role");
            if (StringUtils.isNotEmpty((String)roleIntended) && !roles.contains(roleIntended)) {
                String errMsg = String.format("None of the identities %s are authorized for role %s", identities, roleIntended);
                handler.handle((Object)Future.failedFuture((Throwable)HttpExceptions.wrapHttpException(HttpResponseStatus.UNAUTHORIZED, errMsg)));
                return;
            }
            List<String> rolesToAdd = StringUtils.isNotEmpty((String)roleIntended) ? List.of(roleIntended) : roles;
            ((User)authN.result()).attributes().put("cassandra_roles", rolesToAdd);
            handler.handle(authN);
        });
    }

    private List<String> extractCassandraRoles(List<String> identities) {
        ArrayList<String> roles = new ArrayList<String>();
        try {
            for (String identity : identities) {
                String role = (String)this.identityToRoleCache.get(identity);
                if (role == null) continue;
                roles.add(role);
            }
        }
        catch (Exception e) {
            LOGGER.debug("Could not retrieve roles associated with the identities", (Throwable)e);
        }
        return roles;
    }
}

