/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.merge.token.model;

import org.apache.cayenne.dbsync.merge.context.MergerContext;
import org.apache.cayenne.dbsync.merge.factory.MergerTokenFactory;
import org.apache.cayenne.dbsync.merge.token.MergerToken;
import org.apache.cayenne.dbsync.merge.token.model.AbstractToModelToken;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Procedure;

public class CreateProcedureToModel
extends AbstractToModelToken {
    private Procedure procedure;

    public CreateProcedureToModel(Procedure procedure) {
        super("Add procedure to model", 125);
        this.procedure = procedure;
    }

    @Override
    public String getTokenValue() {
        return this.procedure.getName();
    }

    @Override
    public MergerToken createReverse(MergerTokenFactory factory) {
        return factory.createDropProcedureToDb(this.procedure);
    }

    @Override
    public void execute(MergerContext context) {
        DataMap dataMap = context.getDataMap();
        dataMap.addProcedure(this.procedure);
        context.getDelegate().procedureAdded(this.procedure);
    }
}

