/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.reverse.filters;

import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.cayenne.dbsync.reverse.filters.PatternFilter;

public class IncludeTableFilter
implements Comparable<IncludeTableFilter> {
    public final Pattern pattern;
    public final PatternFilter columnsFilter;
    public final PatternFilter relationshipFilter;

    public IncludeTableFilter(String pattern) {
        this(pattern, PatternFilter.INCLUDE_EVERYTHING, PatternFilter.INCLUDE_EVERYTHING);
    }

    public IncludeTableFilter(String pattern, PatternFilter columnsFilter) {
        this(pattern, columnsFilter, PatternFilter.INCLUDE_EVERYTHING);
    }

    public IncludeTableFilter(String pattern, PatternFilter columnsFilter, PatternFilter relationshipFilter) {
        this.pattern = PatternFilter.pattern(pattern);
        this.columnsFilter = columnsFilter;
        this.relationshipFilter = relationshipFilter;
    }

    public boolean isIncludeColumn(String name) {
        return this.columnsFilter.isIncluded(name);
    }

    public boolean isIncludeRelationship(String name) {
        return this.relationshipFilter.isIncluded(name);
    }

    @Override
    public int compareTo(IncludeTableFilter o) {
        if (this.pattern == null && o.pattern == null) {
            return 0;
        }
        if (this.pattern == null) {
            return 1;
        }
        if (o.pattern == null) {
            return -1;
        }
        return this.pattern.pattern().compareTo(o.pattern.pattern());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IncludeTableFilter that = (IncludeTableFilter)o;
        if (!Objects.equals(this.pattern, that.pattern)) {
            return false;
        }
        if (!Objects.equals(this.columnsFilter, that.columnsFilter)) {
            return false;
        }
        return Objects.equals(this.relationshipFilter, that.relationshipFilter);
    }

    public String toString() {
        return this.toString(new StringBuilder(), "").toString();
    }

    protected StringBuilder toString(StringBuilder res, String prefix) {
        res.append(prefix).append("Include: ").append(String.valueOf(this.pattern)).append(" Columns: ");
        this.columnsFilter.toString(res);
        res.append("\n");
        return res;
    }
}

