/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project;

import org.apache.cayenne.configuration.BaseConfigurationNodeVisitor;
import org.apache.cayenne.configuration.ConfigurationNameMapper;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.resource.Resource;

class ConfigurationSourceSetter
extends BaseConfigurationNodeVisitor<Void> {
    private final ConfigurationNameMapper configurationNameMapper;
    private Resource configurationSource;

    public ConfigurationSourceSetter(@Inject ConfigurationNameMapper configurationNameMapper) {
        this.configurationNameMapper = configurationNameMapper;
    }

    ConfigurationSourceSetter(Resource configurationSource, ConfigurationNameMapper configurationNameMapper) {
        this.configurationSource = configurationSource;
        this.configurationNameMapper = configurationNameMapper;
    }

    @Override
    public Void visitDataChannelDescriptor(DataChannelDescriptor node) {
        node.setConfigurationSource(this.configurationSource);
        for (DataNodeDescriptor childDescriptor : node.getNodeDescriptors()) {
            childDescriptor.setDataChannelDescriptor(node);
            childDescriptor.setConfigurationSource(this.configurationSource);
        }
        return null;
    }

    @Override
    public Void visitDataMap(DataMap node) {
        node.setConfigurationSource(this.configurationSource);
        this.updateLocationOf(node);
        return null;
    }

    private void updateLocationOf(DataMap node) {
        String dataMapLocation = this.getDatamapLocationByName(node.getName());
        node.setLocation(dataMapLocation);
    }

    private String getDatamapLocationByName(String name) {
        return this.configurationNameMapper.configurationLocation(DataMap.class, name);
    }
}

