/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.validation;

import java.util.function.Supplier;
import org.apache.cayenne.map.EJBQLQueryDescriptor;
import org.apache.cayenne.project.validation.BaseQueryValidator;
import org.apache.cayenne.project.validation.ConfigurationNodeValidator;
import org.apache.cayenne.project.validation.EJBQLStatementValidator;
import org.apache.cayenne.project.validation.Inspection;
import org.apache.cayenne.project.validation.ValidationConfig;
import org.apache.cayenne.validation.ValidationResult;

class EJBQLQueryValidator
extends BaseQueryValidator<EJBQLQueryDescriptor> {
    public EJBQLQueryValidator(Supplier<ValidationConfig> configSupplier) {
        super(configSupplier);
    }

    @Override
    protected ConfigurationNodeValidator.Performer<EJBQLQueryDescriptor> validateQuery(EJBQLQueryDescriptor query, ValidationResult validationResult) {
        return super.validateQuery(query, validationResult).performIfEnabled(Inspection.EJBQL_QUERY_INVALID_SYNTAX, this::validateSyntax);
    }

    private void validateSyntax(EJBQLQueryDescriptor query, ValidationResult validationResult) {
        EJBQLStatementValidator.PositionException message = new EJBQLStatementValidator().validateEJBQL(query);
        if (message != null) {
            this.addFailure(validationResult, query, "Error in EJBQL query '%s' syntax", query.getName());
        }
    }
}

