/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.types;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.dba.TypesMapping;

public class CalendarType<T extends Calendar>
implements ExtendedType<Calendar> {
    protected Class<T> calendarClass;

    public CalendarType(Class<T> calendarClass) {
        if (calendarClass == null) {
            throw new IllegalArgumentException("Null calendar class");
        }
        if (!Calendar.class.isAssignableFrom(calendarClass)) {
            throw new IllegalArgumentException("Must be a java.util.Calendar or a subclass: " + String.valueOf(calendarClass));
        }
        this.calendarClass = calendarClass;
    }

    @Override
    public String getClassName() {
        return this.calendarClass.getName();
    }

    @Override
    public Calendar materializeObject(ResultSet rs, int index, int type) throws Exception {
        Date val = null;
        switch (type) {
            case 93: {
                val = rs.getTimestamp(index);
                break;
            }
            case 91: {
                val = rs.getDate(index);
                break;
            }
            case 92: {
                val = rs.getTime(index);
                break;
            }
            default: {
                Object object = rs.getObject(index);
                if (object != null && !(object instanceof Date)) {
                    throw new CayenneRuntimeException("Expected an instance of java.util.Date, instead got %s, column index: %d", object.getClass().getName(), index);
                }
                val = (Date)object;
            }
        }
        if (val == null) {
            return null;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(val);
        return calendar;
    }

    @Override
    public Calendar materializeObject(CallableStatement rs, int index, int type) throws Exception {
        Date val = null;
        switch (type) {
            case 93: {
                val = rs.getTimestamp(index);
                break;
            }
            case 91: {
                val = rs.getDate(index);
                break;
            }
            case 92: {
                val = rs.getTime(index);
                break;
            }
            default: {
                Object object = rs.getObject(index);
                if (object != null && !(object instanceof Date)) {
                    throw new CayenneRuntimeException("Expected an instance of java.util.Date, instead got %s, column index: %d", object.getClass().getName(), index);
                }
                val = (Date)object;
            }
        }
        if (val == null) {
            return null;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(val);
        return calendar;
    }

    @Override
    public void setJdbcObject(PreparedStatement statement, Calendar value, int pos, int type, int precision) throws Exception {
        if (value == null) {
            statement.setNull(pos, type);
        } else {
            statement.setObject(pos, this.convertToJdbcObject(value, type));
        }
    }

    protected Object convertToJdbcObject(Calendar value, int type) throws Exception {
        if (type == 91) {
            return new java.sql.Date(value.getTimeInMillis());
        }
        if (type == 92) {
            return new Time(value.getTimeInMillis());
        }
        if (type == 93) {
            return new Timestamp(value.getTimeInMillis());
        }
        throw new IllegalArgumentException("Only DATE, TIME or TIMESTAMP can be mapped as '" + this.getClassName() + "', got " + TypesMapping.getSqlNameByType(type));
    }

    @Override
    public String toString(Calendar value) {
        if (value == null) {
            return "NULL";
        }
        return value.getClass().getName() + "(" + String.valueOf(new Timestamp(value.getTimeInMillis())) + ")";
    }
}

