/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.naming;

import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.cayenne.dbsync.naming.DbEntityNameStemmer;
import org.apache.cayenne.dbsync.naming.NoStemStemmer;
import org.apache.cayenne.dbsync.naming.ObjectNameGenerator;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.util.Util;
import org.jvnet.inflector.Noun;

public class DefaultObjectNameGenerator
implements ObjectNameGenerator {
    private DbEntityNameStemmer dbEntityNameStemmer;

    public DefaultObjectNameGenerator() {
        this.dbEntityNameStemmer = NoStemStemmer.getInstance();
    }

    public DefaultObjectNameGenerator(DbEntityNameStemmer dbEntityNameStemmer) {
        this.dbEntityNameStemmer = dbEntityNameStemmer;
    }

    @Override
    public String relationshipName(DbRelationship ... relationshipChain) {
        if (relationshipChain == null || relationshipChain.length < 1) {
            throw new IllegalArgumentException("At least on relationship is expected: " + String.valueOf(relationshipChain));
        }
        String name = this.isToMany(relationshipChain) ? this.toManyRelationshipName(relationshipChain) : this.toOneRelationshipName(relationshipChain);
        return Util.underscoredToJava(name, false);
    }

    protected boolean isToMany(DbRelationship ... relationshipChain) {
        for (DbRelationship r : relationshipChain) {
            if (!r.isToMany()) continue;
            return true;
        }
        return false;
    }

    protected String stemmed(String dbEntityName) {
        return this.dbEntityNameStemmer.stem(Objects.requireNonNull(dbEntityName));
    }

    protected String toManyRelationshipName(DbRelationship ... relationshipChain) {
        DbRelationship last = relationshipChain[relationshipChain.length - 1];
        String baseName = this.stemmed(last.getTargetEntityName());
        try {
            return Noun.pluralOf(baseName.toLowerCase(), Locale.ENGLISH);
        }
        catch (Exception inflectorError) {
            return baseName;
        }
    }

    protected String toOneRelationshipName(DbRelationship ... relationshipChain) {
        DbRelationship first = relationshipChain[0];
        DbRelationship last = relationshipChain[relationshipChain.length - 1];
        List<DbJoin> joins = first.getJoins();
        if (joins.isEmpty()) {
            return this.stemmed(last.getTargetEntityName());
        }
        DbJoin join1 = joins.get(0);
        String fkColName = join1.getSourceName();
        if (fkColName == null) {
            return this.stemmed(last.getTargetEntityName());
        }
        if (fkColName.toUpperCase().endsWith("_ID") && fkColName.length() > 3) {
            return fkColName.substring(0, fkColName.length() - 3);
        }
        if (fkColName.toUpperCase().endsWith("ID") && fkColName.length() > 2) {
            return fkColName.substring(0, fkColName.length() - 2);
        }
        return this.stemmed(last.getTargetEntityName());
    }

    @Override
    public String objEntityName(DbEntity dbEntity) {
        String baseName = this.stemmed(dbEntity.getName());
        return Util.underscoredToJava(baseName, true);
    }

    @Override
    public String objAttributeName(DbAttribute attr) {
        return Util.underscoredToJava(attr.getName(), false);
    }
}

