/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.reverse.dbload;

import org.apache.cayenne.dbsync.reverse.filters.FiltersConfig;
import org.apache.cayenne.dbsync.reverse.filters.PatternFilter;
import org.apache.cayenne.dbsync.reverse.filters.TableFilter;

public class DbLoaderConfiguration {
    private Boolean skipRelationshipsLoading;
    private Boolean skipPrimaryKeyLoading;
    private String[] tableTypes;
    private FiltersConfig filtersConfig;

    public String[] getTableTypes() {
        return this.tableTypes;
    }

    public void setTableTypes(String[] tableTypes) {
        this.tableTypes = tableTypes;
    }

    public FiltersConfig getFiltersConfig() {
        if (this.filtersConfig == null) {
            return FiltersConfig.create(null, null, TableFilter.everything(), PatternFilter.INCLUDE_NOTHING);
        }
        return this.filtersConfig;
    }

    public void setFiltersConfig(FiltersConfig filtersConfig) {
        this.filtersConfig = filtersConfig;
    }

    public boolean isSkipRelationshipsLoading() {
        return this.skipRelationshipsLoading != null && this.skipRelationshipsLoading != false;
    }

    public void setSkipRelationshipsLoading(Boolean skipRelationshipsLoading) {
        this.skipRelationshipsLoading = skipRelationshipsLoading;
    }

    public boolean isSkipPrimaryKeyLoading() {
        return this.skipPrimaryKeyLoading != null && this.skipPrimaryKeyLoading != false;
    }

    public void setSkipPrimaryKeyLoading(Boolean skipPrimaryKeyLoading) {
        this.skipPrimaryKeyLoading = skipPrimaryKeyLoading;
    }

    public String toString() {
        String res = "EntitiesFilters: " + String.valueOf(this.getFiltersConfig());
        if (this.isSkipRelationshipsLoading()) {
            res = res + "\n Skip Loading Relationships! \n";
        }
        if (this.isSkipPrimaryKeyLoading()) {
            res = res + "\n Skip Loading PrimaryKeys! \n";
        }
        return res;
    }
}

