/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.di.spi;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.di.DIRuntimeException;

class DIGraph<V> {
    private Map<V, List<V>> neighbors = new LinkedHashMap<V, List<V>>();

    public void add(V vertex) {
        if (this.neighbors.containsKey(vertex)) {
            return;
        }
        this.neighbors.put(vertex, new ArrayList());
    }

    public void addAll(Collection<V> vertexes) {
        for (V vertex : vertexes) {
            this.add(vertex);
        }
    }

    public void add(V from, V to) {
        this.add(from);
        this.add(to);
        this.neighbors.get(from).add(to);
    }

    public void addWithOverride(V from, V to) {
        this.add(from, to);
        this.neighbors.get(to).remove(from);
    }

    public boolean contains(V vertex) {
        return this.neighbors.containsKey(vertex);
    }

    public void remove(V from, V to) {
        if (!this.contains(from) || !this.contains(to)) {
            throw new IllegalArgumentException("Nonexistent vertex");
        }
        this.neighbors.get(from).remove(to);
    }

    public Map<V, Integer> outDegree() {
        LinkedHashMap<V, Integer> result = new LinkedHashMap<V, Integer>();
        for (Map.Entry<V, List<V>> entry : this.neighbors.entrySet()) {
            result.put(entry.getKey(), entry.getValue().size());
        }
        return result;
    }

    public Map<V, Integer> inDegree() {
        LinkedHashMap<V, Integer> result = new LinkedHashMap<V, Integer>();
        for (V v : this.neighbors.keySet()) {
            result.put(v, 0);
        }
        for (V from : this.neighbors.keySet()) {
            for (V to : this.neighbors.get(from)) {
                result.put(to, (Integer)result.get(to) + 1);
            }
        }
        return result;
    }

    public List<V> topSort() {
        Map<Integer, Integer> degree = this.inDegree();
        ArrayDeque<V> zeroDegree = new ArrayDeque<V>();
        LinkedList result = new LinkedList();
        for (Map.Entry<V, Integer> entry : degree.entrySet()) {
            if (entry.getValue() != 0) continue;
            zeroDegree.push(entry.getKey());
        }
        while (!zeroDegree.isEmpty()) {
            Object v = zeroDegree.pop();
            result.push(v);
            for (V neighbor : this.neighbors.get(v)) {
                degree.put((Integer)neighbor, degree.get(neighbor) - 1);
                if (degree.get(neighbor) != 0) continue;
                zeroDegree.push(neighbor);
            }
        }
        if (result.size() != this.neighbors.size()) {
            throw new DIRuntimeException("Dependency cycle detected in DI container", new Object[0]);
        }
        return result;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        for (Map.Entry<V, List<V>> entry : this.neighbors.entrySet()) {
            s.append("\n    " + String.valueOf(entry.getKey()) + " -> " + String.valueOf(entry.getValue()));
        }
        return s.toString();
    }

    public int size() {
        return this.neighbors.size();
    }
}

