/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.cgen.templateeditor;

import java.io.StringWriter;
import java.io.Writer;
import org.apache.cayenne.configuration.xml.DataChannelMetaData;
import org.apache.cayenne.di.Injector;
import org.apache.cayenne.di.Key;
import org.apache.cayenne.gen.ArtifactsGenerationMode;
import org.apache.cayenne.gen.CgenConfiguration;
import org.apache.cayenne.gen.CgenTemplate;
import org.apache.cayenne.gen.ClassGenerationAction;
import org.apache.cayenne.gen.ClassGenerationActionFactory;
import org.apache.cayenne.gen.TemplateType;
import org.apache.cayenne.modeler.editor.cgen.templateeditor.ArtefactsConfigurator;
import org.apache.cayenne.modeler.editor.cgen.templateeditor.PreviewClassGenerationFactory;
import org.apache.cayenne.modeler.editor.cgen.templateeditor.TemplateEditorController;
import org.apache.cayenne.tools.ToolsInjectorBuilder;

public class PreviewActionConfigurator {
    public static final String TEMPLATE_EDITOR_WRITER = "tplEditorWriter";
    private static final Key<StringWriter> TPL_EDITOR_WRITER = Key.get(StringWriter.class, "tplEditorWriter");
    private final TemplateEditorController editorController;
    private final TemplateType templateType;
    private final ArtefactsConfigurator artefactsConfigurator;
    private final Injector injector;

    public PreviewActionConfigurator(TemplateEditorController editorController) {
        this.editorController = editorController;
        this.templateType = editorController.getTemplateType();
        this.artefactsConfigurator = editorController.getArtefactsConfigurator();
        this.injector = this.getInjector();
    }

    private Injector getInjector() {
        DataChannelMetaData metaData = this.editorController.getApplication().getMetaData();
        return new ToolsInjectorBuilder().addModule(binder -> binder.bind(DataChannelMetaData.class).toInstance(metaData)).addModule(binder -> binder.bind(ClassGenerationActionFactory.class).to(PreviewClassGenerationFactory.class)).addModule(binder -> binder.bind(TPL_EDITOR_WRITER).to(StringWriter.class)).create();
    }

    public ClassGenerationAction preparePreviewAction(String templateText) {
        CgenConfiguration previewCgenConfiguration = this.createPreviewCgenConfiguration();
        this.setTemplateTextInCgenConfig(templateText, previewCgenConfiguration);
        ClassGenerationAction action = this.injector.getInstance(ClassGenerationActionFactory.class).createAction(previewCgenConfiguration);
        this.artefactsConfigurator.config(action, this.editorController.getSelectedArtifactName());
        return action;
    }

    private void setTemplateTextInCgenConfig(String templateText, CgenConfiguration previewCgenConfiguration) {
        switch (this.templateType) {
            case ENTITY_SUPERCLASS: 
            case ENTITY_SUBCLASS: {
                previewCgenConfiguration.setTemplate(new CgenTemplate(templateText, false, TemplateType.ENTITY_SUPERCLASS));
                break;
            }
            case EMBEDDABLE_SUPERCLASS: 
            case EMBEDDABLE_SUBCLASS: {
                previewCgenConfiguration.setEmbeddableTemplate(new CgenTemplate(templateText, false, TemplateType.EMBEDDABLE_SUBCLASS));
                break;
            }
            case DATAMAP_SUPERCLASS: 
            case DATAMAP_SUBCLASS: {
                previewCgenConfiguration.setDataMapTemplate(new CgenTemplate(templateText, false, TemplateType.DATAMAP_SUBCLASS));
                break;
            }
            default: {
                throw new IllegalStateException("Illegal template type " + String.valueOf((Object)this.templateType));
            }
        }
    }

    private CgenConfiguration createPreviewCgenConfiguration() {
        CgenConfiguration cgenConfiguration = new CgenConfiguration();
        cgenConfiguration.setDataMap(this.editorController.getCurrentDataMap());
        cgenConfiguration.setMakePairs(false);
        cgenConfiguration.setArtifactsGenerationMode(ArtifactsGenerationMode.ALL.getLabel());
        return cgenConfiguration;
    }

    public Writer getWriter() {
        return this.injector.getInstance(TPL_EDITOR_WRITER);
    }
}

