/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.swing;

import java.util.Map;
import ognl.Ognl;
import ognl.OgnlException;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.swing.BindingBase;
import org.apache.cayenne.swing.BindingException;
import org.apache.cayenne.util.Util;

public class BindingExpression {
    private Object compiled;
    protected String expression;

    static Throwable unwind(Throwable th) {
        if (th instanceof OgnlException) {
            Throwable reason = ((OgnlException)th).getReason();
            return reason != null ? BindingExpression.unwind(reason) : th;
        }
        return Util.unwindException(th);
    }

    public BindingExpression(String expression) {
        try {
            this.compiled = Ognl.parseExpression(expression);
        }
        catch (OgnlException ex) {
            throw new CayenneRuntimeException("Invalid expression - " + expression, BindingBase.unwind(ex), new Object[0]);
        }
        this.expression = expression;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setValue(Object context, Map contextVariables, Object value) {
        if (context == null) {
            throw new BindingException("No context", new Object[0]);
        }
        try {
            Ognl.setValue(this.compiled, contextVariables, context, value);
        }
        catch (OgnlException ex) {
            throw new BindingException("Evaluation failed in context: " + String.valueOf(context), BindingExpression.unwind(ex), new Object[0]);
        }
    }

    public Object getValue(Object context, Map contextVariables) {
        if (context == null) {
            throw new BindingException("No context", new Object[0]);
        }
        try {
            return Ognl.getValue(this.compiled, contextVariables, context);
        }
        catch (OgnlException ex) {
            throw new BindingException("Evaluation failed in context: " + String.valueOf(context), BindingExpression.unwind(ex), new Object[0]);
        }
    }
}

