/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import java.util.Collections;
import java.util.Map;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.util.HashCodeBuilder;
import org.apache.cayenne.util.SingleEntryMap;
import org.apache.cayenne.util.Util;

class ObjectIdSingle
implements ObjectId {
    private static final long serialVersionUID = 3968183354758914938L;
    private final String entityName;
    private final String keyName;
    private final Object value;
    private transient int hashCode;
    private SingleEntryMap<String, Object> replacementId;

    private ObjectIdSingle() {
        this.entityName = "";
        this.keyName = "";
        this.value = null;
    }

    ObjectIdSingle(String entityName, String keyName, Object value) {
        this.entityName = entityName;
        this.keyName = keyName;
        this.value = value;
    }

    @Override
    public boolean isTemporary() {
        return false;
    }

    @Override
    public String getEntityName() {
        return this.entityName;
    }

    @Override
    public byte[] getKey() {
        return null;
    }

    @Override
    public Map<String, Object> getIdSnapshot() {
        return Collections.singletonMap(this.keyName, this.value);
    }

    @Override
    public Map<String, Object> getReplacementIdMap() {
        if (this.replacementId == null) {
            this.replacementId = new SingleEntryMap(this.keyName);
        }
        return this.replacementId;
    }

    @Override
    public ObjectId createReplacementId() {
        Object newValue = this.replacementId == null ? null : this.replacementId.getValue();
        return newValue == null ? this : ObjectId.of(this.entityName, this.keyName, newValue);
    }

    @Override
    public boolean isReplacementIdAttached() {
        return this.replacementId != null && !this.replacementId.isEmpty();
    }

    public String toString() {
        return "<ObjectId:" + this.entityName + ", " + this.keyName + "=" + String.valueOf(this.value) + ">";
    }

    String getKeyName() {
        return this.keyName;
    }

    Object getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectIdSingle that = (ObjectIdSingle)o;
        if (!Util.nullSafeEquals(this.entityName, that.entityName)) {
            return false;
        }
        return Util.nullSafeEquals(this.value, that.value);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = new HashCodeBuilder().append(this.entityName).append(this.value).toHashCode();
        }
        return this.hashCode;
    }
}

