/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.util.AbstractMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.jexl3.internal.SoftCache;

class SpreadMap<K, V>
extends AbstractMap<K, V> {
    private final Map<K, V>[] maps;

    private static int closestPowerOf2(int cap) {
        return cap > 1 ? Integer.highestOneBit(cap - 1) << 1 : 1;
    }

    SpreadMap(int capacity) {
        int spread = SpreadMap.closestPowerOf2(Runtime.getRuntime().availableProcessors());
        this.maps = new Map[spread];
        int mapCapacity = (capacity + spread + 1) / spread;
        for (int m = 0; m < spread; ++m) {
            this.maps[m] = SoftCache.createSynchronizedLinkedHashMap((int)mapCapacity);
        }
    }

    @Override
    public void clear() {
        for (Map<K, V> map : this.maps) {
            map.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        LinkedHashSet<Map.Entry<K, V>> entries = new LinkedHashSet<Map.Entry<K, V>>(this.size());
        Map<K, V>[] mapArray = this.maps;
        int n = mapArray.length;
        for (int i = 0; i < n; ++i) {
            Map<K, V> map;
            Map<K, V> map2 = map = mapArray[i];
            synchronized (map2) {
                entries.addAll(map.entrySet());
                continue;
            }
        }
        return entries;
    }

    @Override
    public V get(Object key) {
        return this.getMap(key).get(key);
    }

    private final Map<K, V> getMap(Object key) {
        int h = key.hashCode();
        h ^= h >>> 16;
        return this.maps[h & this.maps.length - 1];
    }

    @Override
    public V put(K key, V value) {
        return this.getMap(key).put(key, value);
    }

    @Override
    public V remove(Object key) {
        return this.getMap(key).remove(key);
    }

    @Override
    public int size() {
        int size = 0;
        for (Map<K, V> map : this.maps) {
            size += map.size();
        }
        return size;
    }
}

