/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.combinatorics;

import org.apache.commons.numbers.combinatorics.BinomialCoefficient;
import org.apache.commons.numbers.combinatorics.Factorial;

public final class BinomialCoefficientDouble {
    private static final int MAX_FACTORIAL = 170;
    private static final int LIMIT_N_LONG = 66;
    private static final int MAX_M = 514;
    private static final int SMALL_N = 1020;
    private static final int SMALL_M = 37;

    private BinomialCoefficientDouble() {
    }

    public static double value(int n, int k) {
        double result;
        if (n <= 66) {
            return BinomialCoefficient.value(n, k);
        }
        int m = BinomialCoefficient.checkBinomial(n, k);
        if (m == 0) {
            return 1.0;
        }
        if (m == 1) {
            return n;
        }
        if (n <= 170) {
            result = Factorial.uncheckedFactorial(n) / Factorial.uncheckedFactorial(m) / Factorial.uncheckedFactorial(n - m);
        } else if (n <= 1020 || m <= 37) {
            result = 1.0;
            for (int i = 1; i <= m; ++i) {
                result *= (double)(n - m + i);
                result /= (double)i;
            }
        } else {
            int i;
            if (m > 514) {
                return Double.POSITIVE_INFINITY;
            }
            result = 1.0;
            for (i = 1; i <= 37; ++i) {
                result *= (double)(n - m + i);
                result /= (double)i;
            }
            for (i = 38; i <= m; ++i) {
                double next = result * (double)(n - m + i);
                if (next > Double.MAX_VALUE) {
                    result /= (double)i;
                    if (!((result *= (double)(n - m + i)) > Double.MAX_VALUE)) continue;
                    return Double.POSITIVE_INFINITY;
                }
                result = next / (double)i;
            }
        }
        return Math.floor(result + 0.5);
    }
}

