/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.http;

import java.io.File;
import java.time.Duration;
import org.apache.commons.vfs2.AbstractProviderTestConfig;
import org.apache.commons.vfs2.FileNotFolderException;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.ProviderTestSuite;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.VfsTestUtils;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.http.HttpFileProvider;
import org.apache.commons.vfs2.provider.http.HttpFileSystemConfigBuilder;
import org.apache.commons.vfs2.util.NHttpFileServer;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class HttpProviderTestCase
extends AbstractProviderTestConfig {
    private static final Duration ONE_MINUTE = Duration.ofMinutes(1L);
    private static NHttpFileServer server;
    private static final String TEST_URI = "test.http.uri";
    private static String connectionUri;

    private static String getSystemTestUriOverride() {
        return System.getProperty(TEST_URI);
    }

    private static void setUpClass() throws Exception {
        server = NHttpFileServer.start(0, new File(VfsTestUtils.getTestDirectory()), 5000L);
        connectionUri = HttpProviderTestCase.getLocalHostUriString("http", server.getPort());
    }

    public static junit.framework.Test suite() throws Exception {
        return new ProviderTestSuite(new HttpProviderTestCase()){

            @Override
            protected void addBaseTests() throws Exception {
                super.addBaseTests();
                this.addTests(HttpProviderTestCase.class);
            }

            @Override
            protected void setUp() throws Exception {
                if (HttpProviderTestCase.getSystemTestUriOverride() == null) {
                    HttpProviderTestCase.setUpClass();
                }
                super.setUp();
            }

            @Override
            protected void tearDown() throws Exception {
                HttpProviderTestCase.tearDownClass();
                super.tearDown();
            }
        };
    }

    private static void tearDownClass() {
        if (server != null) {
            server.close();
        }
    }

    private void checkReadTestsFolder(FileObject file) throws FileSystemException {
        Assertions.assertNotNull((Object)file.getChildren());
        Assertions.assertTrue((file.getChildren().length > 0 ? 1 : 0) != 0);
    }

    @Override
    public FileObject getBaseTestFolder(FileSystemManager manager) throws Exception {
        String uri = HttpProviderTestCase.getSystemTestUriOverride();
        if (uri == null) {
            uri = connectionUri;
        }
        return manager.resolveFile(uri);
    }

    public void ignoreTestHttp405() throws FileSystemException {
        try (FileObject fileObject = VFS.getManager().resolveFile("http://www.w3schools.com/webservices/tempconvert.asmx?action=WSDL");){
            Assertions.assertTrue((fileObject.getContent().getSize() > 0L ? 1 : 0) != 0, (String)"Content size should be > 0");
            Assertions.assertFalse((boolean)fileObject.getContent().isEmpty(), (String)"Content should not be empty");
        }
    }

    @Override
    public void prepare(DefaultFileSystemManager manager) throws Exception {
        manager.addProvider("http", (FileProvider)new HttpFileProvider());
    }

    @Test
    public void testHttpTimeoutConfig() {
        FileSystemOptions options = new FileSystemOptions();
        HttpFileSystemConfigBuilder builder = HttpFileSystemConfigBuilder.getInstance();
        HttpProviderTestCase.assertEquals((int)0, (int)builder.getConnectionTimeout(options));
        HttpProviderTestCase.assertEquals((long)0L, (long)builder.getConnectionTimeoutDuration(options).toMillis());
        HttpProviderTestCase.assertEquals((int)0, (int)builder.getSoTimeout(options));
        HttpProviderTestCase.assertEquals((String)"Jakarta-Commons-VFS", (String)builder.getUserAgent(options));
        builder.setConnectionTimeout(options, 60000);
        builder.setSoTimeout(options, 60000);
        builder.setUserAgent(options, "foo/bar");
        HttpProviderTestCase.assertEquals((int)60000, (int)builder.getConnectionTimeout(options));
        HttpProviderTestCase.assertEquals((Object)ONE_MINUTE, (Object)builder.getConnectionTimeoutDuration(options));
        HttpProviderTestCase.assertEquals((int)60000, (int)builder.getSoTimeout(options));
        HttpProviderTestCase.assertEquals((String)"foo/bar", (String)builder.getUserAgent(options));
        builder.setConnectionTimeout(options, ONE_MINUTE);
        builder.setSoTimeout(options, ONE_MINUTE);
        HttpProviderTestCase.assertEquals((int)60000, (int)builder.getConnectionTimeout(options));
        HttpProviderTestCase.assertEquals((Object)ONE_MINUTE, (Object)builder.getConnectionTimeoutDuration(options));
        HttpProviderTestCase.assertEquals((int)60000, (int)builder.getSoTimeout(options));
        HttpProviderTestCase.assertEquals((Object)ONE_MINUTE, (Object)builder.getSoTimeoutDuration(options));
        HttpProviderTestCase.assertEquals((String)"foo/bar", (String)builder.getUserAgent(options));
    }

    private void testResolveFolderSlash(String uri, boolean followRedirect) throws FileSystemException {
        VFS.getManager().getFilesCache().close();
        FileSystemOptions opts = new FileSystemOptions();
        HttpFileSystemConfigBuilder.getInstance().setFollowRedirect(opts, followRedirect);
        try (FileObject file = VFS.getManager().resolveFile(uri, opts);){
            this.checkReadTestsFolder(file);
        }
        catch (FileNotFolderException fileNotFolderException) {
            // empty catch block
        }
    }

    @Test
    public void testResolveFolderSlashNoRedirectOff() throws FileSystemException {
        this.testResolveFolderSlash(connectionUri + "/read-tests", false);
    }

    @Test
    public void testResolveFolderSlashNoRedirectOn() throws FileSystemException {
        this.testResolveFolderSlash(connectionUri + "/read-tests", true);
    }

    @Test
    public void testResolveFolderSlashYesRedirectOff() throws FileSystemException {
        this.testResolveFolderSlash(connectionUri + "/read-tests/", false);
    }

    @Test
    public void testResolveFolderSlashYesRedirectOn() throws FileSystemException {
        this.testResolveFolderSlash(connectionUri + "/read-tests/", true);
    }

    @Test
    public void testResolveIPv6Url() throws FileSystemException {
        String ipv6Url = "http://[fe80::1c42:dae:8370:aea6%en1]/file.txt";
        FileObject fileObject = VFS.getManager().resolveFile("http://[fe80::1c42:dae:8370:aea6%en1]/file.txt", new FileSystemOptions());
        HttpProviderTestCase.assertEquals((String)"http://[fe80::1c42:dae:8370:aea6%en1]/", (String)fileObject.getFileSystem().getRootURI());
        HttpProviderTestCase.assertEquals((String)"http://[fe80::1c42:dae:8370:aea6%en1]/file.txt", (String)fileObject.getName().getURI());
    }
}

