/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.common;

import org.apache.cxf.rs.security.jose.common.JoseException;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rs.security.jose.jwe.JweUtils;
import org.apache.cxf.rs.security.jose.jws.JwsHeaders;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;

public abstract class AbstractJoseConsumer {
    private boolean jwsRequired = true;
    private boolean jweRequired;
    private JweDecryptionProvider jweDecryptor;
    private JwsSignatureVerifier jwsVerifier;

    public void setJweDecryptor(JweDecryptionProvider jweDecryptor) {
        this.jweDecryptor = jweDecryptor;
    }

    public JweDecryptionProvider getJweDecryptor() {
        return this.jweDecryptor;
    }

    public void setJwsVerifier(JwsSignatureVerifier theJwsVerifier) {
        this.jwsVerifier = theJwsVerifier;
    }

    public JwsSignatureVerifier getJwsVerifier() {
        return this.jwsVerifier;
    }

    protected JweDecryptionProvider getInitializedDecryptionProvider(JweHeaders jweHeaders) {
        if (this.jweDecryptor != null) {
            return this.jweDecryptor;
        }
        return JweUtils.loadDecryptionProvider(jweHeaders, false);
    }

    protected JwsSignatureVerifier getInitializedSignatureVerifier(JwsHeaders jwsHeaders) {
        if (this.jwsVerifier != null) {
            return this.jwsVerifier;
        }
        return JwsUtils.loadSignatureVerifier(jwsHeaders, false);
    }

    public boolean isJwsRequired() {
        return this.jwsRequired;
    }

    public void setJwsRequired(boolean jwsRequired) {
        this.jwsRequired = jwsRequired;
    }

    public boolean isJweRequired() {
        return this.jweRequired;
    }

    public void setJweRequired(boolean jweRequired) {
        this.jweRequired = jweRequired;
    }

    protected void checkProcessRequirements() {
        if (!this.isJwsRequired() && !this.isJweRequired()) {
            throw new JoseException("Unable to process the data");
        }
    }
}

