/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.server.handlers.Cookie;
import io.undertow.server.handlers.CookieSameSiteMode;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;

public class CookieImpl
implements Cookie {
    private final String name;
    private String value;
    private String path;
    private String domain;
    private Integer maxAge;
    private Date expires;
    private boolean discard;
    private boolean secure;
    private boolean httpOnly;
    private int version = 0;
    private String comment;
    private boolean sameSite;
    private String sameSiteMode;
    private final Map<String, String> attributes;

    public CookieImpl(String name, String value) {
        this.name = name;
        this.value = value;
        this.attributes = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    }

    public CookieImpl(String name) {
        this.name = name;
        this.attributes = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public CookieImpl setValue(String value) {
        this.value = value;
        return this;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public CookieImpl setPath(String path) {
        this.path = path;
        return this;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public CookieImpl setDomain(String domain) {
        this.domain = domain;
        return this;
    }

    @Override
    public Integer getMaxAge() {
        return this.maxAge;
    }

    @Override
    public CookieImpl setMaxAge(Integer maxAge) {
        this.maxAge = maxAge;
        return this;
    }

    @Override
    public boolean isDiscard() {
        return this.discard;
    }

    @Override
    public CookieImpl setDiscard(boolean discard) {
        this.discard = discard;
        return this;
    }

    @Override
    public boolean isSecure() {
        return this.secure;
    }

    @Override
    public CookieImpl setSecure(boolean secure) {
        this.secure = secure;
        return this;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public CookieImpl setVersion(int version) {
        this.version = version;
        return this;
    }

    @Override
    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    @Override
    public CookieImpl setHttpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
        return this;
    }

    @Override
    public Date getExpires() {
        return this.expires;
    }

    @Override
    public CookieImpl setExpires(Date expires) {
        this.expires = expires;
        return this;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public Cookie setComment(String comment) {
        this.comment = comment;
        return this;
    }

    @Override
    public boolean isSameSite() {
        return this.sameSite;
    }

    @Override
    public Cookie setSameSite(boolean sameSite) {
        this.sameSite = sameSite;
        return this;
    }

    @Override
    public String getSameSiteMode() {
        return this.sameSiteMode;
    }

    @Override
    public Cookie setSameSiteMode(String mode) {
        String m = CookieSameSiteMode.lookupModeString(mode);
        if (m != null) {
            UndertowLogger.REQUEST_LOGGER.tracef("Setting SameSite mode to [%s] for cookie [%s]", m, this.name);
            this.sameSiteMode = m;
            this.setSameSite(true);
        } else {
            UndertowLogger.REQUEST_LOGGER.warnf(UndertowMessages.MESSAGES.invalidSameSiteMode(mode, Arrays.toString((Object[])CookieSameSiteMode.values())), "Ignoring specified SameSite mode [%s] for cookie [%s]", mode, this.name);
        }
        return this;
    }

    @Override
    public String getAttribute(String name) {
        return this.attributes.get(name);
    }

    @Override
    public Cookie setAttribute(String name, String value) {
        if (value != null) {
            this.attributes.put(name, value);
        } else {
            this.attributes.remove(name);
        }
        return this;
    }

    @Override
    public Map<String, String> getAttributes() {
        return Map.copyOf(this.attributes);
    }

    public final int hashCode() {
        int result = 17;
        result = 37 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        result = 37 * result + (this.getPath() == null ? 0 : this.getPath().hashCode());
        result = 37 * result + (this.getDomain() == null ? 0 : this.getDomain().hashCode());
        return result;
    }

    public final boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Cookie)) {
            return false;
        }
        Cookie o = (Cookie)other;
        if (this.getName() == null && o.getName() != null) {
            return false;
        }
        if (this.getName() != null && !this.getName().equals(o.getName())) {
            return false;
        }
        if (this.getPath() == null && o.getPath() != null) {
            return false;
        }
        if (this.getPath() != null && !this.getPath().equals(o.getPath())) {
            return false;
        }
        if (this.getDomain() == null && o.getDomain() != null) {
            return false;
        }
        return this.getDomain() == null || this.getDomain().equals(o.getDomain());
    }

    @Override
    public final int compareTo(Object other) {
        return Cookie.super.compareTo(other);
    }

    public final String toString() {
        return "{CookieImpl@" + System.identityHashCode(this) + " name=" + this.getName() + " path=" + this.getPath() + " domain=" + this.getDomain() + "}";
    }
}

