/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.PreambleUtil;
import org.apache.datasketches.theta.SetOperation;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.Union;
import org.apache.datasketches.theta.UpdateSketch;
import org.apache.datasketches.thetacommon.ThetaUtil;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PreambleUtilTest {
    @Test
    public void checkToString() {
        int k = 4096;
        int u = 8192;
        int bytes = 65536 + (Family.QUICKSELECT.getMinPreLongs() << 3);
        byte[] byteArray = new byte[bytes];
        WritableMemory mem = WritableMemory.writableWrap((byte[])byteArray);
        UpdateSketch quick1 = UpdateSketch.builder().setNominalEntries(4096).build(mem);
        PreambleUtilTest.println(Sketch.toString((byte[])byteArray));
        Assert.assertTrue((boolean)quick1.isEmpty());
        for (int i = 0; i < 8192; ++i) {
            quick1.update((long)i);
        }
        PreambleUtilTest.println("U: " + quick1.getEstimate());
        Assert.assertEquals((double)quick1.getEstimate(), (double)8192.0, (double)409.6);
        Assert.assertTrue((quick1.getRetainedEntries(false) > 4096 ? 1 : 0) != 0);
        PreambleUtilTest.println(quick1.toString());
        PreambleUtilTest.println(PreambleUtil.preambleToString((Memory)mem));
        WritableMemory uMem = WritableMemory.writableWrap((byte[])new byte[SetOperation.getMaxUnionBytes((int)4096)]);
        Union union = SetOperation.builder().setNominalEntries(4096).buildUnion(uMem);
        union.union((Sketch)quick1);
        PreambleUtilTest.println(PreambleUtil.preambleToString((Memory)uMem));
    }

    @Test
    public void checkToStringWithPrelongsOf2() {
        int k = 16;
        int u = 16;
        UpdateSketch quick1 = UpdateSketch.builder().setNominalEntries(16).build();
        for (int i = 0; i < 16; ++i) {
            quick1.update((long)i);
        }
        byte[] bytes = quick1.compact().toByteArray();
        PreambleUtilTest.println(Sketch.toString((byte[])bytes));
    }

    @Test
    public void checkPreambleToStringExceptions() {
        byte[] byteArr = new byte[7];
        try {
            Sketch.toString((byte[])byteArr);
            Assert.fail((String)"Did not throw SketchesArgumentException.");
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        byteArr = new byte[8];
        byteArr[0] = 2;
        try {
            Sketch.toString((Memory)Memory.wrap((byte[])byteArr));
            Assert.fail((String)"Did not throw SketchesArgumentException.");
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBadSeedHashFromSeed() {
        ThetaUtil.computeSeedHash((long)50541L);
    }

    @Test
    public void checkPreLongs() {
        UpdateSketch sketch = UpdateSketch.builder().setNominalEntries(16).build();
        CompactSketch comp = sketch.compact(false, null);
        byte[] byteArr = comp.toByteArray();
        PreambleUtilTest.println(Sketch.toString((byte[])byteArr));
        sketch.update(1L);
        comp = sketch.compact(false, null);
        byteArr = comp.toByteArray();
        PreambleUtilTest.println(Sketch.toString((byte[])byteArr));
        for (int i = 2; i <= 32; ++i) {
            sketch.update((long)i);
        }
        comp = sketch.compact(false, null);
        byteArr = comp.toByteArray();
        PreambleUtilTest.println(Sketch.toString((Memory)Memory.wrap((byte[])byteArr)));
    }

    @Test
    public void checkInsertsAndExtracts() {
        byte[] arr = new byte[32];
        WritableMemory wmem = WritableMemory.writableWrap((byte[])arr);
        int v = 0;
        PreambleUtil.insertPreLongs((WritableMemory)wmem, (int)(++v));
        Assert.assertEquals((int)PreambleUtil.extractPreLongs((Memory)wmem), (int)v);
        PreambleUtil.insertPreLongs((WritableMemory)wmem, (int)0);
        PreambleUtil.insertLgResizeFactor((WritableMemory)wmem, (int)3);
        Assert.assertEquals((int)PreambleUtil.extractLgResizeFactor((Memory)wmem), (int)3);
        PreambleUtil.insertLgResizeFactor((WritableMemory)wmem, (int)0);
        PreambleUtil.insertSerVer((WritableMemory)wmem, (int)(++v));
        Assert.assertEquals((int)PreambleUtil.extractSerVer((Memory)wmem), (int)v);
        PreambleUtil.insertSerVer((WritableMemory)wmem, (int)0);
        PreambleUtil.insertFamilyID((WritableMemory)wmem, (int)(++v));
        Assert.assertEquals((int)PreambleUtil.extractFamilyID((Memory)wmem), (int)v);
        PreambleUtil.insertFamilyID((WritableMemory)wmem, (int)0);
        PreambleUtil.insertLgNomLongs((WritableMemory)wmem, (int)(++v));
        Assert.assertEquals((int)PreambleUtil.extractLgNomLongs((Memory)wmem), (int)v);
        PreambleUtil.insertLgNomLongs((WritableMemory)wmem, (int)0);
        PreambleUtil.insertLgArrLongs((WritableMemory)wmem, (int)(++v));
        Assert.assertEquals((int)PreambleUtil.extractLgArrLongs((Memory)wmem), (int)v);
        PreambleUtil.insertLgArrLongs((WritableMemory)wmem, (int)0);
        PreambleUtil.insertFlags((WritableMemory)wmem, (int)3);
        Assert.assertEquals((int)PreambleUtil.extractFlags((Memory)wmem), (int)3);
        Assert.assertEquals((int)PreambleUtil.extractLgResizeRatioV1((Memory)wmem), (int)3);
        PreambleUtil.insertFlags((WritableMemory)wmem, (int)0);
        PreambleUtil.insertSeedHash((WritableMemory)wmem, (int)(++v));
        Assert.assertEquals((int)PreambleUtil.extractSeedHash((Memory)wmem), (int)v);
        Assert.assertEquals((int)PreambleUtil.extractFlagsV1((Memory)wmem), (int)v);
        PreambleUtil.insertSeedHash((WritableMemory)wmem, (int)0);
        PreambleUtil.insertCurCount((WritableMemory)wmem, (int)(++v));
        Assert.assertEquals((int)PreambleUtil.extractCurCount((Memory)wmem), (int)v);
        PreambleUtil.insertCurCount((WritableMemory)wmem, (int)0);
        PreambleUtil.insertP((WritableMemory)wmem, (float)1.0f);
        Assert.assertEquals((float)PreambleUtil.extractP((Memory)wmem), (float)1.0f);
        PreambleUtil.insertP((WritableMemory)wmem, (float)0.0f);
        PreambleUtil.insertThetaLong((WritableMemory)wmem, (long)(++v));
        Assert.assertEquals((long)PreambleUtil.extractThetaLong((Memory)wmem), (long)v);
        PreambleUtil.insertThetaLong((WritableMemory)wmem, (long)0L);
        PreambleUtil.insertUnionThetaLong((WritableMemory)wmem, (long)(++v));
        Assert.assertEquals((long)PreambleUtil.extractUnionThetaLong((Memory)wmem), (long)v);
        PreambleUtil.insertUnionThetaLong((WritableMemory)wmem, (long)0L);
        PreambleUtil.setEmpty((WritableMemory)wmem);
        Assert.assertTrue((boolean)PreambleUtil.isEmptyFlag((Memory)wmem));
        PreambleUtil.clearEmpty((WritableMemory)wmem);
        Assert.assertFalse((boolean)PreambleUtil.isEmptyFlag((Memory)wmem));
    }

    @Test
    public void printlnTest() {
        PreambleUtilTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

