/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetReader;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class Derby2017LayerATest
extends BaseJDBCTestCase {
    public static final String UTF8 = "UTF-8";

    public Derby2017LayerATest(String name) {
        super(name);
    }

    public static Test suite() {
        BaseTestSuite ts = new BaseTestSuite();
        ts.addTest(TestConfiguration.defaultSuite(Derby2017LayerATest.class));
        BaseTestSuite clientSuite = new BaseTestSuite("Client only tests");
        clientSuite.addTest((Test)new Derby2017LayerATest("cs_FailedStreamInsertCharBufferBoundaries"));
        clientSuite.addTest((Test)new Derby2017LayerATest("cs_StreamInsertCharBufferBoundary"));
        ts.addTest(TestConfiguration.clientServerDecorator((Test)clientSuite));
        return ts;
    }

    public void cs_StreamInsertCharBufferBoundary() throws IOException, SQLException {
        int i;
        this.rollback();
        Statement stmt = this.createStatement();
        try {
            stmt.executeUpdate("create table t2017_len (len int, c clob)");
        }
        catch (SQLException sqle) {
            Derby2017LayerATest.assertSQLState("X0Y32", sqle);
            stmt.executeUpdate("delete from t2017_len");
        }
        this.commit();
        this.setAutoCommit(false);
        PreparedStatement ps = this.prepareStatement("insert into t2017_len values (?,?)");
        for (i = 0; i < 512; ++i) {
            ps.setInt(1, i);
            ps.setCharacterStream(2, (Reader)new LoopingAlphabetReader(i), i);
            ps.executeUpdate();
        }
        this.commit();
        for (i = 16000; i < 18000; ++i) {
            ps.setInt(1, i);
            ps.setCharacterStream(2, (Reader)new LoopingAlphabetReader(i), i);
            ps.executeUpdate();
            if (i % 1000 != 0) continue;
            this.commit();
        }
        this.commit();
        for (i = 32500; i < 33000; ++i) {
            ps.setInt(1, i);
            ps.setCharacterStream(2, (Reader)new LoopingAlphabetReader(i), i);
            ps.executeUpdate();
        }
        this.commit();
        ResultSet rs = stmt.executeQuery("select len, c from t2017_len");
        int rows = 0;
        while (rs.next()) {
            ++rows;
            Derby2017LayerATest.assertEquals(new LoopingAlphabetReader(rs.getInt(1)), rs.getCharacterStream(2));
        }
    }

    public void cs_FailedStreamInsertCharBufferBoundaries() throws IOException, SQLException {
        for (int i = 0; i < 1024; ++i) {
            int[] INSERT = new int[]{8000 + i, 16000 + i, 32000 + i, 16000 + i, 32000 + i, 48000 + i, 0 + i};
            this.doInsertTest(INSERT, false, false);
        }
    }

    public void testFailedStreamInsertCharLong() throws IOException, SQLException {
        int[] INSERT = new int[]{10241, 91139, 32768, 65536, 101376, 1, 201728};
        this.doInsertTest(INSERT, false, false);
        this.doInsertTest(INSERT, false, true);
        this.doInsertTest(INSERT, true, false);
        this.doInsertTest(INSERT, true, true);
    }

    public void testFailedStreamInsertCharIOException() throws IOException, SQLException {
        String[] INSERT = new String[]{"row 1", "row 2", "row 3", "IGNORE", "IGNORE", "row 6", "row 7"};
        String[][] MASTER = new String[][]{{"row 1"}, {"row 2"}, {"row 3"}, {"row 6"}, {"row 7"}};
        this.rollback();
        Statement stmt = this.createStatement();
        try {
            stmt.executeUpdate("create table t2017 (c clob)");
        }
        catch (SQLException sqle) {
            Derby2017LayerATest.assertSQLState("X0Y32", sqle);
            stmt.executeUpdate("delete from t2017");
        }
        this.commit();
        this.setAutoCommit(true);
        PreparedStatement ps = this.prepareStatement("insert into t2017 values (?)");
        for (int i = 0; i < 3; ++i) {
            ps.setString(1, INSERT[i]);
            Derby2017LayerATest.assertEquals((int)1, (int)ps.executeUpdate());
        }
        FailingReader r4 = new FailingReader(518L, 500L);
        ps.setCharacterStream(1, (Reader)r4, 518);
        try {
            ps.executeUpdate();
            Derby2017LayerATest.fail((String)"Insert should have failed");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        FailingReader r5 = new FailingReader(68608L, 43008L);
        ps.setCharacterStream(1, (Reader)r5, 68608);
        try {
            ps.executeUpdate();
            Derby2017LayerATest.fail((String)"Insert should have failed");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        for (int i = 5; i < INSERT.length; ++i) {
            ps.setString(1, INSERT[i]);
            Derby2017LayerATest.assertEquals((int)1, (int)ps.executeUpdate());
        }
        ResultSet rs = stmt.executeQuery("select * from t2017");
        JDBC.assertFullResultSet(rs, MASTER);
    }

    public void testFailedStreamInsertChar() throws IOException, SQLException {
        String[] INSERT = new String[]{"This is row 1", "This is row 2", "This is row 3", "This is row 4, a bit too long", "This is row 5, a bit too short", "This is row 6", "This is row 7"};
        String[][] MASTER = new String[][]{{"This is row 1"}, {"This is row 2"}, {"This is row 3"}, {"This is row 6"}, {"This is row 7"}};
        this.doInsertTest(INSERT, MASTER, false, false);
    }

    public void testFailedStreamInsertCharAutoCommit() throws IOException, SQLException {
        String[] INSERT = new String[]{"This is row 1", "This is row 2", "This is row 3", "This is row 4, a bit too long", "This is row 5, a bit too short", "This is row 6", "This is row 7"};
        String[][] MASTER = new String[][]{{"This is row 1"}, {"This is row 2"}, {"This is row 3"}, {"This is row 6"}, {"This is row 7"}};
        this.doInsertTest(INSERT, MASTER, true, false);
    }

    public void testFailedStreamInsertCharRollbackOnError() throws IOException, SQLException {
        String[] INSERT = new String[]{"This is row 1", "This is row 2", "This is row 3", "This is row 4, a bit too long", "This is row 5, a bit too short", "This is row 6", "This is row 7"};
        String[][] MASTER = new String[][]{{"This is row 6"}, {"This is row 7"}};
        this.doInsertTest(INSERT, MASTER, false, true);
    }

    public void testFailedStreamInsertCharAutoCommitRollbackOnError() throws IOException, SQLException {
        String[] INSERT = new String[]{"This is row 1", "This is row 2", "This is row 3", "This is row 4, a bit too long", "This is row 5, a bit too short", "This is row 6", "This is row 7"};
        String[][] MASTER = new String[][]{{"This is row 1"}, {"This is row 2"}, {"This is row 3"}, {"This is row 6"}, {"This is row 7"}};
        this.doInsertTest(INSERT, MASTER, true, true);
    }

    public void testFailedStreamInsertBinary() throws IOException, SQLException {
        byte[][] INSERT = Derby2017LayerATest.generateDefaultInsert();
        String[][] MASTER = Derby2017LayerATest.generateMaster(INSERT, new int[]{3, 4});
        this.doInsertTest(INSERT, MASTER, false, false);
    }

    public void testFailedStreamInsertBinaryAutoCommit() throws IOException, SQLException {
        byte[][] INSERT = Derby2017LayerATest.generateDefaultInsert();
        String[][] MASTER = Derby2017LayerATest.generateMaster(INSERT, new int[]{3, 4});
        this.doInsertTest(INSERT, MASTER, true, false);
    }

    public void testFailedStreamInsertBinaryRollbackOnError() throws IOException, SQLException {
        byte[][] INSERT = Derby2017LayerATest.generateDefaultInsert();
        String[][] MASTER = Derby2017LayerATest.generateMaster(INSERT, new int[]{0, 1, 2, 3, 4});
        this.doInsertTest(INSERT, MASTER, false, true);
    }

    public void testFailedStreamInsertBinaryAutoCommitRollbackOnError() throws IOException, SQLException {
        byte[][] INSERT = Derby2017LayerATest.generateDefaultInsert();
        String[][] MASTER = Derby2017LayerATest.generateMaster(INSERT, new int[]{3, 4});
        this.doInsertTest(INSERT, MASTER, true, true);
    }

    private void doInsertTest(String[] INSERT, String[][] MASTER, boolean autoCommit, boolean rollbackOnError) throws IOException, SQLException {
        PreparedStatement ps;
        Statement stmt;
        block10: {
            block9: {
                Derby2017LayerATest.assertEquals((String)"Expects 7 rows", (int)7, (int)INSERT.length);
                Derby2017LayerATest.assertTrue((MASTER.length < INSERT.length ? 1 : 0) != 0);
                this.rollback();
                stmt = this.createStatement();
                try {
                    stmt.executeUpdate("create table t2017 (c clob)");
                }
                catch (SQLException sqle) {
                    Derby2017LayerATest.assertSQLState("X0Y32", sqle);
                    stmt.executeUpdate("delete from t2017");
                }
                this.commit();
                this.setAutoCommit(autoCommit);
                ps = this.prepareStatement("insert into t2017 values (?)");
                for (int i = 0; i < 3; ++i) {
                    ps.setString(1, INSERT[i]);
                    Derby2017LayerATest.assertEquals((int)1, (int)ps.executeUpdate());
                }
                StringReader r4 = new StringReader(INSERT[3]);
                ps.setCharacterStream(1, (Reader)r4, INSERT[3].length() - 5);
                try {
                    ps.executeUpdate();
                    Derby2017LayerATest.fail((String)"Insert should have failed, stream too long");
                }
                catch (SQLException sqle) {
                    Derby2017LayerATest.assertSQLState(Derby2017LayerATest.usingEmbedded() ? "XSDA4" : "XN015", sqle);
                    if (!rollbackOnError) break block9;
                    this.rollback();
                }
            }
            StringReader r5 = new StringReader(INSERT[4]);
            ps.setCharacterStream(1, (Reader)r5, INSERT[4].length() + 5);
            try {
                ps.executeUpdate();
                Derby2017LayerATest.fail((String)"Insert should have failed, stream too short");
            }
            catch (SQLException sqle) {
                Derby2017LayerATest.assertSQLState(Derby2017LayerATest.usingEmbedded() ? "XSDA4" : "XN017", sqle);
                if (!rollbackOnError) break block10;
                this.rollback();
            }
        }
        for (int i = 5; i < INSERT.length; ++i) {
            ps.setString(1, INSERT[i]);
            Derby2017LayerATest.assertEquals((int)1, (int)ps.executeUpdate());
        }
        if (!autoCommit) {
            this.commit();
        }
        ResultSet rs = stmt.executeQuery("select * from t2017");
        JDBC.assertFullResultSet(rs, MASTER);
    }

    private void doInsertTest(int[] INSERT, boolean autoCommit, boolean rollbackOnError) throws IOException, SQLException {
        int id;
        int i;
        PreparedStatement ps;
        Statement stmt;
        block13: {
            block12: {
                Derby2017LayerATest.assertEquals((String)"Expects 7 rows", (int)7, (int)INSERT.length);
                this.rollback();
                stmt = this.createStatement();
                try {
                    stmt.executeUpdate("create table t2017_id (id int unique, c clob)");
                }
                catch (SQLException sqle) {
                    Derby2017LayerATest.assertSQLState("X0Y32", sqle);
                    stmt.executeUpdate("delete from t2017_id");
                }
                this.commit();
                this.setAutoCommit(autoCommit);
                ps = this.prepareStatement("insert into t2017_id values (?, ?)");
                for (int i2 = 0; i2 < 3; ++i2) {
                    ps.setInt(1, i2 + 1);
                    int length = INSERT[i2];
                    ps.setCharacterStream(2, (Reader)new LoopingAlphabetReader(length), length);
                    Derby2017LayerATest.assertEquals((int)1, (int)ps.executeUpdate());
                }
                LoopingAlphabetReader r4 = new LoopingAlphabetReader(INSERT[3]);
                ps.setInt(1, 4);
                ps.setCharacterStream(2, (Reader)r4, INSERT[3] - 5);
                try {
                    ps.executeUpdate();
                    Derby2017LayerATest.fail((String)"Insert should have failed, stream too long");
                }
                catch (SQLException sqle) {
                    Derby2017LayerATest.assertSQLState(Derby2017LayerATest.usingEmbedded() ? "XSDA4" : "XN015", sqle);
                    if (!rollbackOnError) break block12;
                    this.rollback();
                }
            }
            LoopingAlphabetReader r5 = new LoopingAlphabetReader(INSERT[4]);
            ps.setInt(1, 5);
            ps.setCharacterStream(2, (Reader)r5, INSERT[4] + 5);
            try {
                ps.executeUpdate();
                Derby2017LayerATest.fail((String)"Insert should have failed, stream too short");
            }
            catch (SQLException sqle) {
                Derby2017LayerATest.assertSQLState(Derby2017LayerATest.usingEmbedded() ? "XSDA4" : "XN017", sqle);
                if (!rollbackOnError) break block13;
                this.rollback();
            }
        }
        for (int i3 = 5; i3 < INSERT.length; ++i3) {
            ps.setInt(1, i3 + 1);
            int length = INSERT[i3];
            ps.setCharacterStream(2, (Reader)new LoopingAlphabetReader(length), length);
            Derby2017LayerATest.assertEquals((int)1, (int)ps.executeUpdate());
        }
        if (!autoCommit) {
            this.commit();
        }
        ResultSet rs = stmt.executeQuery("select count(*) from t2017_id");
        rs.next();
        Derby2017LayerATest.assertEquals((int)(rollbackOnError && !autoCommit ? 2 : 5), (int)rs.getInt(1));
        rs = stmt.executeQuery("select * from t2017_id order by id asc");
        if (autoCommit || !rollbackOnError) {
            for (i = 0; i < 3; ++i) {
                rs.next();
                id = rs.getInt(1);
                Derby2017LayerATest.assertTrue((id - 1 == i ? 1 : 0) != 0);
                Derby2017LayerATest.assertEquals(new LoopingAlphabetReader(INSERT[i]), rs.getCharacterStream(2));
            }
        }
        for (i = 5; i < 7; ++i) {
            rs.next();
            id = rs.getInt(1);
            Derby2017LayerATest.assertTrue((id - 1 == i ? 1 : 0) != 0);
            Derby2017LayerATest.assertEquals(new LoopingAlphabetReader(INSERT[i]), rs.getCharacterStream(2));
        }
        Derby2017LayerATest.assertFalse((boolean)rs.next());
        rs.close();
    }

    private void doInsertTest(byte[][] INSERT, String[][] MASTER, boolean autoCommit, boolean rollbackOnError) throws IOException, SQLException {
        PreparedStatement ps;
        Statement stmt;
        block10: {
            block9: {
                Derby2017LayerATest.assertEquals((String)"Expects 7 rows", (int)7, (int)INSERT.length);
                Derby2017LayerATest.assertTrue((MASTER.length < INSERT.length ? 1 : 0) != 0);
                this.rollback();
                stmt = this.createStatement();
                try {
                    stmt.executeUpdate("create table t2017_binary (b blob)");
                }
                catch (SQLException sqle) {
                    Derby2017LayerATest.assertSQLState("X0Y32", sqle);
                    stmt.executeUpdate("delete from t2017_binary");
                }
                this.commit();
                this.setAutoCommit(autoCommit);
                ps = this.prepareStatement("insert into t2017_binary values (?)");
                for (int i = 0; i < 3; ++i) {
                    ps.setBytes(1, INSERT[i]);
                    Derby2017LayerATest.assertEquals((int)1, (int)ps.executeUpdate());
                }
                ByteArrayInputStream r4 = new ByteArrayInputStream(INSERT[3]);
                ps.setBinaryStream(1, (InputStream)r4, INSERT[3].length - 5);
                try {
                    ps.executeUpdate();
                    Derby2017LayerATest.fail((String)"Insert should have failed, stream too long");
                }
                catch (SQLException sqle) {
                    Derby2017LayerATest.assertSQLState(Derby2017LayerATest.usingEmbedded() ? "XSDA4" : "XN015", sqle);
                    if (!rollbackOnError) break block9;
                    this.rollback();
                }
            }
            ByteArrayInputStream r5 = new ByteArrayInputStream(INSERT[4]);
            ps.setBinaryStream(1, (InputStream)r5, INSERT[4].length + 5);
            try {
                ps.executeUpdate();
                Derby2017LayerATest.fail((String)"Insert should have failed, stream too short");
            }
            catch (SQLException sqle) {
                Derby2017LayerATest.assertSQLState(Derby2017LayerATest.usingEmbedded() ? "XSDA4" : "XN017", sqle);
                if (!rollbackOnError) break block10;
                this.rollback();
            }
        }
        for (int i = 5; i < INSERT.length; ++i) {
            ps.setBytes(1, INSERT[i]);
            Derby2017LayerATest.assertEquals((int)1, (int)ps.executeUpdate());
        }
        if (!autoCommit) {
            this.commit();
        }
        ResultSet rs = stmt.executeQuery("select * from t2017_binary");
        JDBC.assertFullResultSet(rs, MASTER);
    }

    public static byte[][] generateDefaultInsert() {
        try {
            byte[][] INSERT = new byte[][]{"This is row 1".getBytes(UTF8), "This is row 2".getBytes(UTF8), "This is row 3".getBytes(UTF8), "This is row 4, a bit too long".getBytes(UTF8), "This is row 5, a bit too short".getBytes(UTF8), "This is row 6".getBytes(UTF8), "This is row 7".getBytes(UTF8)};
            return INSERT;
        }
        catch (UnsupportedEncodingException uuee) {
            return null;
        }
    }

    public static String[][] generateMaster(byte[][] insert, int[] excludes) {
        Arrays.sort(excludes);
        int exIx = 0;
        String[][] res = new String[insert.length - excludes.length][];
        int resIx = 0;
        for (int i = 0; i < insert.length; ++i) {
            if (i == excludes[exIx]) {
                if (exIx >= excludes.length - 1) continue;
                ++exIx;
                continue;
            }
            String str = new BigInteger(1, insert[i]).toString(16);
            while (str.length() < insert[i].length * 2) {
                str = "0" + str;
            }
            res[resIx++] = new String[]{str};
        }
        return res;
    }

    public static class FailingReader
    extends Reader {
        private final LoopingAlphabetReader in;
        private final long failAtPos;
        private long pos;

        public FailingReader(long length, long failAtPos) {
            this.failAtPos = failAtPos;
            this.in = new LoopingAlphabetReader(length);
        }

        @Override
        public int read() throws IOException {
            ++this.pos;
            int ret = this.in.read();
            if (this.pos >= this.failAtPos) {
                throw new IOException("forced exception");
            }
            return ret;
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            int ret;
            if (this.pos == 0L && this.failAtPos > 1L) {
                len = (int)Math.min(this.failAtPos - 1L, (long)len);
            }
            if ((ret = this.in.read(cbuf, off, len)) != -1) {
                this.pos += (long)ret;
            }
            if (this.pos >= this.failAtPos) {
                throw new IOException("forced exception");
            }
            return ret;
        }

        @Override
        public void close() {
            this.in.close();
        }
    }
}

