/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.derby.iapi.error.ExceptionUtil;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.store.raw.data.DataFactory;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.EncryptedLOBFile;
import org.apache.derby.impl.jdbc.LOBFile;
import org.apache.derby.impl.jdbc.LOBInputStream;
import org.apache.derby.impl.jdbc.LOBOutputStream;
import org.apache.derby.io.StorageFile;

final class LOBStreamControl {
    private LOBFile tmpFile;
    private byte[] dataBytes = new byte[0];
    private boolean isBytes = true;
    private final int bufferSize;
    private final EmbedConnection conn;
    private long updateCount;
    private static final int DEFAULT_BUF_SIZE = 4096;
    private static final int MAX_BUF_SIZE = 32768;

    LOBStreamControl(EmbedConnection conn) {
        this.conn = conn;
        this.updateCount = 0L;
        this.bufferSize = 4096;
    }

    LOBStreamControl(EmbedConnection conn, byte[] data) throws IOException, StandardException {
        this.conn = conn;
        this.updateCount = 0L;
        this.bufferSize = Math.min(Math.max(4096, data.length), 32768);
        this.write(data, 0, data.length, 0L);
    }

    private void init(byte[] b, long len) throws IOException, StandardException {
        Object monitor = LOBStreamControl.findService("org.apache.derby.database.Database", this.conn.getDBName());
        final DataFactory df = (DataFactory)LOBStreamControl.findServiceModule(monitor, "org.apache.derby.iapi.store.raw.data.DataFactory");
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws IOException {
                    StorageFile lobFile = df.getStorageFactory().createTemporaryFile("lob", null);
                    if (df.databaseEncrypted()) {
                        LOBStreamControl.this.tmpFile = new EncryptedLOBFile(lobFile, df);
                    } else {
                        LOBStreamControl.this.tmpFile = new LOBFile(lobFile);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getCause();
        }
        this.conn.addLobFile(this.tmpFile);
        this.isBytes = false;
        if (len != 0L) {
            this.write(b, 0, (int)len, 0L);
        }
        this.dataBytes = null;
    }

    private long updateData(byte[] bytes, int offset, int len, long pos) throws StandardException {
        if (this.dataBytes == null) {
            if ((int)pos == 0) {
                this.dataBytes = new byte[len];
                System.arraycopy(bytes, offset, this.dataBytes, (int)pos, len);
                return len;
            }
            throw StandardException.newException("XJ076.S", pos);
        }
        if (pos > (long)this.dataBytes.length) {
            throw StandardException.newException("XJ076.S", pos);
        }
        if (pos + (long)len < (long)this.dataBytes.length) {
            System.arraycopy(bytes, offset, this.dataBytes, (int)pos, len);
        } else {
            byte[] tmpBytes = new byte[len + (int)pos];
            System.arraycopy(this.dataBytes, 0, tmpBytes, 0, (int)pos);
            System.arraycopy(bytes, offset, tmpBytes, (int)pos, len);
            this.dataBytes = tmpBytes;
        }
        return pos + (long)len;
    }

    private void isValidPostion(long pos) throws IOException, StandardException {
        if (pos < 0L) {
            throw StandardException.newException("XJ071.S", pos + 1L);
        }
        if (pos > Integer.MAX_VALUE) {
            throw StandardException.newException("XJ076.S", pos + 1L);
        }
        if (this.isBytes ? (this.dataBytes == null ? pos != 0L : (long)this.dataBytes.length < pos) : pos > this.tmpFile.length()) {
            throw StandardException.newException("XJ076.S", pos + 1L);
        }
    }

    private void isValidOffset(int off, int length) throws StandardException {
        if (off < 0 || off > length) {
            throw StandardException.newException("XJ078.S", off);
        }
    }

    synchronized long write(int b, long pos) throws IOException, StandardException {
        this.isValidPostion(pos);
        ++this.updateCount;
        if (this.isBytes) {
            if (pos < (long)this.bufferSize) {
                byte[] bytes = new byte[]{(byte)b};
                this.updateData(bytes, 0, 1, pos);
                return pos + 1L;
            }
            this.init(this.dataBytes, pos);
        }
        this.tmpFile.seek(pos);
        this.tmpFile.write(b);
        return this.tmpFile.getFilePointer();
    }

    synchronized long write(byte[] b, int off, int len, long pos) throws IOException, StandardException {
        this.isValidPostion(pos);
        try {
            this.isValidOffset(off, b.length);
        }
        catch (StandardException e) {
            if (e.getSQLState().equals(ExceptionUtil.getSQLStateFromIdentifier("XJ078.S"))) {
                throw new ArrayIndexOutOfBoundsException(e.getMessage());
            }
            throw e;
        }
        ++this.updateCount;
        if (this.isBytes) {
            if (pos + (long)len <= (long)this.bufferSize) {
                return this.updateData(b, off, len, pos);
            }
            this.init(this.dataBytes, pos);
        }
        this.tmpFile.seek(pos);
        this.tmpFile.write(b, off, len);
        return this.tmpFile.getFilePointer();
    }

    synchronized int read(long pos) throws IOException, StandardException {
        this.isValidPostion(pos);
        if (this.isBytes) {
            if ((long)this.dataBytes.length == pos) {
                return -1;
            }
            return this.dataBytes[(int)pos] & 0xFF;
        }
        if (this.tmpFile.getFilePointer() != pos) {
            this.tmpFile.seek(pos);
        }
        try {
            return this.tmpFile.readByte() & 0xFF;
        }
        catch (EOFException eof) {
            return -1;
        }
    }

    private int readBytes(byte[] b, int off, int len, long pos) {
        if (pos >= (long)this.dataBytes.length) {
            return -1;
        }
        int lengthFromPos = this.dataBytes.length - (int)pos;
        int actualLength = len > lengthFromPos ? lengthFromPos : len;
        System.arraycopy(this.dataBytes, (int)pos, b, off, actualLength);
        return actualLength;
    }

    synchronized int read(byte[] buff, int off, int len, long pos) throws IOException, StandardException {
        this.isValidPostion(pos);
        this.isValidOffset(off, buff.length);
        if (this.isBytes) {
            return this.readBytes(buff, off, len, pos);
        }
        this.tmpFile.seek(pos);
        return this.tmpFile.read(buff, off, len);
    }

    InputStream getInputStream(long pos) {
        return new LOBInputStream(this, pos);
    }

    OutputStream getOutputStream(long pos) {
        return new LOBOutputStream(this, pos);
    }

    long getLength() throws IOException {
        if (this.isBytes) {
            return this.dataBytes.length;
        }
        return this.tmpFile.length();
    }

    synchronized void truncate(long size) throws IOException, StandardException {
        this.isValidPostion(size);
        if (this.isBytes) {
            byte[] tmpByte = new byte[(int)size];
            System.arraycopy(this.dataBytes, 0, tmpByte, 0, (int)size);
            this.dataBytes = tmpByte;
        } else if (size < (long)this.bufferSize) {
            this.dataBytes = new byte[(int)size];
            this.read(this.dataBytes, 0, this.dataBytes.length, 0L);
            this.isBytes = true;
            this.releaseTempFile(this.tmpFile);
            this.tmpFile = null;
        } else {
            this.tmpFile.setLength(size);
        }
    }

    synchronized void copyData(InputStream inStream, long length) throws IOException, StandardException {
        int len;
        byte[] data = new byte[this.bufferSize];
        for (long sz = 0L; sz < length; sz += (long)len) {
            len = (int)Math.min(length - sz, (long)this.bufferSize);
            if ((len = inStream.read(data, 0, len)) == -1) {
                if (length == Long.MAX_VALUE) break;
                throw new EOFException(MessageService.getTextMessage("I029", length, sz));
            }
            this.write(data, 0, len, sz);
        }
        long curLength = this.getLength();
        if (length == Long.MAX_VALUE && curLength > 2L) {
            byte[] eos = new byte[3];
            this.read(eos, 0, 3, curLength - 3L);
            if ((eos[0] & 0xFF) == 224 && (eos[1] & 0xFF) == 0 && (eos[2] & 0xFF) == 0) {
                this.truncate(curLength - 3L);
            }
        }
    }

    synchronized long copyUtf8Data(InputStream utf8Stream, long charLength) throws IOException, StandardException {
        int readNow;
        long charCount = 0L;
        int offset = 0;
        int read = 0;
        byte[] buf = new byte[this.bufferSize];
        while (charCount < charLength && (readNow = utf8Stream.read(buf, 0, (int)Math.min((long)buf.length, charLength - charCount))) != -1) {
            while (offset < readNow) {
                int c = buf[offset] & 0xFF;
                if ((c & 0x80) == 0) {
                    ++offset;
                } else if ((c & 0x60) == 64) {
                    offset += 2;
                } else if ((c & 0x70) == 96) {
                    offset += 3;
                } else {
                    throw new UTFDataFormatException("Invalid UTF-8 encoding: " + Integer.toHexString(c) + ", charCount=" + charCount + ", offset=" + offset);
                }
                ++charCount;
            }
            offset -= readNow;
            this.write(buf, 0, readNow, read);
            read += readNow;
        }
        long curLength = this.getLength();
        if (curLength > 2L) {
            byte[] eos = new byte[3];
            this.read(eos, 0, 3, curLength - 3L);
            if ((eos[0] & 0xFF) == 224 && (eos[1] & 0xFF) == 0 && (eos[2] & 0xFF) == 0) {
                this.truncate(curLength - 3L);
                --charCount;
            }
        }
        if (charLength != Long.MAX_VALUE && charCount != charLength) {
            throw new EOFException(MessageService.getTextMessage("I029", charLength, charCount));
        }
        return charCount;
    }

    protected void finalize() throws Throwable {
        this.free();
    }

    private void deleteFile(final StorageFile file) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                file.delete();
                return null;
            }
        });
    }

    void free() throws IOException {
        this.dataBytes = null;
        if (this.tmpFile != null) {
            this.releaseTempFile(this.tmpFile);
            this.tmpFile = null;
        }
    }

    private void releaseTempFile(LOBFile file) throws IOException {
        this.conn.removeLobFile(file);
        file.close();
        this.deleteFile(file.getStorageFile());
    }

    synchronized long replaceBytes(byte[] buf, long stPos, long endPos) throws IOException, StandardException {
        long length = this.getLength();
        if (this.isBytes) {
            long finalLength = length - endPos + stPos + (long)buf.length;
            if (finalLength > (long)this.bufferSize) {
                byte[] tmpBytes = this.dataBytes;
                this.init(tmpBytes, stPos);
                this.write(buf, 0, buf.length, this.getLength());
                if (endPos < length) {
                    this.write(tmpBytes, (int)endPos, (int)(length - endPos), this.getLength());
                }
            } else {
                byte[] tmpByte = new byte[(int)finalLength];
                System.arraycopy(this.dataBytes, 0, tmpByte, 0, (int)stPos);
                System.arraycopy(buf, 0, tmpByte, (int)stPos, buf.length);
                if (endPos < length) {
                    System.arraycopy(this.dataBytes, (int)endPos, tmpByte, (int)(stPos + (long)buf.length), (int)(length - endPos));
                }
                this.dataBytes = tmpByte;
            }
        } else {
            int readLen;
            int actualLength;
            byte[] tmp = new byte[]{};
            LOBFile oldFile = this.tmpFile;
            this.init(tmp, 0L);
            byte[] tmpByte = new byte[1024];
            oldFile.seek(0L);
            for (long sz = stPos; sz != 0L && (actualLength = oldFile.read(tmpByte, 0, readLen = (int)Math.min(1024L, sz))) != -1; sz -= (long)actualLength) {
                this.tmpFile.write(tmpByte, 0, actualLength);
            }
            this.tmpFile.write(buf);
            oldFile.seek(endPos);
            if (endPos < length) {
                int rdLen;
                while ((rdLen = oldFile.read(tmpByte, 0, 1024)) != -1) {
                    this.tmpFile.write(tmpByte, 0, rdLen);
                }
            }
            this.releaseTempFile(oldFile);
        }
        ++this.updateCount;
        return stPos + (long)buf.length;
    }

    long getUpdateCount() {
        return this.updateCount;
    }

    private static Object findServiceModule(final Object serviceModule, final String factoryInterface) throws StandardException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws StandardException {
                    return Monitor.findServiceModule(serviceModule, factoryInterface);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw StandardException.plainWrapException(pae);
        }
    }

    private static Object findService(final String factoryInterface, final String serviceName) {
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return Monitor.findService(factoryInterface, serviceName);
            }
        });
    }
}

