/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.sanity.SanityManager;

class HasVariantValueNodeVisitor
implements Visitor {
    private boolean hasVariant;
    private int variantType;
    private boolean ignoreParameters;

    HasVariantValueNodeVisitor() {
        this.variantType = 0;
        this.ignoreParameters = false;
        SanityManager.ASSERT(true, "qualifier constants not ordered as expected");
        SanityManager.ASSERT(true, "qualifier constants not ordered as expected");
    }

    HasVariantValueNodeVisitor(int variantType, boolean ignoreParameters) {
        this.variantType = variantType;
        this.ignoreParameters = ignoreParameters;
        SanityManager.ASSERT(variantType >= 0, "bad variantType");
        SanityManager.ASSERT(variantType <= 2, "bad variantType");
    }

    @Override
    public Visitable visit(Visitable node) throws StandardException {
        if (node instanceof ValueNode) {
            if (this.ignoreParameters && ((ValueNode)node).requiresTypeFromContext()) {
                return node;
            }
            if (((ValueNode)node).getOrderableVariantType() <= this.variantType) {
                this.hasVariant = true;
            }
        }
        return node;
    }

    @Override
    public boolean skipChildren(Visitable node) {
        return false;
    }

    @Override
    public boolean visitChildrenFirst(Visitable node) {
        return false;
    }

    @Override
    public boolean stopTraversal() {
        return this.hasVariant;
    }

    boolean hasVariant() {
        return this.hasVariant;
    }
}

