/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;

public class SimpleApp {
    private String framework = "embedded";
    private String protocol = "jdbc:derby:";

    public static void main(String[] args) {
        new SimpleApp().go(args);
        System.out.println("SimpleApp finished");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void go(String[] args) {
        block35: {
            this.parseArguments(args);
            System.out.println("SimpleApp starting in " + this.framework + " mode");
            Connection conn = null;
            ArrayList<Statement> statements = new ArrayList<Statement>();
            ResultSet rs = null;
            try {
                int number;
                Properties props = new Properties();
                props.put("user", "user1");
                props.put("password", "user1");
                String dbName = "derbyDB";
                conn = DriverManager.getConnection(this.protocol + dbName + ";create=true", props);
                System.out.println("Connected to and created database " + dbName);
                conn.setAutoCommit(false);
                Statement s = conn.createStatement();
                statements.add(s);
                s.execute("create table location(num int, addr varchar(40))");
                System.out.println("Created table location");
                PreparedStatement psInsert = conn.prepareStatement("insert into location values (?, ?)");
                statements.add(psInsert);
                psInsert.setInt(1, 1956);
                psInsert.setString(2, "Webster St.");
                psInsert.executeUpdate();
                System.out.println("Inserted 1956 Webster");
                psInsert.setInt(1, 1910);
                psInsert.setString(2, "Union St.");
                psInsert.executeUpdate();
                System.out.println("Inserted 1910 Union");
                PreparedStatement psUpdate = conn.prepareStatement("update location set num=?, addr=? where num=?");
                statements.add(psUpdate);
                psUpdate.setInt(1, 180);
                psUpdate.setString(2, "Grand Ave.");
                psUpdate.setInt(3, 1956);
                psUpdate.executeUpdate();
                System.out.println("Updated 1956 Webster to 180 Grand");
                psUpdate.setInt(1, 300);
                psUpdate.setString(2, "Lakeshore Ave.");
                psUpdate.setInt(3, 180);
                psUpdate.executeUpdate();
                System.out.println("Updated 180 Grand to 300 Lakeshore");
                rs = s.executeQuery("SELECT num, addr FROM location ORDER BY num");
                boolean failure = false;
                if (!rs.next()) {
                    failure = true;
                    this.reportFailure("No rows in ResultSet");
                }
                if ((number = rs.getInt(1)) != 300) {
                    failure = true;
                    this.reportFailure("Wrong row returned, expected num=300, got " + number);
                }
                if (!rs.next()) {
                    failure = true;
                    this.reportFailure("Too few rows");
                }
                if ((number = rs.getInt(1)) != 1910) {
                    failure = true;
                    this.reportFailure("Wrong row returned, expected num=1910, got " + number);
                }
                if (rs.next()) {
                    failure = true;
                    this.reportFailure("Too many rows");
                }
                if (!failure) {
                    System.out.println("Verified the rows");
                }
                s.execute("drop table location");
                System.out.println("Dropped table location");
                conn.commit();
                System.out.println("Committed the transaction");
                if (!this.framework.equals("embedded")) break block35;
                try {
                    DriverManager.getConnection("jdbc:derby:;shutdown=true");
                }
                catch (SQLException se) {
                    if (se.getErrorCode() == 50000 && "XJ015".equals(se.getSQLState())) {
                        System.out.println("Derby shut down normally");
                        break block35;
                    }
                    System.err.println("Derby did not shut down normally");
                    SimpleApp.printSQLException(se);
                }
            }
            catch (SQLException sqle) {
                SimpleApp.printSQLException(sqle);
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                }
                catch (SQLException sqle) {
                    SimpleApp.printSQLException(sqle);
                }
                int i = 0;
                while (!statements.isEmpty()) {
                    Statement st = (Statement)statements.remove(i);
                    try {
                        if (st == null) continue;
                        st.close();
                        st = null;
                    }
                    catch (SQLException sqle) {
                        SimpleApp.printSQLException(sqle);
                    }
                }
                try {
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (SQLException sqle) {
                    SimpleApp.printSQLException(sqle);
                }
            }
        }
    }

    private void reportFailure(String message) {
        System.err.println("\nData verification failed:");
        System.err.println('\t' + message);
    }

    public static void printSQLException(SQLException e) {
        while (e != null) {
            System.err.println("\n----- SQLException -----");
            System.err.println("  SQL State:  " + e.getSQLState());
            System.err.println("  Error Code: " + e.getErrorCode());
            System.err.println("  Message:    " + e.getMessage());
            e = e.getNextException();
        }
    }

    private void parseArguments(String[] args) {
        if (args.length > 0 && args[0].equalsIgnoreCase("derbyclient")) {
            this.framework = "derbyclient";
            this.protocol = "jdbc:derby://localhost:1527/";
        }
    }
}

