/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.memory;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetReader;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ClobMemTest
extends BaseJDBCTestCase {
    private static final int LONG_CLOB_LENGTH = 18000000;
    private static final String LONG_CLOB_LENGTH_STRING = "18000000";
    private static final char[] SHORT_CLOB_CHARS = new char[]{'\uc911', '\uc5d0', 'a', '\uc608', '\uae30', '\uce58'};

    public ClobMemTest(String string) {
        super(string);
    }

    private void testClobLength(boolean bl) throws SQLException, IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        int n;
        Object object;
        Object object2;
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.executeUpdate("CREATE TABLE CLOBTABLE (K INT CONSTRAINT PK PRIMARY KEY, C CLOB(18000000))");
        PreparedStatement preparedStatement = this.prepareStatement("INSERT INTO CLOBTABLE VALUES(?,?)");
        preparedStatement.setInt(1, 1);
        LoopingAlphabetReader loopingAlphabetReader = new LoopingAlphabetReader(18000000L);
        if (bl) {
            object2 = null;
            try {
                object = preparedStatement.getClass();
                object2 = ((Class)object).getMethod("setCharacterStream", Integer.TYPE, InputStream.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                ClobMemTest.println("Skipping lengthless insert because method is not available");
                return;
            }
            ((Method)object2).invoke((Object)preparedStatement, 2, loopingAlphabetReader);
        } else {
            preparedStatement.setCharacterStream(2, (Reader)loopingAlphabetReader, 18000000);
        }
        preparedStatement.executeUpdate();
        preparedStatement.setInt(1, 2);
        preparedStatement.setString(2, "");
        preparedStatement.executeUpdate();
        preparedStatement.setInt(1, 3);
        preparedStatement.setString(2, null);
        preparedStatement.executeUpdate();
        preparedStatement.setInt(1, 4);
        preparedStatement.setString(2, new String(SHORT_CLOB_CHARS));
        preparedStatement.executeUpdate();
        object2 = statement.executeQuery("SELECT K, LENGTH(C), C FROM CLOBTABLE-- DERBY-PROPERTIES constraint=pk\n ORDER BY K");
        object2.next();
        ClobMemTest.assertEquals((String)LONG_CLOB_LENGTH_STRING, (String)object2.getString(2));
        object = object2.getCharacterStream(3);
        int n2 = 0;
        char[] cArray = new char[32672];
        while ((n = ((Reader)object).read(cArray)) != -1) {
            int n3 = ((n2 += n) - 1) % 26 + 97;
            if (n == 0) continue;
            ClobMemTest.assertEquals((int)n3, (int)cArray[n - 1]);
        }
        ClobMemTest.assertEquals((int)18000000, (int)n2);
        object2.next();
        ClobMemTest.assertEquals((String)"0", (String)object2.getString(2));
        String string = object2.getString(3);
        ClobMemTest.assertEquals((int)0, (int)string.length());
        object2.next();
        ClobMemTest.assertEquals(null, (String)object2.getString(2));
        string = object2.getString(3);
        ClobMemTest.assertEquals(null, (String)string);
        object2.next();
        ClobMemTest.assertEquals((String)("" + SHORT_CLOB_CHARS.length), (String)object2.getString(2));
        string = object2.getString(3);
        ClobMemTest.assertTrue((boolean)Arrays.equals(string.toCharArray(), SHORT_CLOB_CHARS));
        object2.close();
        object2 = statement.executeQuery("SELECT K, LENGTH(C)  FROM CLOBTABLE ORDER BY K");
        JDBC.assertFullResultSet((ResultSet)object2, new String[][]{{"1", LONG_CLOB_LENGTH_STRING}, {"2", "0"}, {"3", null}, {"4", "6"}});
    }

    public void testClobLength() throws SQLException, IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        this.testClobLength(false);
    }

    public void testClobLengthWithLengthlessInsert() throws SQLException, IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        this.testClobLength(true);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite();
        baseTestSuite.addTest((Test)new ClobMemTest("xtestderby6096ClobHashJoin"));
        baseTestSuite.addTest(TestConfiguration.defaultSuite(ClobMemTest.class));
        Properties properties = new Properties();
        properties.setProperty("derby.storage.pageCacheSize", "100");
        return new SystemPropertyTestSetup((Test)baseTestSuite, properties);
    }

    public void testDerby4477_3645_3646_Repro_lowmem_clob() throws SQLException, IOException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        int n = 18000000;
        statement.executeUpdate("CREATE TABLE T_MAIN(ID INT  GENERATED ALWAYS AS IDENTITY PRIMARY KEY, V CLOB(" + n + ") )");
        PreparedStatement preparedStatement = this.prepareStatement("INSERT INTO T_MAIN(V) VALUES (?)");
        int n2 = n;
        LoopingAlphabetReader loopingAlphabetReader = new LoopingAlphabetReader(n2);
        preparedStatement.setCharacterStream(1, (Reader)loopingAlphabetReader, n2);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        statement.executeUpdate("CREATE TABLE T_COPY ( V1 CLOB(" + n + "), V2 CLOB(" + n + "))");
        statement.executeUpdate("INSERT INTO T_COPY SELECT  V, V FROM T_MAIN");
        ResultSet resultSet = statement.executeQuery("SELECT * FROM T_COPY");
        resultSet.next();
        Reader reader = resultSet.getCharacterStream(1);
        loopingAlphabetReader = new LoopingAlphabetReader(n2);
        ClobMemTest.assertEquals(loopingAlphabetReader, reader);
        reader = resultSet.getCharacterStream(2);
        loopingAlphabetReader = new LoopingAlphabetReader(n2);
        ClobMemTest.assertEquals(loopingAlphabetReader, reader);
        resultSet.close();
        resultSet = statement.executeQuery("SELECT 'I', V, ID, V from T_MAIN");
        resultSet.next();
        reader = resultSet.getCharacterStream(2);
        loopingAlphabetReader = new LoopingAlphabetReader(n2);
        ClobMemTest.assertEquals(loopingAlphabetReader, reader);
        reader = resultSet.getCharacterStream(4);
        loopingAlphabetReader = new LoopingAlphabetReader(n2);
        ClobMemTest.assertEquals(loopingAlphabetReader, reader);
        loopingAlphabetReader.close();
        reader.close();
        statement.close();
        resultSet.close();
        this.rollback();
    }

    public void xtestderby6096ClobHashJoin() throws SQLException {
        char[] cArray = new char[32000];
        Arrays.fill(cArray, 'a');
        String string = new String(new char[32000]);
        Statement statement = this.createStatement();
        statement.execute("create table d6096(i int, c clob)");
        PreparedStatement preparedStatement = this.prepareStatement("insert into d6096 values (?, ?)");
        preparedStatement.setString(2, string);
        for (int i = 0; i < 2000; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.execute();
        }
        ResultSet resultSet = statement.executeQuery("select * from d6096 t1, d6096 t2 where t1.i=t2.i");
        ClobMemTest.assertTrue((boolean)resultSet.next());
        if (TestConfiguration.getCurrent().isVerbose()) {
            System.gc();
            ClobMemTest.println("TotalMemory:" + Runtime.getRuntime().totalMemory() + " Free Memory:" + Runtime.getRuntime().freeMemory());
        }
        resultSet.close();
    }
}

