/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.atomic.AtomicBoolean;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class TruncateTableTest
extends BaseJDBCTestCase {
    private static final String TEST_DBO = "TEST_DBO";
    private static final String RUTH = "RUTH";
    private static final String ALICE = "ALICE";
    private static final String[] LEGAL_USERS = new String[]{"TEST_DBO", "RUTH", "ALICE"};
    private static final String UNAUTHORIZED_OPERATION = "42507";

    public TruncateTableTest(String string) {
        super(string);
    }

    public static Test suite() {
        Test test = TestConfiguration.defaultSuite(TruncateTableTest.class);
        Test test2 = DatabasePropertyTestSetup.builtinAuthentication(test, LEGAL_USERS, "");
        Test test3 = TestConfiguration.sqlAuthorizationDecorator(test2);
        return test3;
    }

    public void testTruncateWithIndex() throws SQLException {
        Connection connection = this.openUserConnection(ALICE);
        Statement statement = connection.createStatement();
        statement.executeUpdate("create table t1(a int not null generated always as identity primary key, b varchar(100))");
        statement.executeUpdate("insert into t1(b) values('one'),('two'),('three'),('four'),('five')");
        ResultSet resultSet = statement.executeQuery("select * from t1 order by a");
        String[][] stringArray = new String[][]{{"1", "one"}, {"2", "two"}, {"3", "three"}, {"4", "four"}, {"5", "five"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.executeUpdate("truncate table t1");
        JDBC.assertEmpty(statement.executeQuery("select * from t1"));
        statement.executeUpdate("insert into t1(b) values('six'),('seven')");
        resultSet = statement.executeQuery("select * from t1 order by a");
        stringArray = new String[][]{{"6", "six"}, {"7", "seven"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.close();
        connection.close();
    }

    public void testTruncateWithDeleteTrigger() throws Exception {
        Connection connection = this.openUserConnection(ALICE);
        Statement statement = connection.createStatement();
        statement.execute("create table deltriggertest_t1(x int)");
        statement.execute("create table deltriggertest_t2(y int)");
        statement.execute("create trigger deltriggertest_tr after delete on deltriggertest_t1 referencing old as old for each row insert into deltriggertest_t2 values old.x");
        PreparedStatement preparedStatement = connection.prepareStatement("select count(*) from deltriggertest_t2");
        statement.execute("insert into deltriggertest_t1 values 1,2,3");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "0");
        TruncateTableTest.assertUpdateCount(statement, 3, "delete from deltriggertest_t1");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "3");
        statement.execute("insert into deltriggertest_t1 values 4,5");
        TruncateTableTest.assertStatementError("XCL49", statement, "truncate table deltriggertest_t1");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "3");
    }

    public void testTruncateWithForeignKey() throws SQLException {
        Connection connection = this.openUserConnection(ALICE);
        Statement statement = connection.createStatement();
        statement.execute("create table foreignkey_t1(x int primary key)");
        statement.execute("create table foreignkey_t2(y int references foreignkey_t1)");
        statement.execute("insert into foreignkey_t1 values 1,2");
        statement.execute("insert into foreignkey_t2 values 2");
        TruncateTableTest.assertStatementError("XCL48", statement, "truncate table foreignkey_t1");
        statement.execute("truncate table foreignkey_t2");
        JDBC.assertEmpty(statement.executeQuery("select * from foreignkey_t2"));
    }

    public void testSelfReferencing() throws SQLException {
        Connection connection = this.openUserConnection(ALICE);
        Statement statement = connection.createStatement();
        try {
            statement.execute("CREATE SCHEMA ALICE");
        }
        catch (SQLException sQLException) {
            TruncateTableTest.assertSQLState("X0Y68", sQLException);
        }
        statement.execute("create table self_referencing_t1(x int primary key, y int references self_referencing_t1)");
        statement.execute("insert into self_referencing_t1 values (1, null), (2, 1)");
        statement.execute("truncate table self_referencing_t1");
        JDBC.assertEmpty(statement.executeQuery("select * from self_referencing_t1"));
    }

    public void testPerms() throws Exception {
        Connection connection = this.openUserConnection(TEST_DBO);
        Connection connection2 = this.openUserConnection(ALICE);
        Connection connection3 = this.openUserConnection(RUTH);
        Statement statement = connection.createStatement();
        Statement statement2 = connection2.createStatement();
        Statement statement3 = connection3.createStatement();
        statement2.execute("create table t_perm( a int )");
        statement2.execute("grant delete on t_perm to public");
        statement2.execute("grant select on t_perm to public");
        statement2.execute("insert into t_perm( a ) values ( 1 )");
        statement2.execute("truncate table t_perm");
        JDBC.assertEmpty(statement2.executeQuery("select * from t_perm"));
        statement2.execute("insert into t_perm( a ) values ( 2 )");
        TruncateTableTest.assertStatementError(UNAUTHORIZED_OPERATION, statement3, "truncate table alice.t_perm");
        JDBC.assertFullResultSet(statement3.executeQuery("select * from alice.t_perm"), new String[][]{{"2"}});
        statement3.execute("delete from alice.t_perm");
        JDBC.assertEmpty(statement3.executeQuery("select * from alice.t_perm"));
        statement2.execute("insert into t_perm( a ) values ( 3 )");
        JDBC.assertFullResultSet(statement2.executeQuery("select * from alice.t_perm"), new String[][]{{"3"}});
        statement.execute("truncate table alice.t_perm");
        JDBC.assertEmpty(statement.executeQuery("select * from alice.t_perm"));
        statement.close();
        statement2.close();
        statement3.close();
        connection.close();
        connection2.close();
        connection3.close();
    }

    public void testCursor() throws Exception {
        Connection connection = this.openUserConnection(ALICE);
        Connection connection2 = this.openUserConnection(ALICE);
        connection.setAutoCommit(false);
        connection2.setAutoCommit(false);
        this.cursorMinion(connection, connection2, "truncateTab", "truncate table ");
        this.cursorMinion(connection, connection2, "dropTab", "drop table ");
        connection.close();
    }

    private void cursorMinion(Connection connection, Connection connection2, String string, String string2) throws Exception {
        Statement statement = connection.createStatement();
        Statement statement2 = connection2.createStatement();
        statement.execute("create table " + string + "( a int )");
        statement.execute("insert into " + string + "( a ) values ( 1 ), ( 2 )");
        statement.close();
        connection.commit();
        Statement statement3 = connection.createStatement(1005, 1007, 1);
        ResultSet resultSet = statement3.executeQuery("select * from " + string);
        resultSet.next();
        TruncateTableTest.assertEquals((int)1, (int)resultSet.getInt(1));
        connection.commit();
        statement2.execute(string2 + string);
        connection2.commit();
        resultSet.next();
        TruncateTableTest.assertEquals((int)2, (int)resultSet.getInt(1));
        TruncateTableTest.assertFalse((boolean)resultSet.next());
        resultSet.close();
        connection.commit();
        statement3.close();
        statement2.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConcurrentInvalidation() throws Exception {
        Statement statement = this.createStatement();
        statement.execute("create table d4275(x int)");
        final AtomicBoolean atomicBoolean = new AtomicBoolean();
        final Throwable[] throwableArray = new Throwable[1];
        Connection connection = this.openDefaultConnection();
        final PreparedStatement preparedStatement = connection.prepareStatement("select * from d4275");
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    while (!atomicBoolean.get()) {
                        JDBC.assertEmpty(preparedStatement.executeQuery());
                    }
                }
                catch (Throwable throwable) {
                    throwableArray[0] = throwable;
                }
            }
        };
        thread.start();
        try {
            for (int i = 0; i < 100; ++i) {
                statement.execute("truncate table d4275");
            }
        }
        finally {
            atomicBoolean.set(true);
        }
        thread.join();
        if (throwableArray[0] != null) {
            TruncateTableTest.fail("Helper thread failed", throwableArray[0]);
        }
        preparedStatement.close();
        connection.close();
    }
}

