/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.oe.run;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.derbyTesting.system.oe.load.SimpleInsert;
import org.apache.derbyTesting.system.oe.util.HandleCheckError;
import org.apache.derbyTesting.system.oe.util.OEChecks;

public class DriverUtility {
    private Connection conn = null;
    private static short scale = 1;
    private static String dbUrl = "jdbc:derby:wombat;create=true";
    private static String driver = "org.apache.derby.jdbc.EmbeddedDriver";
    private static boolean doChecks = true;

    public DriverUtility() {
        try {
            Class.forName(driver);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        DriverUtility.parseArgs(stringArray);
        DriverUtility driverUtility = new DriverUtility();
        driverUtility.populate();
        if (doChecks) {
            driverUtility.allChecks();
        }
        driverUtility.cleanup();
    }

    public Connection getConnection() throws SQLException {
        if (this.conn == null) {
            System.out.println("dbUrl=" + dbUrl);
            this.conn = DriverManager.getConnection(dbUrl);
        }
        return this.conn;
    }

    public void populate() throws Exception {
        SimpleInsert simpleInsert = new SimpleInsert();
        simpleInsert.setupLoad(this.getConnection(), scale);
        long l = System.currentTimeMillis();
        simpleInsert.populateAllTables();
        long l2 = System.currentTimeMillis();
        System.out.println("Time to load (ms)=" + (l2 - l));
    }

    public void allChecks() throws Exception {
        OEChecks oEChecks = new OEChecks();
        oEChecks.initialize(new HandleCheckError(), this.getConnection(), scale);
        long l = System.currentTimeMillis();
        oEChecks.checkAllRowCounts();
        long l2 = System.currentTimeMillis();
        System.out.println("Time to do checks (ms)=" + (l2 - l));
    }

    private static void parseArgs(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.equals("-scale")) {
                scale = Short.parseShort(stringArray[++i]);
                continue;
            }
            if (string.equals("-driver")) {
                driver = stringArray[++i];
                continue;
            }
            if (string.equals("-dbUrl")) {
                dbUrl = stringArray[++i];
                continue;
            }
            if (string.equals("-doChecks")) {
                doChecks = !stringArray[++i].equals("false");
                continue;
            }
            if (string.equals("-help")) {
                DriverUtility.printUsage();
                System.exit(0);
                continue;
            }
            System.err.println("Invalid option: " + stringArray[i]);
            System.exit(1);
        }
    }

    private static void printUsage() {
        System.out.println("Usage: java org.apache.derbyTesting.system.oe.run.DriverUtility options");
        System.out.println();
        System.out.println("Options:");
        System.out.println("  -scale warehouse scaling factor. Takes a short value. If not specified defaults to 1");
        System.out.println("  -doChecks  should consistency checks be run on the database. Takes a boolean value");
        System.out.println("  -driver  the class of the jdbc driver");
        System.out.println("  -dbUrl  the database connection url");
        System.out.println("  -help prints usage");
        System.out.println();
    }

    public void cleanup() throws SQLException {
        if (this.conn != null) {
            this.conn.close();
        }
    }
}

