/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.store;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.locks.LockFactory;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.store.raw.ContainerHandle;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.store.raw.RawStoreFactory;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.impl.store.raw.log.LogToFile;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;
import org.apache.derbyTesting.unitTests.harness.T_Fail;
import org.apache.derbyTesting.unitTests.harness.T_Generic;
import org.apache.derbyTesting.unitTests.store.T_RawStoreRow;
import org.apache.derbyTesting.unitTests.store.T_TWC;
import org.apache.derbyTesting.unitTests.store.T_Util;

public class T_RecoverFullLog
extends T_Generic {
    private static final String testService = "FullLogTest";
    static final String REC_001 = "McLaren";
    static final String REC_002 = "Ferrari";
    static final String REC_003 = "Benetton";
    static final String REC_004 = "Prost";
    static final String REC_005 = "Tyrell";
    static final String REC_006 = "Derby, Natscape, Goatscape, the popular names";
    static final String REC_UNDO = "Lotus";
    static final String SP1 = "savepoint1";
    static final String SP2 = "savepoint2";
    private RandomAccessFile infofile = null;
    private static final String infoPath = "extinout/T_RecoverFullLog.info";
    private boolean fillLog;
    private boolean recoveryFail;
    private boolean logSwitchFail;
    private boolean recover;
    private String TEST_FILL_LOG = "TestFillLog";
    private String TEST_FULL_RECOVER_FAIL = "TestFullRecoveryFail";
    private String TEST_LOG_SWITCH_FAIL = "TestLogSwitchFail";
    private String TEST_FULL_RECOVER = "TestFullRecover";
    private static final String TEST_FULL_LOG_INFO = "TestFullLogInfo";
    RawStoreFactory factory;
    LockFactory lf;
    ContextService contextService;
    T_Util t_util;

    @Override
    public String getModuleToTestProtocolName() {
        return "org.apache.derby.iapi.store.raw.RawStoreFactory";
    }

    private void getConfig() {
        String string = PropertyUtil.getSystemProperty((String)this.TEST_FILL_LOG);
        this.fillLog = Boolean.valueOf(string);
        string = PropertyUtil.getSystemProperty((String)this.TEST_FULL_RECOVER_FAIL);
        this.recoveryFail = Boolean.valueOf(string);
        string = PropertyUtil.getSystemProperty((String)this.TEST_FULL_RECOVER);
        this.recover = Boolean.valueOf(string);
        string = PropertyUtil.getSystemProperty((String)this.TEST_LOG_SWITCH_FAIL);
        this.logSwitchFail = Boolean.valueOf(string);
    }

    @Override
    public void runTests() throws T_Fail {
        this.getConfig();
        int n = 0;
        if (this.fillLog) {
            ++n;
        }
        if (this.recoveryFail) {
            ++n;
        }
        if (this.recover) {
            ++n;
        }
        if (this.logSwitchFail) {
            ++n;
        }
        if (n != 1) {
            throw T_Fail.testFailMsg("One & only one of the full log recovery test should be run, now " + n + " set");
        }
        this.REPORT("recoverBadLog cannot be run on an insane server");
    }

    private long find(long l) {
        if (this.infofile == null) {
            return -1L;
        }
        try {
            this.infofile.seek(0L);
            while (true) {
                long l2;
                if ((l2 = this.infofile.readLong()) == l) {
                    long l3 = this.infofile.readLong();
                    return l3;
                }
                this.infofile.readLong();
            }
        }
        catch (IOException iOException) {
            return -1L;
        }
    }

    private long key(int n, int n2) {
        long l = n;
        return (l << 32) + (long)n2;
    }

    private void register(long l, long l2) throws T_Fail {
        try {
            this.infofile.seek(this.infofile.length());
            this.infofile.writeLong(l);
            this.infofile.writeLong(l2);
        }
        catch (IOException iOException) {
            T_Fail.exceptionFail(iOException);
        }
    }

    protected void testBasic(int n) throws T_Fail, StandardException {
        int n2;
        int n3;
        int n4 = 7;
        int n5 = 7;
        T_TWC[] t_TWCArray = new T_TWC[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            t_TWCArray[n3] = this.t_util.t_startTransactionWithContext();
        }
        long[] lArray = new long[n4];
        ContainerHandle[] containerHandleArray = new ContainerHandle[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            lArray[n3] = this.t_util.t_addContainer(t_TWCArray[n3], 0L);
            this.t_util.t_commit(t_TWCArray[n3]);
            containerHandleArray[n3] = this.t_util.t_openContainer(t_TWCArray[n3], 0L, lArray[n3], true);
        }
        Page[][] pageArray = new Page[n4][n5];
        long[][] lArray2 = new long[n4][n5];
        for (n3 = 0; n3 < n4; ++n3) {
            for (n2 = 0; n2 < n5; ++n2) {
                t_TWCArray[n3].switchTransactionContext();
                pageArray[n3][n2] = this.t_util.t_addPage(containerHandleArray[n3]);
                lArray2[n3][n2] = pageArray[n3][n2].getPageNumber();
                t_TWCArray[n3].resetContext();
            }
        }
        RecordHandle[][] recordHandleArray = new RecordHandle[n4][n5];
        T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(REC_001);
        for (n3 = 0; n3 < n4; ++n3) {
            for (n2 = 0; n2 < n5; ++n2) {
                t_TWCArray[n3].switchTransactionContext();
                recordHandleArray[n3][n2] = T_Util.t_insert(pageArray[n3][n2], t_RawStoreRow);
                t_TWCArray[n3].resetContext();
            }
        }
        t_TWCArray[0].setSavePoint(SP1, null);
        T_RawStoreRow t_RawStoreRow2 = new T_RawStoreRow(REC_002);
        for (n3 = 0; n3 < n4; ++n3) {
            for (n2 = 0; n2 < n5; ++n2) {
                t_TWCArray[n3].switchTransactionContext();
                int n6 = pageArray[n3][n2].getSlotNumber(recordHandleArray[n3][n2]);
                pageArray[n3][n2].updateAtSlot(n6, (Object[])t_RawStoreRow2.getRow(), null);
                t_TWCArray[n3].resetContext();
            }
        }
        for (n3 = 1; n3 < n4; ++n3) {
            t_TWCArray[n3].setSavePoint(SP1, null);
        }
        T_RawStoreRow t_RawStoreRow3 = new T_RawStoreRow(REC_003);
        for (n3 = 0; n3 < n4; ++n3) {
            for (n2 = 0; n2 < n5; ++n2) {
                int n7 = pageArray[n3][n2].getSlotNumber(recordHandleArray[n3][n2]);
                pageArray[n3][n2].updateAtSlot(n7, (Object[])t_RawStoreRow3.getRow(), null);
            }
        }
        for (n3 = 0; n3 < n4; ++n3) {
            t_TWCArray[n3].setSavePoint(SP2, null);
        }
        T_RawStoreRow t_RawStoreRow4 = new T_RawStoreRow(REC_004);
        for (n3 = 0; n3 < n4; ++n3) {
            t_TWCArray[n3].switchTransactionContext();
            for (n2 = 0; n2 < n5; ++n2) {
                int n8 = pageArray[n3][n2].getSlotNumber(recordHandleArray[n3][n2]);
                pageArray[n3][n2].updateAtSlot(n8, (Object[])t_RawStoreRow4.getRow(), null);
            }
            t_TWCArray[n3].resetContext();
        }
        t_TWCArray[0].switchTransactionContext();
        for (n2 = 0; n2 < n5; ++n2) {
            pageArray[0][n2].unlatch();
        }
        t_TWCArray[0].rollbackToSavePoint(SP1, null);
        for (n2 = 0; n2 < n5; ++n2) {
            pageArray[0][n2] = this.t_util.t_getPage(containerHandleArray[0], lArray2[0][n2]);
        }
        t_TWCArray[0].resetContext();
        for (n3 = 1; n3 < n4; ++n3) {
            t_TWCArray[n3].switchTransactionContext();
            for (n2 = 0; n2 < n5; ++n2) {
                T_Util.t_checkFetch(pageArray[n3][n2], recordHandleArray[n3][n2], REC_004);
            }
            t_TWCArray[n3].resetContext();
        }
        t_TWCArray[0].switchTransactionContext();
        for (n2 = 0; n2 < n5; ++n2) {
            T_Util.t_checkFetch(pageArray[0][n2], recordHandleArray[0][n2], REC_001);
        }
        t_TWCArray[0].resetContext();
        T_RawStoreRow t_RawStoreRow5 = new T_RawStoreRow(REC_005);
        for (n3 = 0; n3 < n4; ++n3) {
            t_TWCArray[n3].switchTransactionContext();
            for (n2 = 0; n2 < n5; ++n2) {
                int n9 = pageArray[n3][n2].getSlotNumber(recordHandleArray[n3][n2]);
                pageArray[n3][n2].updateAtSlot(n9, (Object[])t_RawStoreRow5.getRow(), null);
            }
            t_TWCArray[n3].resetContext();
        }
        for (n3 = 1; n3 < n4; ++n3) {
            t_TWCArray[n3].switchTransactionContext();
            for (n2 = 0; n2 < n5; ++n2) {
                pageArray[n3][n2].unlatch();
            }
            t_TWCArray[n3].rollbackToSavePoint(SP2, null);
            for (n2 = 0; n2 < n5; ++n2) {
                pageArray[n3][n2] = this.t_util.t_getPage(containerHandleArray[n3], lArray2[n3][n2]);
            }
            t_TWCArray[n3].resetContext();
        }
        for (n3 = 1; n3 < n4; ++n3) {
            t_TWCArray[n3].switchTransactionContext();
            for (n2 = 0; n2 < n5; ++n2) {
                T_Util.t_checkFetch(pageArray[n3][n2], recordHandleArray[n3][n2], REC_003);
            }
            t_TWCArray[n3].resetContext();
        }
        t_TWCArray[0].switchTransactionContext();
        for (n2 = 0; n2 < n5; ++n2) {
            T_Util.t_checkFetch(pageArray[0][n2], recordHandleArray[0][n2], REC_005);
        }
        t_TWCArray[0].resetContext();
        T_RawStoreRow t_RawStoreRow6 = new T_RawStoreRow(REC_006);
        for (n3 = 0; n3 < n4; ++n3) {
            t_TWCArray[n3].switchTransactionContext();
            for (n2 = 0; n2 < n5; ++n2) {
                int n10 = pageArray[n3][n2].getSlotNumber(recordHandleArray[n3][n2]);
                pageArray[n3][n2].updateAtSlot(n10, (Object[])t_RawStoreRow6.getRow(), null);
            }
            t_TWCArray[n3].resetContext();
        }
        t_TWCArray[0].switchTransactionContext();
        for (n2 = 0; n2 < n5; ++n2) {
            pageArray[0][n2].unlatch();
        }
        t_TWCArray[0].rollbackToSavePoint(SP1, null);
        for (n2 = 0; n2 < n5; ++n2) {
            pageArray[0][n2] = this.t_util.t_getPage(containerHandleArray[0], lArray2[0][n2]);
        }
        t_TWCArray[0].resetContext();
        for (n3 = 1; n3 < n4; ++n3) {
            t_TWCArray[n3].switchTransactionContext();
            for (n2 = 0; n2 < n5; ++n2) {
                T_Util.t_checkFetch(pageArray[n3][n2], recordHandleArray[n3][n2], REC_006);
                T_Util.t_checkRecordCount(pageArray[n3][n2], 1, 1);
            }
            t_TWCArray[n3].resetContext();
        }
        t_TWCArray[0].switchTransactionContext();
        for (n2 = 0; n2 < n5; ++n2) {
            T_Util.t_checkFetch(pageArray[0][n2], recordHandleArray[0][n2], REC_001);
            T_Util.t_checkRecordCount(pageArray[0][n2], 1, 1);
        }
        t_TWCArray[0].resetContext();
        for (n3 = 0; n3 < n4; ++n3) {
            t_TWCArray[n3].switchTransactionContext();
            for (n2 = 0; n2 < n5; ++n2) {
                pageArray[n3][n2].unlatch();
            }
            t_TWCArray[n3].resetContext();
        }
        this.t_util.t_abort(t_TWCArray[1]);
        this.t_util.t_commit(t_TWCArray[2]);
        this.t_util.t_commit(t_TWCArray[4]);
        containerHandleArray[1] = this.t_util.t_openContainer(t_TWCArray[1], 0L, lArray[1], false);
        containerHandleArray[2] = this.t_util.t_openContainer(t_TWCArray[2], 0L, lArray[2], false);
        containerHandleArray[4] = this.t_util.t_openContainer(t_TWCArray[4], 0L, lArray[4], false);
        for (n2 = 0; n2 < n5; ++n2) {
            t_TWCArray[0].switchTransactionContext();
            this.t_util.t_checkFetch(containerHandleArray[0], recordHandleArray[0][n2], REC_001);
            t_TWCArray[0].resetContext();
            t_TWCArray[1].switchTransactionContext();
            pageArray[1][n2] = this.t_util.t_getPage(containerHandleArray[1], lArray2[1][n2]);
            T_Util.t_checkRecordCount(pageArray[1][n2], 1, 0);
            T_Util.t_checkFetchBySlot(pageArray[1][n2], 0, REC_001, true, false);
            pageArray[1][n2].unlatch();
            t_TWCArray[1].resetContext();
            t_TWCArray[2].switchTransactionContext();
            this.t_util.t_checkFetch(containerHandleArray[2], recordHandleArray[2][n2], REC_006);
            t_TWCArray[2].resetContext();
            t_TWCArray[3].switchTransactionContext();
            this.t_util.t_checkFetch(containerHandleArray[3], recordHandleArray[3][n2], REC_006);
            t_TWCArray[3].resetContext();
            t_TWCArray[4].switchTransactionContext();
            this.t_util.t_checkFetch(containerHandleArray[4], recordHandleArray[4][n2], REC_006);
            t_TWCArray[4].resetContext();
        }
        for (n3 = 0; n3 < n4; ++n3) {
            this.register(this.key(n, n3 + 10), lArray[n3]);
            String string = "container " + n3 + ":" + this.find(this.key(n, n3 + 10)) + " pages: ";
            for (n2 = 0; n2 < n5; ++n2) {
                string = string + lArray2[n3][n2] + " ";
                this.register(this.key(n, (n3 + 1) * 1000 + n2), lArray2[n3][n2]);
            }
            this.REPORT("\t" + string);
        }
        this.register(this.key(n, 1), n4);
        this.register(this.key(n, 2), n5);
    }

    protected void fillUpLog() throws T_Fail, StandardException {
        SanityManager.DEBUG_SET((String)LogToFile.TEST_LOG_FULL);
        System.setProperty(LogToFile.TEST_RECORD_TO_FILL_LOG, "1");
        Transaction transaction = this.t_util.t_startTransaction();
        try {
            long l = this.t_util.t_addContainer(transaction, 0L);
        }
        catch (StandardException standardException) {
            this.REPORT("_______________________________________________________");
            this.REPORT("\n\tlog filled up as requested");
            this.REPORT("_______________________________________________________");
            return;
        }
        catch (NullPointerException nullPointerException) {
            this.REPORT("_______________________________________________________");
            this.REPORT("\n\tlog filled up as requested");
            this.REPORT("_______________________________________________________");
            return;
        }
        throw T_Fail.testFailMsg("log should have filled but did not");
    }

    protected void logSwitchFail1() throws T_Fail, StandardException {
        SanityManager.DEBUG_SET((String)LogToFile.TEST_SWITCH_LOG_FAIL1);
        this.factory.checkpoint();
        SanityManager.DEBUG_CLEAR((String)LogToFile.TEST_SWITCH_LOG_FAIL1);
    }

    protected void logSwitchFail2() throws T_Fail, StandardException {
        SanityManager.DEBUG_SET((String)LogToFile.TEST_SWITCH_LOG_FAIL2);
        int n = 10;
        try {
            for (int i = 10; i < 110 + n; ++i) {
                this.factory.checkpoint();
                this.testBasic(i);
            }
        }
        catch (StandardException standardException) {
            this.REPORT("_______________________________________________________");
            this.REPORT("\n\tlog switch failed as requested");
            this.REPORT("_______________________________________________________");
            return;
        }
        catch (NullPointerException nullPointerException) {
            this.REPORT("_______________________________________________________");
            this.REPORT("\n\tlog switch failed as requested");
            this.REPORT("_______________________________________________________");
            return;
        }
        finally {
            SanityManager.DEBUG_CLEAR((String)LogToFile.TEST_SWITCH_LOG_FAIL2);
        }
        throw T_Fail.testFailMsg("log switch should have failed but did not even after " + n + " tries");
    }

    protected void checkRecovery() throws T_Fail, StandardException {
        for (int i = 1; i <= 3; ++i) {
            int n;
            int n2;
            int n3 = (int)this.find(this.key(i, 1));
            int n4 = (int)this.find(this.key(i, 2));
            if (n3 < 5 || n4 < 1) {
                this.REPORT("full log test " + i + " not run");
                continue;
            }
            this.REPORT("Test recovery of test " + i);
            Transaction transaction = this.t_util.t_startTransaction();
            long[] lArray = new long[n3];
            ContainerHandle[] containerHandleArray = new ContainerHandle[n3];
            long[][] lArray2 = new long[n3][n4];
            Page[][] pageArray = new Page[n3][n4];
            for (n2 = 0; n2 < n3; ++n2) {
                lArray[n2] = this.find(this.key(i, n2 + 10));
                containerHandleArray[n2] = this.t_util.t_openContainer(transaction, 0L, lArray[n2], true);
                for (n = 0; n < n4; ++n) {
                    lArray2[n2][n] = this.find(this.key(i, (n2 + 1) * 1000 + n));
                    pageArray[n2][n] = this.t_util.t_getPage(containerHandleArray[n2], lArray2[n2][n]);
                }
            }
            for (n = 0; n < n4; ++n) {
                T_Util.t_checkRecordCount(pageArray[0][n], 1, 0);
                T_Util.t_checkFetchBySlot(pageArray[0][n], 0, REC_001, true, true);
                T_Util.t_checkRecordCount(pageArray[1][n], 1, 0);
                T_Util.t_checkFetchBySlot(pageArray[1][n], 0, REC_001, true, true);
                T_Util.t_checkRecordCount(pageArray[2][n], 1, 1);
                T_Util.t_checkFetchBySlot(pageArray[2][n], 0, REC_006, false, true);
                T_Util.t_checkRecordCount(pageArray[3][n], 1, 0);
                T_Util.t_checkFetchBySlot(pageArray[3][n], 0, REC_001, true, true);
                T_Util.t_checkRecordCount(pageArray[4][n], 1, 1);
                T_Util.t_checkFetchBySlot(pageArray[4][n], 0, REC_006, false, true);
            }
            for (n2 = 0; n2 < n3; ++n2) {
                String string = "container " + n2 + ":" + lArray[n2] + " pages: ";
                for (n = 0; n < n4; ++n) {
                    string = string + lArray2[n2][n] + " ";
                }
                this.REPORT("\t" + string);
            }
            this.t_util.t_commit(transaction);
            transaction.close();
        }
    }

    private static ContextService getContextService() {
        return AccessController.doPrivileged(new PrivilegedAction<ContextService>(){

            @Override
            public ContextService run() {
                return ContextService.getFactory();
            }
        });
    }

    private static Object findService(final String string, final String string2) {
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return Monitor.findService((String)string, (String)string2);
            }
        });
    }

    private static boolean startPersistentService(final String string, final Properties properties) throws StandardException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() throws StandardException {
                    return Monitor.startPersistentService((String)string, (Properties)properties);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw StandardException.plainWrapException((Throwable)privilegedActionException);
        }
    }

    private static Object createPersistentService(final String string, final String string2, final Properties properties) throws StandardException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws StandardException {
                    return Monitor.createPersistentService((String)string, (String)string2, (Properties)properties);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw StandardException.plainWrapException((Throwable)privilegedActionException);
        }
    }
}

