/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.monitor;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.apache.derby.iapi.services.io.FileUtil;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.monitor.PersistentService;
import org.apache.derby.io.StorageFactory;
import org.apache.derby.io.StorageFile;
import org.apache.derby.io.WritableStorageFactory;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.i18n.MessageService;
import org.apache.derby.shared.common.sanity.SanityManager;

final class StorageFactoryService
implements PersistentService {
    private static final String SERVICE_PROPERTIES_EOF_TOKEN = "#--- last line, don't put anything after this line ---";
    private String home;
    private String canonicalHome;
    private final String subSubProtocol;
    private final Class<?> storageFactoryClass;
    private StorageFactory rootStorageFactory;
    private char separatorChar;

    StorageFactoryService(String subSubProtocol, Class storageFactoryClass) throws StandardException {
        this.subSubProtocol = subSubProtocol;
        this.storageFactoryClass = storageFactoryClass;
        Object monitorEnv = StorageFactoryService.getMonitor().getEnvironment();
        if (monitorEnv instanceof File) {
            final File relativeRoot = (File)monitorEnv;
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws IOException, StandardException {
                        StorageFile rootDir;
                        boolean created;
                        StorageFactoryService.this.home = relativeRoot.getPath();
                        StorageFactoryService.this.canonicalHome = relativeRoot.getCanonicalPath();
                        StorageFactoryService.this.rootStorageFactory = StorageFactoryService.this.getStorageFactoryInstance(true, null, null, null);
                        if (StorageFactoryService.this.home != null && (created = (rootDir = StorageFactoryService.this.rootStorageFactory.newStorageFile(null)).mkdirs())) {
                            rootDir.limitAccessToOwner();
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                this.home = null;
                this.canonicalHome = null;
            }
        }
        if (this.rootStorageFactory == null) {
            try {
                this.rootStorageFactory = this.getStorageFactoryInstance(true, null, null, null);
            }
            catch (IOException ioe) {
                throw Monitor.exceptionStartingModule(ioe);
            }
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                StorageFactoryService.this.separatorChar = StorageFactoryService.this.rootStorageFactory.getSeparator();
                return null;
            }
        });
    }

    @Override
    public boolean hasStorageFactory() {
        return true;
    }

    @Override
    public StorageFactory getStorageFactoryInstance(final boolean useHome, final String databaseName, final String tempDirName, final String uniqueName) throws StandardException, IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<StorageFactory>(){

                @Override
                public StorageFactory run() throws InstantiationException, IllegalAccessException, IOException, NoSuchMethodException, InvocationTargetException {
                    return StorageFactoryService.this.privGetStorageFactoryInstance(useHome, databaseName, tempDirName, uniqueName);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            throw StandardException.newException("XBM0W.S", e, this.subSubProtocol, this.storageFactoryClass);
        }
    }

    private StorageFactory privGetStorageFactoryInstance(boolean useHome, String databaseName, String tempDirName, String uniqueName) throws InstantiationException, IllegalAccessException, IOException, NoSuchMethodException, InvocationTargetException {
        StorageFactory storageFactory = (StorageFactory)this.storageFactoryClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        String dbn = databaseName != null && this.subSubProtocol != null && databaseName.startsWith(this.subSubProtocol + ":") ? databaseName.substring(this.subSubProtocol.length() + 1) : databaseName;
        storageFactory.init(useHome ? this.home : null, dbn, tempDirName, uniqueName);
        return storageFactory;
    }

    @Override
    public String getType() {
        return this.subSubProtocol;
    }

    @Override
    public Enumeration getBootTimeServices() {
        if (this.home == null) {
            return null;
        }
        return new DirectoryList();
    }

    @Override
    public Properties getServiceProperties(final String serviceName, Properties defaultProperties) throws StandardException {
        if (!serviceName.equals(this.getCanonicalServiceName(serviceName))) {
            SanityManager.THROWASSERT("serviceName (" + serviceName + ") expected to equal getCanonicalServiceName(serviceName) (" + this.getCanonicalServiceName(serviceName) + ")");
        }
        final String recreateFrom = this.recreateServiceRoot(serviceName, defaultProperties);
        final Properties serviceProperties = new Properties(defaultProperties);
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object run() throws IOException, StandardException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
                    if (recreateFrom != null) {
                        File propFile = new File(recreateFrom, "service.properties");
                        try (FileInputStream is = new FileInputStream(propFile);){
                            serviceProperties.load(new BufferedInputStream(is));
                        }
                    }
                    StorageFactory storageFactory = StorageFactoryService.this.privGetStorageFactoryInstance(true, serviceName, null, null);
                    StorageFile file = storageFactory.newStorageFile("service.properties");
                    StorageFactoryService.this.resolveServicePropertiesFiles(storageFactory, file);
                    try (InputStream is = file.getInputStream();){
                        serviceProperties.load(new BufferedInputStream(is));
                    }
                    finally {
                        storageFactory.shutdown();
                    }
                    return null;
                }
            });
            return serviceProperties;
        }
        catch (PrivilegedActionException pae) {
            if (pae.getException() instanceof FileNotFoundException) {
                return null;
            }
            throw Monitor.exceptionStartingModule(pae.getException());
        }
        catch (SecurityException se) {
            throw Monitor.exceptionStartingModule(se);
        }
    }

    @Override
    public void saveServiceProperties(final String serviceName, StorageFactory sf, final Properties properties, final boolean replace) throws StandardException {
        SanityManager.ASSERT(serviceName.equals(this.getCanonicalServiceName(serviceName)), serviceName);
        if (!(sf instanceof WritableStorageFactory)) {
            throw StandardException.newException("XBM0P.D", new Object[0]);
        }
        final WritableStorageFactory storageFactory = (WritableStorageFactory)sf;
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws StandardException {
                    StorageFile backupFile = replace ? storageFactory.newStorageFile("service.properties".concat("old")) : null;
                    StorageFile servicePropertiesFile = storageFactory.newStorageFile("service.properties");
                    FileOperationHelper foh = new FileOperationHelper();
                    if (replace) {
                        foh.renameTo(servicePropertiesFile, backupFile, true);
                    }
                    OutputStream os = null;
                    try {
                        os = servicePropertiesFile.getOutputStream();
                        properties.store(os, serviceName + MessageService.getTextMessage("M001", new Object[0]));
                        BufferedWriter bOut = new BufferedWriter(new OutputStreamWriter(os, "ISO-8859-1"));
                        bOut.write(StorageFactoryService.SERVICE_PROPERTIES_EOF_TOKEN);
                        bOut.newLine();
                        storageFactory.sync(os, false);
                        bOut.close();
                        os.close();
                        os = null;
                    }
                    catch (IOException ioe) {
                        if (backupFile != null) {
                            foh.renameTo(backupFile, servicePropertiesFile, false);
                        }
                        if (replace) {
                            throw StandardException.newException("XBM0B.D", ioe, new Object[0]);
                        }
                        throw Monitor.exceptionStartingModule(ioe);
                    }
                    finally {
                        if (os != null) {
                            try {
                                os.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    if (backupFile != null && !foh.delete(backupFile, false)) {
                        Monitor.getStream().printlnWithHeader(MessageService.getTextMessage("M004", StorageFactoryService.getMostAccuratePath(backupFile)));
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (StandardException)pae.getException();
        }
    }

    @Override
    public void createDataWarningFile(StorageFactory sf) throws StandardException {
        if (!(sf instanceof WritableStorageFactory)) {
            throw StandardException.newException("XBM0P.D", new Object[0]);
        }
        final WritableStorageFactory storageFactory = (WritableStorageFactory)sf;
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws StandardException {
                    OutputStreamWriter osw = null;
                    try {
                        StorageFile fileReadMe = storageFactory.newStorageFile("README_DO_NOT_TOUCH_FILES.txt");
                        osw = new OutputStreamWriter(fileReadMe.getOutputStream(), "UTF8");
                        osw.write(MessageService.getTextMessage("M005", new Object[0]));
                    }
                    catch (IOException iOException) {
                    }
                    finally {
                        if (osw != null) {
                            try {
                                osw.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (StandardException)pae.getException();
        }
    }

    @Override
    public void saveServiceProperties(final String serviceName, final Properties properties) throws StandardException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws StandardException {
                    File servicePropertiesFile = new File(serviceName, "service.properties");
                    FileOutputStream fos = null;
                    try {
                        fos = new FileOutputStream(servicePropertiesFile);
                        FileUtil.limitAccessToOwner(servicePropertiesFile);
                        properties.store(fos, serviceName + MessageService.getTextMessage("M001", new Object[0]));
                        fos.getFD().sync();
                        fos.close();
                        fos = null;
                    }
                    catch (IOException ioe) {
                        if (fos != null) {
                            try {
                                fos.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            fos = null;
                        }
                        throw Monitor.exceptionStartingModule(ioe);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (StandardException)pae.getException();
        }
    }

    private void resolveServicePropertiesFiles(StorageFactory sf, StorageFile spf) throws StandardException {
        StorageFile spfOld = sf.newStorageFile("service.properties".concat("old"));
        FileOperationHelper foh = new FileOperationHelper();
        boolean hasCurrent = foh.exists(spf, true);
        boolean hasBackup = foh.exists(spfOld, true);
        if (hasCurrent && !hasBackup) {
            return;
        }
        if (hasBackup && !hasCurrent) {
            foh.renameTo(spfOld, spf, true);
            Monitor.getStream().printlnWithHeader(MessageService.getTextMessage("M002", new Object[0]));
        } else if (hasBackup && hasCurrent) {
            BufferedReader bin = null;
            String lastLine = null;
            try {
                String line;
                bin = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(spf.getPath()), "ISO-8859-1"));
                while ((line = bin.readLine()) != null) {
                    if (line.trim().length() == 0) continue;
                    lastLine = line;
                }
            }
            catch (IOException ioe) {
                throw StandardException.newException("XJ113.S", ioe, spf.getPath(), ioe.getMessage());
            }
            finally {
                try {
                    if (bin != null) {
                        bin.close();
                    }
                }
                catch (IOException iOException) {}
            }
            if (lastLine != null && lastLine.startsWith(SERVICE_PROPERTIES_EOF_TOKEN)) {
                String msg = foh.delete(spfOld, false) ? MessageService.getTextMessage("M003", new Object[0]) : MessageService.getTextMessage("M004", StorageFactoryService.getMostAccuratePath(spfOld));
                Monitor.getStream().printlnWithHeader(msg);
            } else {
                foh.delete(spf, false);
                foh.renameTo(spfOld, spf, true);
                Monitor.getStream().printlnWithHeader(MessageService.getTextMessage("M002", new Object[0]));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String recreateServiceRoot(final String serviceName, Properties properties) throws StandardException {
        if (properties == null) {
            return null;
        }
        boolean createRoot = false;
        boolean deleteExistingRoot = false;
        String restoreFrom = properties.getProperty("createFrom");
        if (restoreFrom != null) {
            createRoot = true;
            deleteExistingRoot = false;
        } else {
            restoreFrom = properties.getProperty("restoreFrom");
            if (restoreFrom != null) {
                createRoot = true;
                deleteExistingRoot = true;
            } else {
                restoreFrom = properties.getProperty("rollForwardRecoveryFrom");
                if (restoreFrom != null) {
                    try {
                        if (AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public Object run() throws IOException, StandardException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
                                StorageFactory storageFactory = StorageFactoryService.this.privGetStorageFactoryInstance(true, serviceName, null, null);
                                try {
                                    StorageFile serviceDirectory = storageFactory.newStorageFile(null);
                                    8 var3_3 = serviceDirectory.exists() ? this : null;
                                    return var3_3;
                                }
                                finally {
                                    storageFactory.shutdown();
                                }
                            }
                        }) == null) {
                            createRoot = true;
                            deleteExistingRoot = false;
                        }
                    }
                    catch (PrivilegedActionException pae) {
                        throw Monitor.exceptionStartingModule((IOException)pae.getException());
                    }
                }
            }
        }
        if (restoreFrom == null) return restoreFrom;
        File backupRoot = new File(restoreFrom);
        if (!this.fileExists(backupRoot)) throw StandardException.newException("XBM0Y.D", backupRoot);
        File bserviceProp = new File(restoreFrom, "service.properties");
        if (!this.fileExists(bserviceProp)) throw StandardException.newException("XBM0Q.D", bserviceProp);
        if (createRoot) {
            this.createServiceRoot(serviceName, deleteExistingRoot);
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object run() throws IOException, StandardException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
                    WritableStorageFactory storageFactory = (WritableStorageFactory)StorageFactoryService.this.privGetStorageFactoryInstance(true, serviceName, null, null);
                    try {
                        StorageFile cserviceProp = storageFactory.newStorageFile("service.properties");
                        if (cserviceProp.exists() && !cserviceProp.delete()) {
                            throw StandardException.newException("XBM0R.D", cserviceProp);
                        }
                        Object var3_3 = null;
                        return var3_3;
                    }
                    finally {
                        storageFactory.shutdown();
                    }
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw Monitor.exceptionStartingModule((IOException)pae.getException());
        }
        properties.put("derby.__rt.inRestore", "True");
        if (!createRoot) return restoreFrom;
        properties.put("derby.__rt.deleteRootOnError", "True");
        return restoreFrom;
    }

    @Override
    public String createServiceRoot(final String name, final boolean deleteExisting) throws StandardException {
        Exception t;
        block4: {
            if (!(this.rootStorageFactory instanceof WritableStorageFactory)) {
                throw StandardException.newException("XBM0P.D", new Object[0]);
            }
            t = null;
            try {
                return this.getProtocolLeadIn() + (String)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws StandardException, IOException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
                        StorageFactory storageFactory = StorageFactoryService.this.privGetStorageFactoryInstance(true, name, null, null);
                        try {
                            StorageFile serviceDirectory = storageFactory.newStorageFile(null);
                            if (serviceDirectory.exists()) {
                                if (deleteExisting) {
                                    if (!serviceDirectory.deleteAll()) {
                                        throw StandardException.newException("XBM0I.D", StorageFactoryService.this.getDirectoryPath(name));
                                    }
                                } else {
                                    StorageFactoryService.this.vetService(storageFactory, name);
                                    throw StandardException.newException("XBM0J.D", StorageFactoryService.this.getDirectoryPath(name));
                                }
                            }
                            if (serviceDirectory.mkdirs()) {
                                serviceDirectory.limitAccessToOwner();
                                String serviceDirCanonicalPath = serviceDirectory.getCanonicalPath();
                                storageFactory.setCanonicalName(serviceDirCanonicalPath);
                                try {
                                    String string = storageFactory.getCanonicalName();
                                    return string;
                                }
                                catch (IOException ioe) {
                                    serviceDirectory.deleteAll();
                                    throw ioe;
                                }
                            }
                            throw StandardException.newException("XBM0H.D", serviceDirectory);
                        }
                        finally {
                            storageFactory.shutdown();
                        }
                    }
                });
            }
            catch (SecurityException se) {
                t = se;
            }
            catch (PrivilegedActionException pae) {
                t = pae.getException();
                if (!(t instanceof StandardException)) break block4;
                throw (StandardException)t;
            }
        }
        throw StandardException.newException("XBM0H.D", t, name);
    }

    private void vetService(StorageFactory storageFactory, String serviceName) throws StandardException {
        StorageFile seg0;
        StorageFile service_properties = storageFactory.newStorageFile("service.properties");
        if (!service_properties.exists() && (seg0 = storageFactory.newStorageFile("seg0")).exists()) {
            throw StandardException.newException("XBM0A.D", serviceName, "service.properties");
        }
    }

    private String getDirectoryPath(String name) {
        StringBuffer sb = new StringBuffer();
        if (this.home != null) {
            sb.append(this.home);
            sb.append(this.separatorChar);
        }
        if (this.separatorChar != '/') {
            sb.append(name.replace('/', this.separatorChar));
        } else {
            sb.append(name);
        }
        return sb.toString();
    }

    @Override
    public boolean removeServiceRoot(final String serviceName) {
        if (!(this.rootStorageFactory instanceof WritableStorageFactory)) {
            return false;
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object run() throws StandardException, IOException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
                    StorageFactory storageFactory = StorageFactoryService.this.privGetStorageFactoryInstance(true, serviceName, null, null);
                    try {
                        String tmpCanonical = StorageFactoryService.this.getCanonicalServiceName(StorageFactoryService.this.getProtocolLeadIn() + storageFactory.getCanonicalName());
                        SanityManager.ASSERT(tmpCanonical.equals(StorageFactoryService.this.getProtocolLeadIn() + storageFactory.getCanonicalName()));
                        SanityManager.ASSERT(serviceName.equals(tmpCanonical), "serviceName = " + serviceName + " ; protocolLeadIn + storageFactory.getCanoicalName = " + tmpCanonical);
                        StorageFile serviceDirectory = storageFactory.newStorageFile(null);
                        11 var3_3 = serviceDirectory.deleteAll() ? this : null;
                        return var3_3;
                    }
                    finally {
                        storageFactory.shutdown();
                    }
                }
            }) != null;
        }
        catch (PrivilegedActionException pae) {
            return false;
        }
    }

    @Override
    public String getCanonicalServiceName(String name) throws StandardException {
        int colon = name.indexOf(58);
        if (colon < 2 && !this.getType().equals("directory")) {
            return null;
        }
        if (colon > 1) {
            if (!name.startsWith(this.getType() + ":")) {
                return null;
            }
            name = name.substring(colon + 1);
        }
        final String nm = name;
        try {
            return this.getProtocolLeadIn() + AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws StandardException, IOException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
                    StorageFactory storageFactory = StorageFactoryService.this.privGetStorageFactoryInstance(true, nm, null, null);
                    try {
                        String string = storageFactory.getCanonicalName();
                        return string;
                    }
                    finally {
                        storageFactory.shutdown();
                    }
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw Monitor.exceptionStartingModule(pae.getException());
        }
    }

    @Override
    public String getUserServiceName(String serviceName) {
        if (this.home != null && serviceName.length() > this.canonicalHome.length() + 1 && serviceName.startsWith(this.canonicalHome) && (serviceName = serviceName.substring(this.canonicalHome.length())).charAt(0) == this.separatorChar) {
            serviceName = serviceName.substring(1);
        }
        return serviceName.replace(this.separatorChar, '/');
    }

    @Override
    public boolean isSameService(String serviceName1, String serviceName2) {
        try {
            SanityManager.ASSERT(serviceName1.equals(this.getCanonicalServiceName(serviceName1)), serviceName1);
            SanityManager.ASSERT(serviceName2.equals(this.getCanonicalServiceName(serviceName2)), serviceName2);
        }
        catch (StandardException se) {
            return false;
        }
        return serviceName1.equals(serviceName2);
    }

    private final boolean fileExists(final File file) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.exists();
            }
        });
    }

    public Class getStorageFactoryClass() {
        return this.storageFactoryClass;
    }

    private String getProtocolLeadIn() {
        if (this.getType().equals("directory")) {
            return "";
        }
        return this.getType() + ":";
    }

    private static ModuleFactory getMonitor() {
        return AccessController.doPrivileged(new PrivilegedAction<ModuleFactory>(){

            @Override
            public ModuleFactory run() {
                return Monitor.getMonitor();
            }
        });
    }

    private static String getMostAccuratePath(StorageFile file) {
        String path = file.getPath();
        try {
            path = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return path;
    }

    private static class FileOperationHelper {
        private String operation;

        private FileOperationHelper() {
        }

        boolean exists(StorageFile file, boolean mustSucceed) throws StandardException {
            this.operation = "exists";
            boolean ret = false;
            try {
                ret = file.exists();
            }
            catch (SecurityException se) {
                this.handleSecPrivException(file, mustSucceed, se);
            }
            return ret;
        }

        boolean delete(StorageFile file, boolean mustSucceed) throws StandardException {
            this.operation = "delete";
            boolean deleted = false;
            try {
                deleted = file.delete();
            }
            catch (SecurityException se) {
                this.handleSecPrivException(file, mustSucceed, se);
            }
            if (mustSucceed && !deleted) {
                throw StandardException.newException("XBM0R.D", file.getPath());
            }
            return deleted;
        }

        boolean renameTo(StorageFile from, StorageFile to, boolean mustSucceed) throws StandardException {
            this.operation = "renameTo";
            this.delete(to, false);
            boolean renamed = false;
            try {
                renamed = from.renameTo(to);
            }
            catch (SecurityException se) {
                StorageFile file = to;
                try {
                    System.getSecurityManager().checkWrite(from.getPath());
                }
                catch (SecurityException se1) {
                    file = from;
                }
                this.handleSecPrivException(file, mustSucceed, se);
            }
            if (mustSucceed && !renamed) {
                throw StandardException.newException("XBM0S.D", from.getPath(), to.getPath());
            }
            return renamed;
        }

        private void handleSecPrivException(StorageFile file, boolean mustSucceed, SecurityException se) throws StandardException {
            if (mustSucceed) {
                throw StandardException.newException("XBM0C.D", se, this.operation, file.getName(), se.getMessage());
            }
            Monitor.getStream().printlnWithHeader(MessageService.getTextMessage("XBM0C.D", this.operation, StorageFactoryService.getMostAccuratePath(file), se.getMessage()));
        }
    }

    final class DirectoryList
    implements Enumeration,
    PrivilegedAction<DirectoryList> {
        private String[] contents;
        private StorageFile systemDirectory;
        private int index;
        private boolean validIndex;
        private int actionCode = 0;
        private static final int INIT_ACTION = 0;
        private static final int HAS_MORE_ELEMENTS_ACTION = 1;

        DirectoryList() {
            AccessController.doPrivileged(this);
        }

        @Override
        public boolean hasMoreElements() {
            if (this.contents == null) {
                return false;
            }
            if (this.validIndex) {
                return true;
            }
            this.actionCode = 1;
            return AccessController.doPrivileged(this) != null;
        }

        public Object nextElement() throws NoSuchElementException {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException();
            }
            this.validIndex = false;
            return this.contents[this.index++];
        }

        @Override
        public final DirectoryList run() {
            switch (this.actionCode) {
                case 0: {
                    this.systemDirectory = StorageFactoryService.this.rootStorageFactory.newStorageFile(null);
                    this.contents = this.systemDirectory.list();
                    return null;
                }
                case 1: {
                    while (this.index < this.contents.length) {
                        try {
                            StorageFile properties;
                            String dirname = this.contents[this.index];
                            StorageFile dir = StorageFactoryService.this.rootStorageFactory.newStorageFile(dirname);
                            if (dir.isDirectory() && (properties = StorageFactoryService.this.rootStorageFactory.newStorageFile(dir, "service.properties")).exists()) {
                                this.contents[this.index] = dir.getCanonicalPath();
                                this.validIndex = true;
                                return this;
                            }
                        }
                        catch (Exception se) {
                            // empty catch block
                        }
                        this.contents[this.index++] = null;
                    }
                    return null;
                }
            }
            return null;
        }
    }
}

