/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.util;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.SQLException;
import org.apache.derby.iapi.services.context.Context;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.shared.common.error.StandardException;

public class T_ConsistencyChecker {
    private DataDictionary dd;
    private TransactionController tc;
    private LanguageConnectionContext lcc;
    private String indexName;
    private String schemaName;
    private String tableName;
    private ConglomerateDescriptor id;
    private SchemaDescriptor sd;
    private TableDescriptor td;

    T_ConsistencyChecker(String schemaName, String tableName, String indexName) throws StandardException {
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.indexName = indexName;
    }

    public static void deleteFirstHeapRow(String schemaName, String tableName) throws StandardException {
        T_ConsistencyChecker t_cc = new T_ConsistencyChecker(schemaName, tableName, null);
        t_cc.getContexts();
        t_cc.getDescriptors();
        ScanController heapScan = t_cc.openUnqualifiedHeapScan();
        heapScan.next();
        heapScan.delete();
        heapScan.close();
    }

    public static void reinsertFirstHeapRow(String schemaName, String tableName) throws StandardException {
        T_ConsistencyChecker t_cc = new T_ConsistencyChecker(schemaName, tableName, null);
        t_cc.getContexts();
        t_cc.getDescriptors();
        ScanController heapScan = t_cc.openUnqualifiedHeapScan();
        heapScan.next();
        ExecRow firstRow = t_cc.getHeapRowOfNulls();
        heapScan.fetch(firstRow.getRowArray());
        heapScan.close();
        ConglomerateController heapCC = t_cc.openHeapCC();
        heapCC.insert(firstRow.getRowArray());
        heapCC.close();
    }

    public static void nullFirstHeapRow(String schemaName, String tableName) throws StandardException {
        T_ConsistencyChecker t_cc = new T_ConsistencyChecker(schemaName, tableName, null);
        t_cc.getContexts();
        t_cc.getDescriptors();
        ScanController heapScan = t_cc.openUnqualifiedHeapScan();
        heapScan.next();
        RowLocation baseRL = heapScan.newRowLocationTemplate();
        heapScan.fetchLocation(baseRL);
        heapScan.replace(t_cc.getHeapRowOfNulls().getRowArray(), (FormatableBitSet)null);
        heapScan.close();
    }

    public static void insertBadRowLocation(String schemaName, String tableName, String indexName) throws StandardException {
        T_ConsistencyChecker t_cc = new T_ConsistencyChecker(schemaName, tableName, indexName);
        t_cc.getContexts();
        t_cc.getDescriptors();
        ScanController heapScan = t_cc.openUnqualifiedHeapScan();
        RowLocation baseRL = heapScan.newRowLocationTemplate();
        RowLocation badRL = heapScan.newRowLocationTemplate();
        heapScan.close();
        ExecRow indexRow = t_cc.getIndexTemplateRow(baseRL);
        ScanController indexScan = t_cc.openUnqualifiedIndexScan();
        indexScan.next();
        indexScan.fetch(indexRow.getRowArray());
        indexScan.close();
        int keyLength = t_cc.getIndexDescriptor().getIndexDescriptor().baseColumnPositions().length;
        indexRow.setColumn(keyLength + 1, (DataValueDescriptor)badRL);
        ConglomerateController indexCC = t_cc.openIndexCC();
        indexCC.insert(indexRow.getRowArray());
        indexCC.close();
    }

    public static void swapColumnsInFirstHeapRow(String schemaName, String tableName, int firstColumn, int secondColumn) throws StandardException {
    }

    private void getContexts() throws StandardException {
        this.lcc = (LanguageConnectionContext)T_ConsistencyChecker.getContext("LanguageConnectionContext");
        this.tc = this.lcc.getTransactionExecute();
        this.dd = this.lcc.getDataDictionary();
    }

    private void getDescriptors() throws StandardException {
        this.sd = this.dd.getSchemaDescriptor(this.schemaName, this.tc, true);
        this.td = this.dd.getTableDescriptor(this.tableName, this.sd, this.tc);
        if (this.td == null) {
            throw StandardException.newException((String)"42X05", (Object[])new Object[]{this.schemaName + "." + this.tableName});
        }
        if (this.indexName != null) {
            this.id = this.dd.getConglomerateDescriptor(this.indexName, this.sd, true);
            if (this.id == null) {
                throw StandardException.newException((String)"42X65", (Object[])new Object[]{this.indexName});
            }
        }
    }

    private ExecRow getHeapRowOfNulls() throws StandardException {
        ConglomerateController baseCC = this.tc.openConglomerate(this.td.getHeapConglomerateId(), false, 0, 7, 5);
        ExecRow baseRow = this.lcc.getLanguageConnectionFactory().getExecutionFactory().getValueRow(this.td.getNumberOfColumns());
        ColumnDescriptorList cdl = this.td.getColumnDescriptorList();
        int cdlSize = cdl.size();
        for (int index = 0; index < cdlSize; ++index) {
            ColumnDescriptor cd = cdl.elementAt(index);
            DataTypeDescriptor dts = cd.getType();
            baseRow.setColumn(cd.getPosition(), dts.getNull());
        }
        baseCC.close();
        return baseRow;
    }

    private ScanController openUnqualifiedHeapScan() throws StandardException {
        ScanController heapScan = this.tc.openScan(this.td.getHeapConglomerateId(), false, 4, 7, 5, (FormatableBitSet)null, null, 0, null, null, 0);
        return heapScan;
    }

    private ConglomerateController openHeapCC() throws StandardException {
        ConglomerateController heapCC = this.tc.openConglomerate(this.td.getHeapConglomerateId(), false, 4, 7, 5);
        return heapCC;
    }

    private ExecRow getIndexTemplateRow(RowLocation baseRL) throws StandardException {
        int baseColumns = 0;
        int[] baseColumnPositions = this.id.getIndexDescriptor().baseColumnPositions();
        baseColumns = baseColumnPositions.length;
        FormatableBitSet indexColsBitSet = new FormatableBitSet();
        for (int i = 0; i < baseColumns; ++i) {
            indexColsBitSet.grow(baseColumnPositions[i]);
            indexColsBitSet.set(baseColumnPositions[i] - 1);
        }
        ExecRow indexScanTemplate = this.lcc.getLanguageConnectionFactory().getExecutionFactory().getValueRow(baseColumns + 1);
        for (int column = 0; column < baseColumns; ++column) {
            ColumnDescriptor cd = this.td.getColumnDescriptor(baseColumnPositions[column]);
            DataTypeDescriptor dts = cd.getType();
            indexScanTemplate.setColumn(column + 1, dts.getNull());
        }
        indexScanTemplate.setColumn(baseColumns + 1, (DataValueDescriptor)baseRL);
        return indexScanTemplate;
    }

    private ScanController openUnqualifiedIndexScan() throws StandardException {
        ScanController indexScan = this.tc.openScan(this.id.getConglomerateNumber(), false, 4, 7, 5, (FormatableBitSet)null, null, 0, null, null, 0);
        return indexScan;
    }

    private ConglomerateController openIndexCC() throws StandardException {
        ConglomerateController indexCC = this.tc.openConglomerate(this.id.getConglomerateNumber(), false, 4, 7, 5);
        return indexCC;
    }

    private ConglomerateDescriptor getIndexDescriptor() {
        return this.id;
    }

    public static String runConsistencyChecker() throws StandardException, SQLException {
        return T_ConsistencyChecker.countOpens() + T_ConsistencyChecker.countDependencies();
    }

    public static String countOpens() throws StandardException {
        int numOpens = 0;
        Object output = "No open scans, etc.\n";
        LanguageConnectionContext lcc = (LanguageConnectionContext)T_ConsistencyChecker.getContext("LanguageConnectionContext");
        TransactionController tc = lcc.getTransactionExecute();
        numOpens = tc.countOpens(5);
        if (numOpens > 0) {
            output = numOpens + " conglomerates/scans/sorts found open\n";
        }
        return output;
    }

    public static String countDependencies() throws StandardException, SQLException {
        int numDependencies = 0;
        StringBuffer debugBuf = new StringBuffer();
        LanguageConnectionContext lcc = (LanguageConnectionContext)T_ConsistencyChecker.getContext("LanguageConnectionContext");
        DataDictionary dd = lcc.getDataDictionary();
        DependencyManager dm = dd.getDependencyManager();
        numDependencies = dm.countDependencies();
        if (numDependencies > 0) {
            debugBuf.append(numDependencies + " dependencies found");
        } else {
            debugBuf.append("No outstanding dependencies.\n");
        }
        return debugBuf.toString();
    }

    private static Context getContext(final String contextID) {
        if (System.getSecurityManager() == null) {
            return ContextService.getContext((String)contextID);
        }
        return AccessController.doPrivileged(new PrivilegedAction<Context>(){

            @Override
            public Context run() {
                return ContextService.getContext((String)contextID);
            }
        });
    }
}

