/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.Wrapper41Statement;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class StatementJdbc20Test
extends BaseJDBCTestCase {
    private static final String METHOD_NOT_ALLOWED = "XJ016";
    private static final String CLOSED_STATEMENT = "XJ012";

    public StatementJdbc20Test(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("StatementJdbc20Test");
        baseTestSuite.addTest(StatementJdbc20Test.baseSuite("StatementJdbc20Test:embedded"));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(StatementJdbc20Test.baseSuite("StatementJdbc20Test:client")));
        return baseTestSuite;
    }

    private static Test baseSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite(string);
        baseTestSuite.addTestSuite(StatementJdbc20Test.class);
        return new CleanDatabaseTestSetup((Test)baseTestSuite){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                Connection connection = this.getConnection();
                statement.execute("create table tab1 (i int, s smallint, r real)");
                statement.executeUpdate("insert into tab1 values(1, 2, 3.1)");
                statement.execute("create procedure dynamic_results() language java parameter style java external name '" + StatementJdbc20Test.class.getName() + ".dynamicResults' dynamic result sets 2");
                statement.execute("create table t_autogen( a int generated always as identity, b int )");
            }
        };
    }

    public void testWrongVaues() throws SQLException {
        Statement statement = this.createStatement();
        statement.setFetchSize(25);
        statement.setFetchDirection(1001);
        statement.setEscapeProcessing(true);
        try {
            statement.setFetchSize(-1000);
            StatementJdbc20Test.fail((String)"setFetchSize(-1000) expected to fail");
        }
        catch (SQLException sQLException) {
            StatementJdbc20Test.assertSQLState("XJ065", sQLException);
        }
        try {
            statement.setFetchDirection(-1000);
            StatementJdbc20Test.fail((String)"setFetchDirection(-1000) expected to fail");
        }
        catch (SQLException sQLException) {
            StatementJdbc20Test.assertSQLState("XJ064", sQLException);
        }
        StatementJdbc20Test.assertEquals((int)statement.getFetchSize(), (int)25);
        StatementJdbc20Test.assertEquals((int)statement.getFetchDirection(), (int)1001);
        statement.close();
    }

    public void testReadingData() throws SQLException {
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select * from tab1");
        while (resultSet.next()) {
            StatementJdbc20Test.assertEquals((int)resultSet.getInt(1), (int)1);
            StatementJdbc20Test.assertEquals((int)resultSet.getShort(2), (int)2);
            StatementJdbc20Test.assertEquals((double)resultSet.getDouble(3), (double)3.1, (double)0.01);
        }
        resultSet.close();
        statement.close();
    }

    public void testLocalValuesOfResultSet() throws SQLException {
        Statement statement = this.createStatement();
        statement.setFetchSize(25);
        statement.setFetchDirection(1001);
        statement.setEscapeProcessing(true);
        ResultSet resultSet = statement.executeQuery("select * from tab1");
        StatementJdbc20Test.assertEquals((int)resultSet.getFetchSize(), (int)25);
        StatementJdbc20Test.assertEquals((int)resultSet.getFetchDirection(), (int)1001);
        resultSet.setFetchSize(250);
        try {
            resultSet.setFetchDirection(1000);
        }
        catch (SQLException sQLException) {
            if (StatementJdbc20Test.usingEmbedded()) {
                StatementJdbc20Test.assertSQLState("XJ061", sQLException);
            }
            StatementJdbc20Test.assertSQLState("XJ125", sQLException);
        }
        StatementJdbc20Test.assertEquals((int)resultSet.getFetchSize(), (int)250);
        StatementJdbc20Test.assertEquals((int)resultSet.getFetchDirection(), (int)1001);
        statement.setMaxRows(10);
        resultSet.setFetchSize(100);
        try {
            resultSet.setFetchSize(-2000);
            StatementJdbc20Test.fail((String)"setFetchSize(-2000) expected to fail");
        }
        catch (SQLException sQLException) {
            StatementJdbc20Test.assertSQLState("XJ062", sQLException);
        }
        try {
            resultSet.setFetchDirection(-2000);
        }
        catch (SQLException sQLException) {
            if (StatementJdbc20Test.usingEmbedded()) {
                StatementJdbc20Test.assertSQLState("XJ061", sQLException);
            }
            StatementJdbc20Test.assertSQLState("XJ125", sQLException);
        }
        resultSet.setFetchSize(0);
        statement.setFetchSize(0);
        resultSet.close();
    }

    public void testCreateTableWithExecuteQuery() throws SQLException {
        Statement statement = this.createStatement();
        try {
            statement.executeQuery("create table trash(c1 int)");
        }
        catch (SQLException sQLException) {
            if (StatementJdbc20Test.usingEmbedded()) {
                StatementJdbc20Test.assertSQLState("X0Y78", sQLException);
            }
            StatementJdbc20Test.assertSQLState("XJ207", sQLException);
        }
        try {
            ResultSet resultSet = statement.executeQuery("select * from trash");
            System.out.println("select from trash expected to fail");
        }
        catch (SQLException sQLException) {
            StatementJdbc20Test.assertSQLState("42X05", sQLException);
        }
        try {
            statement.executeUpdate("values 1");
        }
        catch (SQLException sQLException) {
            StatementJdbc20Test.assertSQLState("X0Y79", sQLException);
        }
        statement.close();
        this.commit();
    }

    public void testAddBatchClarification_jdbc4_1() throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("select * from sys.systables");
        CallableStatement callableStatement = this.prepareCall("CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        try {
            preparedStatement.addBatch("select * from sys.systables");
            StatementJdbc20Test.fail((String)"Oops. ps.addBatch() worked.");
        }
        catch (SQLException sQLException) {
            StatementJdbc20Test.assertSQLState(METHOD_NOT_ALLOWED, sQLException);
        }
        try {
            callableStatement.addBatch("CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
            StatementJdbc20Test.fail((String)"Oops. cs.addBatch() worked.");
        }
        catch (SQLException sQLException) {
            StatementJdbc20Test.assertSQLState(METHOD_NOT_ALLOWED, sQLException);
        }
    }

    public void testCompletionClosure_jdbc4_1() throws Exception {
        if (JDBC.vmSupportsJSR169()) {
            return;
        }
        this.vetClosure(false, false);
        this.vetClosure(false, true);
        this.vetClosure(true, false);
        this.vetClosure(true, true);
    }

    private void vetClosure(boolean bl, boolean bl2) throws Exception {
        this.vetClosedSelect(bl, bl2);
        this.vetClosedCall(bl, bl2);
        this.vetClosedPS(bl, bl2);
        this.vetClosedAutoGen(bl, bl2);
    }

    private void vetClosedSelect(boolean bl, boolean bl2) throws Exception {
        Statement statement = this.createStatement();
        StatementJdbc20Test.println("Verifying SELECT wrapper on " + statement.getClass().getName() + " with closeOnCompletion = " + bl + " and delayClosureCall = " + bl2);
        Wrapper41Statement wrapper41Statement = new Wrapper41Statement(statement);
        if (!bl2) {
            this.setCloseOnCompletion(wrapper41Statement, bl);
        }
        ResultSet resultSet = statement.executeQuery("select * from tab1");
        if (bl2) {
            this.setCloseOnCompletion(wrapper41Statement, bl);
        }
        resultSet.close();
        StatementJdbc20Test.assertEquals((boolean)bl, (boolean)wrapper41Statement.isClosed());
        this.vetSuccessfulClosure(wrapper41Statement, bl);
    }

    private void vetClosedCall(boolean bl, boolean bl2) throws Exception {
        Statement statement = this.createStatement();
        StatementJdbc20Test.println("Verifying CALL wrapper on " + statement.getClass().getName() + " with closeOnCompletion = " + bl + " and delayClosureCall = " + bl2);
        Wrapper41Statement wrapper41Statement = new Wrapper41Statement(statement);
        if (!bl2) {
            this.setCloseOnCompletion(wrapper41Statement, bl);
        }
        StatementJdbc20Test.assertTrue((boolean)statement.execute("call dynamic_results()"));
        StatementJdbc20Test.assertFalse((boolean)wrapper41Statement.isClosed());
        ResultSet resultSet = statement.getResultSet();
        if (bl2) {
            this.setCloseOnCompletion(wrapper41Statement, bl);
        }
        StatementJdbc20Test.assertTrue((boolean)statement.getMoreResults());
        StatementJdbc20Test.assertFalse((boolean)wrapper41Statement.isClosed());
        ResultSet resultSet2 = statement.getResultSet();
        resultSet2.close();
        StatementJdbc20Test.assertEquals((boolean)bl, (boolean)wrapper41Statement.isClosed());
        this.vetSuccessfulClosure(wrapper41Statement, bl);
    }

    private void vetClosedPS(boolean bl, boolean bl2) throws Exception {
        PreparedStatement preparedStatement = this.getConnection().prepareStatement("select * from tab1");
        StatementJdbc20Test.println("Verifying PreparedStatement wrapper on " + preparedStatement.getClass().getName() + " with closeOnCompletion = " + bl + " and delayClosureCall = " + bl2);
        Wrapper41Statement wrapper41Statement = new Wrapper41Statement(preparedStatement);
        if (!bl2) {
            this.setCloseOnCompletion(wrapper41Statement, bl);
        }
        ResultSet resultSet = preparedStatement.executeQuery();
        if (bl2) {
            this.setCloseOnCompletion(wrapper41Statement, bl);
        }
        resultSet.close();
        StatementJdbc20Test.assertEquals((boolean)bl, (boolean)wrapper41Statement.isClosed());
        this.vetSuccessfulClosure(wrapper41Statement, bl);
        if (!wrapper41Statement.isClosed()) {
            preparedStatement.close();
        }
    }

    private void vetClosedAutoGen(boolean bl, boolean bl2) throws Exception {
        Statement statement = this.createStatement();
        StatementJdbc20Test.println("Verifying AUTOGENERATED KEYS wrapper on " + statement.getClass().getName() + " with closeOnCompletion = " + bl + " and delayClosureCall = " + bl2);
        Wrapper41Statement wrapper41Statement = new Wrapper41Statement(statement);
        if (!bl2) {
            this.setCloseOnCompletion(wrapper41Statement, bl);
        }
        statement.executeUpdate("insert into t_autogen( b ) values ( 1 )", 1);
        ResultSet resultSet = statement.getGeneratedKeys();
        if (bl2) {
            this.setCloseOnCompletion(wrapper41Statement, bl);
        }
        StatementJdbc20Test.assertFalse((boolean)wrapper41Statement.isClosed());
        resultSet.close();
        StatementJdbc20Test.assertEquals((boolean)bl, (boolean)wrapper41Statement.isClosed());
        this.vetSuccessfulClosure(wrapper41Statement, bl);
    }

    private void setCloseOnCompletion(Wrapper41Statement wrapper41Statement, boolean bl) throws Exception {
        StatementJdbc20Test.assertFalse((boolean)wrapper41Statement.isCloseOnCompletion());
        if (bl) {
            wrapper41Statement.closeOnCompletion();
        }
        StatementJdbc20Test.assertEquals((boolean)bl, (boolean)wrapper41Statement.isCloseOnCompletion());
    }

    private void vetSuccessfulClosure(Wrapper41Statement wrapper41Statement, boolean bl) throws Exception {
        if (bl) {
            try {
                wrapper41Statement.closeOnCompletion();
                StatementJdbc20Test.fail((String)"Expected closed statement failure.");
            }
            catch (SQLException sQLException) {
                StatementJdbc20Test.assertSQLState(CLOSED_STATEMENT, sQLException);
            }
            try {
                wrapper41Statement.isCloseOnCompletion();
                StatementJdbc20Test.fail((String)"Expected closed statement failure.");
            }
            catch (SQLException sQLException) {
                StatementJdbc20Test.assertSQLState(CLOSED_STATEMENT, sQLException);
            }
        }
    }

    public void test_clarification_jdbc4_1() throws Exception {
        Connection connection = this.getConnection();
        PreparedStatement preparedStatement = connection.prepareStatement("select * from sys.syscolumns");
        CallableStatement callableStatement = connection.prepareCall("call dynamic_results()");
        this.vetNotAllowed(preparedStatement);
        this.vetNotAllowed(callableStatement);
        preparedStatement.close();
        callableStatement.close();
    }

    private void vetNotAllowed(Statement statement) throws Exception {
        StatementJdbc20Test.println("Vetting a " + statement.getClass().getName());
        try {
            statement.execute("select * from sys.systables");
            this.failVNA();
        }
        catch (SQLException sQLException) {
            StatementJdbc20Test.assertSQLState(METHOD_NOT_ALLOWED, sQLException);
        }
        try {
            statement.execute("select * from sys.systables", 2);
            this.failVNA();
        }
        catch (SQLException sQLException) {
            StatementJdbc20Test.assertSQLState(METHOD_NOT_ALLOWED, sQLException);
        }
        try {
            statement.execute("select * from sys.systables", new int[]{1});
            this.failVNA();
        }
        catch (SQLException sQLException) {
            StatementJdbc20Test.assertSQLState(METHOD_NOT_ALLOWED, sQLException);
        }
        try {
            statement.execute("select * from sys.systables", new String[]{"COLUMNNAME"});
            this.failVNA();
        }
        catch (SQLException sQLException) {
            StatementJdbc20Test.assertSQLState(METHOD_NOT_ALLOWED, sQLException);
        }
        try {
            statement.executeQuery("select * from sys.systables");
            this.failVNA();
        }
        catch (SQLException sQLException) {
            StatementJdbc20Test.assertSQLState(METHOD_NOT_ALLOWED, sQLException);
        }
        try {
            statement.executeUpdate("insert into tab1 values(1, 2, 3.1)");
            this.failVNA();
        }
        catch (SQLException sQLException) {
            StatementJdbc20Test.assertSQLState(METHOD_NOT_ALLOWED, sQLException);
        }
        try {
            statement.executeUpdate("insert into tab1 values(1, 2, 3.1)", 2);
            this.failVNA();
        }
        catch (SQLException sQLException) {
            StatementJdbc20Test.assertSQLState(METHOD_NOT_ALLOWED, sQLException);
        }
        try {
            statement.executeUpdate("insert into tab1 values(1, 2, 3.1)", new int[]{1});
            this.failVNA();
        }
        catch (SQLException sQLException) {
            StatementJdbc20Test.assertSQLState(METHOD_NOT_ALLOWED, sQLException);
        }
        try {
            statement.executeUpdate("insert into tab1 values(1, 2, 3.1)", new String[]{"COLUMNNAME"});
            this.failVNA();
        }
        catch (SQLException sQLException) {
            StatementJdbc20Test.assertSQLState(METHOD_NOT_ALLOWED, sQLException);
        }
    }

    private void failVNA() throws Exception {
        StatementJdbc20Test.fail((String)"Should have failed when run on a PreparedStatement or CallableStatement");
    }

    public static void dynamicResults(ResultSet[] resultSetArray, ResultSet[] resultSetArray2) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        resultSetArray[0] = connection.createStatement().executeQuery("VALUES(1)");
        resultSetArray2[0] = connection.createStatement().executeQuery("VALUES(2)");
    }
}

