/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class InPredicateTest
extends BaseJDBCTestCase {
    public InPredicateTest(String string) {
        super(string);
    }

    public static Test suite() {
        return new CleanDatabaseTestSetup(TestConfiguration.embeddedSuite(InPredicateTest.class));
    }

    public void testDuplicateConstantsMixedTypes() throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.executeUpdate("create table t1(b bigint)");
        String[][] stringArray = new String[][]{{Long.toString(0x7FFFFFFFFFFFFFFDL)}, {Long.toString(0x7FFFFFFFFFFFFFFEL)}, {Long.toString(Long.MAX_VALUE)}};
        PreparedStatement preparedStatement = this.prepareStatement("insert into t1 values ?");
        for (int i = 0; i < stringArray.length; ++i) {
            preparedStatement.setString(1, stringArray[i][0]);
            preparedStatement.executeUpdate();
        }
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from t1 where b in (9223372036854775805, 9223372036854775806, 9223372036854775807, 9.223372036854776E18)"), stringArray);
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from t1 where b in (values 9223372036854775805, 9223372036854775806, 9223372036854775807, 9.223372036854776E18)"), stringArray);
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from t1 where b = any (values 9223372036854775805, 9223372036854775806, 9223372036854775807, 9.223372036854776E18)"), stringArray);
    }

    public void testMixedTypes() throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.executeUpdate("create table t2(b1 bigint, b2 bigint, d double)");
        statement.executeUpdate("insert into t2 values (9223372036854775805, 9223372036854775806, 1)");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select true from t2 where b1 in (b2, d)"), "true");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select true from t2 where b1 in (values b2, d)"), "true");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select true from t2 where b1 = any (values b2, d)"), "true");
        statement.executeUpdate("create table t3 (i1 int, r1 real, r2 real)");
        statement.executeUpdate("insert into t3 values (2147483645, 2147483645, 2147483645), (2147483645, 2147483645, 0)");
        Object[][] objectArray = new Object[][]{{0x7FFFFFFD, Float.valueOf(2.1474836E9f), Float.valueOf(2.1474836E9f)}};
        JDBC.assertFullResultSet(statement.executeQuery("select * from t3 where r1 in (i1, r2)"), objectArray, false);
        JDBC.assertFullResultSet(statement.executeQuery("select * from t3 where r1 in (values i1, r2)"), objectArray, false);
        JDBC.assertFullResultSet(statement.executeQuery("select * from t3 where r1 = any (values i1, r2)"), objectArray, false);
    }
}

