/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.GroupByColumn;
import org.apache.derby.impl.sql.compile.JavaToSQLValueNode;
import org.apache.derby.impl.sql.compile.OrderedColumnList;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

class GroupByList
extends OrderedColumnList<GroupByColumn> {
    int numGroupingColsAdded = 0;
    boolean rollup = false;

    public GroupByList(ContextManager cm) {
        super(GroupByColumn.class, cm);
    }

    void addGroupByColumn(GroupByColumn column) {
        this.addElement(column);
    }

    GroupByColumn getGroupByColumn(int position) {
        SanityManager.ASSERT(position >= 0 && position < this.size(), "position (" + position + ") expected to be between 0 and " + this.size());
        return (GroupByColumn)this.elementAt(position);
    }

    void setRollup() {
        this.rollup = true;
    }

    boolean isRollup() {
        return this.rollup;
    }

    int getNumNeedToAddGroupingCols() {
        return this.numGroupingColsAdded;
    }

    void bindGroupByColumns(SelectNode select, List<AggregateNode> aggregates) throws StandardException {
        FromList fromList = select.getFromList();
        ResultColumnList selectRCL = select.getResultColumns();
        SubqueryList dummySubqueryList = new SubqueryList(this.getContextManager());
        int numColsAddedHere = 0;
        if (this.size() > 32677) {
            throw StandardException.newException("54004", new Object[0]);
        }
        for (GroupByColumn groupByCol : this) {
            groupByCol.bindExpression(fromList, dummySubqueryList, aggregates);
        }
        int rclSize = selectRCL.size();
        for (GroupByColumn groupingCol : this) {
            boolean matchFound = false;
            for (int inner = 0; inner < rclSize; ++inner) {
                ColumnReference selectListCR;
                ResultColumn selectListRC = (ResultColumn)selectRCL.elementAt(inner);
                if (!(selectListRC.getExpression() instanceof ColumnReference) || !(selectListCR = (ColumnReference)selectListRC.getExpression()).isEquivalent(groupingCol.getColumnExpression())) continue;
                groupingCol.setColumnPosition(inner + 1);
                selectListRC.markAsGroupingColumn();
                matchFound = true;
                break;
            }
            if (!matchFound && !select.hasDistinct() && groupingCol.getColumnExpression() instanceof ColumnReference) {
                ResultColumn newRC = new ResultColumn(groupingCol.getColumnName(), groupingCol.getColumnExpression().getClone(), this.getContextManager());
                newRC.setVirtualColumnId(selectRCL.size() + 1);
                newRC.markGenerated();
                newRC.markAsGroupingColumn();
                selectRCL.addElement(newRC);
                groupingCol.setColumnPosition(selectRCL.size());
                selectRCL.setCountMismatchAllowed(true);
                ++numColsAddedHere;
            }
            if (!(groupingCol.getColumnExpression() instanceof JavaToSQLValueNode)) continue;
            throw StandardException.newException("42Y30", new Object[0]);
        }
        if (dummySubqueryList.size() != 0) {
            throw StandardException.newException("42Y26.S.1", new Object[0]);
        }
        this.numGroupingColsAdded += numColsAddedHere;
    }

    GroupByColumn findGroupingColumn(ValueNode node) throws StandardException {
        for (GroupByColumn gbc : this) {
            if (!gbc.getColumnExpression().isEquivalent(node)) continue;
            return gbc;
        }
        return null;
    }

    void remapColumnReferencesToExpressions() throws StandardException {
        for (GroupByColumn gbc : this) {
            gbc.setColumnExpression(gbc.getColumnExpression().remapColumnReferencesToExpressions());
        }
    }

    @Override
    public String toString() {
        return "numGroupingColsAdded: " + this.numGroupingColsAdded + "\n" + super.toString();
    }

    void preprocess(int numTables, FromList fromList, SubqueryList whereSubquerys, PredicateList wherePredicates) throws StandardException {
        for (GroupByColumn gbc : this) {
            gbc.setColumnExpression(gbc.getColumnExpression().preprocess(numTables, fromList, whereSubquerys, wherePredicates));
        }
    }
}

