/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.upgradeTests;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.sql.DataSource;
import junit.framework.Test;
import org.apache.derby.shared.common.info.JVMInfo;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.UpgradeChange;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.helpers.DisposableIndexStatistics;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.IndexStatsUtil;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class Changes10_9
extends UpgradeChange {
    private static final String UPGRADE_REQUIRED = "XCL47";
    private static final String INVALID_PROVIDER_CHANGE = "XCY05";
    private static final String[] SUPPORT_FILES_SOURCE = new String[]{"functionTests/tests/lang/dcl_java.jar", "functionTests/tests/lang/dcl_emc1.jar", "functionTests/tests/lang/dcl_emc2.jar"};
    private static final String[][] USERS = new String[][]{{"dbo", "the boss", null, "3b6071d99b1d48ab732e75a8de701b6c77632db65898", "3b6071d99b1d48ab732e75a8de701b6c77632db65898", "3b6071d99b1d48ab732e75a8de701b6c77632db65898"}, {"pat", "postman", "MD5", "3b609129e181a7f7527697235c8aead65c461a0257f3", "3b61aaca567ed43d1ba2e6402cbf1a723407:MD5", "3b624f4b0d7f3d2330c1db98a2000c62b5cd::1000:MD5"}, {"sam", "fireman", "SHA-1", "3b609e5173cfa03620061518adc92f2a58c7b15cf04f", "3b6197160362c0122fcd7a63a9da58fd0781140901fb:SHA-1", "3b62a2d88ffac5332219116ab53e29dd3b9e1222e990::1000:SHA-1"}};
    private Goal[] pattern;

    public Changes10_9(String name) {
        super(name);
        this.initPattern();
    }

    public static Test suite(int phase) {
        BaseTestSuite suite = new BaseTestSuite("Upgrade test for 10.9");
        suite.addTestSuite(Changes10_9.class);
        return new SupportFilesSetup((Test)suite, SUPPORT_FILES_SOURCE);
    }

    public void testDropStatisticsProc() throws Exception {
        Statement s = this.createStatement();
        switch (this.getPhase()) {
            case 0: {
                s.execute("CREATE TABLE dropStatsT1 (c11 int, c12 int) ");
                this.vetProcs(s, "call syscs_util.syscs_drop_statistics( 'APP', 'DROPSTATST1', null )", false);
                break;
            }
            case 1: {
                this.vetProcs(s, "call syscs_util.syscs_drop_statistics( 'APP', 'DROPSTATST1', null )", false);
                break;
            }
            case 2: {
                this.vetProcs(s, "call syscs_util.syscs_drop_statistics( 'APP', 'DROPSTATST1', null )", false);
                break;
            }
            case 3: {
                this.vetProcs(s, "call syscs_util.syscs_drop_statistics( 'APP', 'DROPSTATST1', null )", true);
                s.execute("DROP TABLE dropStatsT1");
            }
        }
        s.close();
    }

    public void testNativeAuthentication() throws Exception {
        Statement s = this.createStatement();
        switch (this.getPhase()) {
            case 0: {
                this.vetSYSUSERS(s, false);
                this.vetNativeProcs(s, false);
                break;
            }
            case 1: {
                this.vetSYSUSERS(s, false);
                this.vetNativeProcs(s, false);
                break;
            }
            case 2: {
                this.vetSYSUSERS(s, false);
                this.vetNativeProcs(s, false);
                break;
            }
            case 3: {
                this.vetSYSUSERS(s, true);
                this.vetNativeProcs(s, true);
            }
        }
        s.close();
    }

    private void vetProcs(Statement s, String procCall, boolean shouldExist) throws Exception {
        try {
            s.execute(procCall);
            if (!shouldExist) {
                Changes10_9.fail((String)"syscs_util.syscs_create_user should not exist.");
            }
        }
        catch (SQLException se) {
            if (shouldExist) {
                Changes10_9.assertSQLState("4251K", se);
            }
            Changes10_9.assertSQLState("42Y03", se);
        }
    }

    private void vetSYSUSERS(Statement s, boolean shouldExist) throws Exception {
        ResultSet rs = s.executeQuery("select count(*) from sys.systables where tablename = 'SYSUSERS'");
        rs.next();
        int expectedValue = shouldExist ? 1 : 0;
        Changes10_9.assertEquals((int)expectedValue, (int)rs.getInt(1));
        rs.close();
    }

    private void vetNativeProcs(Statement s, boolean shouldExist) throws Exception {
        String defaultDigestAlgorithm = this.pushAuthenticationAlgorithm(s);
        this.vetProcs(s, "call syscs_util.syscs_create_user( 'FRED', 'fredpassword' )", shouldExist);
        this.popAuthenticationAlgorithm(s, defaultDigestAlgorithm);
    }

    private String pushAuthenticationAlgorithm(Statement s) throws Exception {
        String defaultDigestAlgorithm = this.getDatabaseProperty(s, "derby.authentication.builtin.algorithm");
        if (defaultDigestAlgorithm == null) {
            this.setDatabaseProperty(s, "derby.authentication.builtin.algorithm", "SHA-1");
        }
        return defaultDigestAlgorithm;
    }

    private void popAuthenticationAlgorithm(Statement s, String defaultDigestAlgorithm) throws Exception {
        if (defaultDigestAlgorithm == null) {
            this.setDatabaseProperty(s, "derby.authentication.builtin.algorithm", null);
        }
    }

    private void setDatabaseProperty(Statement s, String key, String value) throws Exception {
        value = value == null ? "cast ( null as varchar( 32672 ) )" : "'" + (String)value + "'";
        String command = "call syscs_util.syscs_set_database_property( '" + key + "', " + (String)value + " )";
        s.execute(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDatabaseProperty(Statement s, String key) throws Exception {
        try (ResultSet rs = s.executeQuery("values( syscs_util.syscs_get_database_property( '" + key + "' ) )");){
            rs.next();
            String string = rs.getString(1);
            return string;
        }
    }

    public void testNativeLocalAuthentication() throws Exception {
        Statement s = this.createStatement();
        switch (this.getPhase()) {
            case 0: 
            case 2: {
                this.setDatabaseProperty(s, "derby.authentication.provider", "NATIVE::LOCAL");
                this.setDatabaseProperty(s, "derby.authentication.provider", null);
                break;
            }
            case 1: {
                this.setDatabaseProperty(s, "derby.authentication.provider", "com.acme.AcmeAuthenticator");
                Changes10_9.assertStatementError(UPGRADE_REQUIRED, s, "call syscs_util.syscs_set_database_property( 'derby.authentication.provider', 'NATIVE::LOCAL' )");
                this.setDatabaseProperty(s, "derby.authentication.provider", null);
                break;
            }
        }
        s.close();
    }

    public void testBuiltinAuthenticationWithConfigurableHash() throws SQLException {
        DataSource ds = JDBCDataSource.getDataSourceLogical("BUILTIN_10_9");
        if (this.getPhase() == 0) {
            JDBCDataSource.setBeanProperty(ds, "createDatabase", "create");
        } else if (this.getPhase() == 3) {
            JDBCDataSource.setBeanProperty(ds, "connectionAttributes", "upgrade=true");
        }
        Connection c = ds.getConnection("dbo", "the boss");
        this.verifyCanConnect(ds);
        CallableStatement setProp = c.prepareCall("call syscs_util.syscs_set_database_property(?, ?)");
        if (this.getPhase() == 0) {
            setProp.setString(1, "derby.connection.requireAuthentication");
            setProp.setString(2, "true");
            setProp.execute();
            setProp.setString(1, "derby.authentication.provider");
            setProp.setString(2, "BUILTIN");
            setProp.execute();
            setProp.setString(1, "derby.authentication.builtin.saltLength");
            setProp.setInt(2, 0);
            setProp.execute();
        }
        this.setPasswords(setProp);
        setProp.close();
        this.verifyCanConnect(ds);
        this.verifyPasswords(c);
        c.close();
        JDBCDataSource.setBeanProperty(ds, "user", "dbo");
        JDBCDataSource.setBeanProperty(ds, "password", "the boss");
        JDBCDataSource.shutdownDatabase(ds);
    }

    private void setPasswords(CallableStatement cs) throws SQLException {
        for (int i = 0; i < USERS.length; ++i) {
            cs.setString(1, "derby.authentication.builtin.algorithm");
            cs.setString(2, USERS[i][2]);
            cs.execute();
            cs.setString(1, "derby.user." + USERS[i][0]);
            cs.setString(2, USERS[i][1]);
            cs.execute();
        }
    }

    private void verifyPasswords(Connection c) throws SQLException {
        int pwIdx = this.getPhase() == 3 ? 5 : (this.oldAtLeast(10, 6) ? 4 : 3);
        PreparedStatement ps = c.prepareStatement("values syscs_util.syscs_get_database_property(?)");
        for (int i = 0; i < USERS.length; ++i) {
            String expectedToken = USERS[i][pwIdx];
            ps.setString(1, "derby.user." + USERS[i][0]);
            JDBC.assertSingleValueResultSet(ps.executeQuery(), expectedToken);
        }
        ps.close();
    }

    private void verifyCanConnect(DataSource ds) throws SQLException {
        for (int i = 0; i < USERS.length; ++i) {
            Connection c = ds.getConnection(USERS[i][0], USERS[i][1]);
            c.close();
        }
    }

    public void testJarStorage() throws Exception {
        Statement s = this.createStatement();
        switch (this.getPhase()) {
            case 0: {
                this.createSchema("EMC");
                this.createSchema("FOO");
                s.executeUpdate("create procedure EMC.ADDCONTACT(id INT, e_mail VARCHAR(30)) MODIFIES SQL DATA external name 'org.apache.derbyTesting.databaseclassloader.emc.addContact' language java parameter style java");
                s.executeUpdate("create table EMC.CONTACTS     (id int, e_mail varchar(30))");
                this.installJar("dcl_emc1.jar", "EMC.MAIL_APP");
                this.installJar("dcl_java.jar", "EMC.MY_JAVA");
                this.installJar("dcl_emc2.jar", "FOO.BAR");
                this.setDBClasspath("EMC.MAIL_APP");
                this.tryCall();
                this.setDBClasspath(null);
                break;
            }
            case 1: {
                String backupdir = SupportFilesSetup.getReadWriteFileName("d6505-backup");
                PreparedStatement backupStmt = this.prepareStatement("call syscs_util.syscs_backup_database(?)");
                backupStmt.setString(1, backupdir);
                backupStmt.execute();
            }
            case 2: {
                this.setDBClasspath("EMC.MAIL_APP");
                this.tryCall();
                this.setDBClasspath(null);
                this.replaceJar("dcl_emc1.jar", "EMC.MAIL_APP");
                this.setDBClasspath("EMC.MAIL_APP");
                this.tryCall();
                this.setDBClasspath(null);
                break;
            }
            case 3: {
                this.setDBClasspath("EMC.MAIL_APP");
                this.tryCall();
                this.setDBClasspath(null);
                this.installJar("dcl_emc1.jar", "FOO.\"BAR/..\\../\"");
                this.verifyNewLocations(4);
                this.removeJar("EMC.MAIL_APP");
                this.installJar("dcl_emc1.jar", "EMC.MAIL_APP");
                this.setDBClasspath("EMC.MAIL_APP");
                this.tryCall();
                this.setDBClasspath(null);
                this.replaceJar("dcl_java.jar", "EMC.MY_JAVA");
                this.replaceJar("dcl_emc2.jar", "FOO.BAR");
                this.replaceJar("dcl_emc1.jar", "FOO.\"BAR/..\\../\"");
                this.removeJar("EMC.MY_JAVA");
                this.removeJar("FOO.BAR");
                this.removeJar("FOO.\"BAR/..\\../\"");
                this.removeJar("EMC.MAIL_APP");
                s.executeUpdate("drop table EMC.CONTACTS");
                s.executeUpdate("drop procedure EMC.ADDCONTACT");
                s.executeUpdate("drop schema FOO restrict");
                s.executeUpdate("drop schema EMC restrict");
            }
        }
        s.close();
    }

    private void createSchema(String name) throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("create schema " + name);
        s.close();
    }

    private void installJar(String resource, String jarName) throws SQLException, MalformedURLException {
        URL jar = SupportFilesSetup.getReadOnlyURL(resource);
        CallableStatement cs = this.prepareCall("CALL SQLJ.INSTALL_JAR(?, ?, 0)");
        cs.setString(1, jar.toExternalForm());
        cs.setString(2, jarName);
        cs.executeUpdate();
        cs.close();
    }

    private void replaceJar(String resource, String jarName) throws SQLException, MalformedURLException {
        URL jar = SupportFilesSetup.getReadOnlyURL(resource);
        CallableStatement cs = this.prepareCall("CALL SQLJ.REPLACE_JAR(?, ?)");
        cs.setString(1, jar.toExternalForm());
        cs.setString(2, jarName);
        cs.executeUpdate();
        cs.close();
    }

    private void removeJar(String jarName) throws SQLException {
        CallableStatement cs = this.prepareCall("CALL SQLJ.REMOVE_JAR(?, 0)");
        cs.setString(1, jarName);
        cs.executeUpdate();
        cs.close();
    }

    private void setDBClasspath(String cp) throws SQLException {
        CallableStatement cs = this.prepareCall("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.database.classpath', ?)");
        cs.setString(1, cp);
        cs.executeUpdate();
        cs.close();
    }

    private void tryCall() throws SQLException {
        if (JDBC.vmSupportsJSR169()) {
            return;
        }
        CallableStatement cs = this.prepareCall("CALL EMC.ADDCONTACT(?, ?)");
        cs.setInt(1, 0);
        cs.setString(2, "now@classpathchange.com");
        cs.executeUpdate();
        cs.close();
    }

    private void verifyNewLocations(int noOfObjects) throws SQLException {
        TestConfiguration tc = TestConfiguration.getCurrent();
        String dbPath = tc.getPhysicalDatabaseName(tc.getDefaultDatabaseName());
        String jarDirName = "system" + File.separator + dbPath + File.separator + "jar";
        File jarDir = new File(jarDirName);
        Changes10_9.assertTrue((boolean)jarDir.isDirectory());
        File[] contents = jarDir.listFiles();
        Changes10_9.assertEquals((int)noOfObjects, (int)contents.length);
        for (int i = 0; i < contents.length; ++i) {
            File f = contents[i];
            Changes10_9.assertTrue((boolean)f.isFile());
            this.assertFileNameShape(f.getName());
        }
    }

    private void initPattern() {
        int i;
        ArrayList<Goal> l = new ArrayList<Goal>(100);
        for (i = 0; i < 8; ++i) {
            l.add(new CharRange(new char[][]{{'0', '9'}, {'a', 'f'}}));
        }
        l.add(new SingleChar('-'));
        for (int j = 0; j < 3; ++j) {
            for (int i2 = 0; i2 < 4; ++i2) {
                l.add(new CharRange(new char[][]{{'0', '9'}, {'a', 'f'}}));
            }
            l.add(new SingleChar('-'));
        }
        for (i = 0; i < 12; ++i) {
            l.add(new CharRange(new char[][]{{'0', '9'}, {'a', 'f'}}));
        }
        l.add(new SingleChar('.'));
        l.add(new SingleChar('j'));
        l.add(new SingleChar('a'));
        l.add(new SingleChar('r'));
        l.add(new SingleChar('.'));
        l.add(new SingleChar('G'));
        l.add(new CharRange(new char[][]{{'0', '9'}}, 0));
        this.pattern = l.toArray(new Goal[l.size()]);
    }

    private void assertFileNameShape(String fName) {
        Changes10_9.assertTrue((boolean)this.matches(fName, this.pattern));
    }

    private boolean matches(String fName, Goal[] pattern) {
        int patIdx = 0;
        for (int i = 0; i < fName.length(); ++i) {
            Goal p = pattern[patIdx];
            char c = fName.charAt(i);
            if (p.matches(c)) {
                if (!p.isRepeatable()) {
                    ++patIdx;
                }
                p.setFoundOnce();
                continue;
            }
            ++patIdx;
            if (p.matches(c)) {
                if (!p.isRepeatable()) {
                    ++patIdx;
                }
                p.setFoundOnce();
                continue;
            }
            return false;
        }
        return patIdx >= pattern.length - 1;
    }

    public void test_5493() throws Exception {
        Connection conn = this.getConnection();
        Statement s = this.createStatement();
        switch (this.getPhase()) {
            case 0: {
                Changes10_9.assertNull((Object)this.getNewFunctionID(s));
                break;
            }
            case 1: {
                Changes10_9.assertNull((Object)this.getNewFunctionID(s));
                break;
            }
            case 2: {
                Changes10_9.assertNull((Object)this.getNewFunctionID(s));
                break;
            }
            case 3: {
                Changes10_9.assertNotNull((Object)this.getNewFunctionID(s));
            }
        }
        s.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getNewFunctionID(Statement s) throws Exception {
        try (ResultSet rs = null;){
            rs = s.executeQuery("select aliasid from sys.sysaliases where alias = 'SYSCS_PEEK_AT_SEQUENCE'");
            if (!rs.next()) {
                String string = null;
                return string;
            }
            String string = rs.getString(1);
            return string;
        }
    }

    public void testDropOrphanedStatistics() throws SQLException {
        if (!this.oldAtLeast(10, 5)) {
            return;
        }
        if (JVMInfo.isModuleAware()) {
            return;
        }
        IndexStatsUtil stats = new IndexStatsUtil(this.openDefaultConnection());
        Statement s = this.createStatement();
        int expected = DisposableIndexStatistics.hasDerby5681Bug(this.getOldVersion()) ? 2 : 1;
        switch (this.getPhase()) {
            case 0: {
                s.executeUpdate("CREATE TABLE TEST_TAB_1 (c11 int not null,c12 int not null, c13 int)");
                s.executeUpdate("INSERT INTO TEST_TAB_1 VALUES(1,1,1),(2,2,2)");
                s.executeUpdate("ALTER TABLE TEST_TAB_1 ADD CONSTRAINT TEST_TAB_1_PK_1 PRIMARY KEY (c11)");
                stats.assertTableStats("TEST_TAB_1", 1);
                s.executeUpdate("CREATE TABLE TEST_TAB_2 (c21 int not null)");
                s.executeUpdate("INSERT INTO TEST_TAB_2 VALUES(1),(2)");
                s.executeUpdate("ALTER TABLE TEST_TAB_2 ADD CONSTRAINT TEST_TAB_2_PK_1 PRIMARY KEY (c21)");
                stats.assertTableStats("TEST_TAB_2", 1);
                s.executeUpdate("ALTER TABLE TEST_TAB_2 ADD CONSTRAINT TEST_TAB_2_FK_1 FOREIGN KEY(c21) REFERENCES TEST_TAB_1(c11)");
                stats.assertTableStats("TEST_TAB_2", 1);
                s.execute("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','TEST_TAB_2', null)");
                stats.assertTableStats("TEST_TAB_2", 2);
                s.executeUpdate("ALTER TABLE TEST_TAB_2 DROP CONSTRAINT TEST_TAB_2_FK_1");
                stats.assertTableStats("TEST_TAB_2", expected);
                Changes10_9.assertStatementError("42Y03", s, "CALL SYSCS_UTIL.SYSCS_DROP_STATISTICS('APP','TEST_TAB_2', null)");
                break;
            }
            case 1: 
            case 2: {
                Changes10_9.assertStatementError("42Y03", s, "CALL SYSCS_UTIL.SYSCS_DROP_STATISTICS('APP','TEST_TAB_2', null)");
                break;
            }
            case 3: {
                stats.assertTableStats("TEST_TAB_2", expected);
                s.execute("CALL SYSCS_UTIL.SYSCS_DROP_STATISTICS('APP','TEST_TAB_2', null)");
                stats.assertNoStatsTable("TEST_TAB_2");
                s.execute("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','TEST_TAB_2', null)");
                stats.assertNoStatsTable("TEST_TAB_2");
                break;
            }
            case 4: {
                s.execute("CALL SYSCS_UTIL.SYSCS_DROP_STATISTICS('APP','TEST_TAB_2', null)");
                s.executeUpdate("DROP TABLE TEST_TAB_1");
                s.executeUpdate("DROP TABLE TEST_TAB_2");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDisposableStatisticsExplicit() throws SQLException {
        if (!this.oldAtLeast(10, 5)) {
            return;
        }
        if (JVMInfo.isModuleAware()) {
            return;
        }
        String TBL = "ISTAT_DISPOSABLE_STATS";
        String updateStatsSQL = "call syscs_util.syscs_update_statistics('APP', ?, null)";
        DisposableIndexStatistics dis = new DisposableIndexStatistics(this.getOldVersion(), this.getConnection(), "ISTAT_DISPOSABLE_STATS");
        switch (this.getPhase()) {
            case 0: {
                dis.createAndPopulateTables();
                dis.assertStatsCount(false, false);
                break;
            }
            case 1: {
                PreparedStatement ps = this.prepareStatement(updateStatsSQL);
                String[] tables = dis.getTableNames();
                for (int i = 0; i < tables.length; ++i) {
                    ps.setString(1, tables[i]);
                    ps.executeUpdate();
                }
                dis.assertStatsCount(true, false);
                break;
            }
            case 2: {
                dis.assertStatsCount(true, false);
                break;
            }
            case 3: {
                int i;
                dis.assertStatsCount(true, false);
                PreparedStatement ps = this.prepareStatement(updateStatsSQL);
                String[] tables = dis.getTableNames();
                for (i = 0; i < tables.length; ++i) {
                    ps.setString(1, tables[i]);
                    ps.executeUpdate();
                }
                try {
                    dis.assertStatsCount(true, true);
                }
                finally {
                    for (i = 0; i < tables.length; ++i) {
                        this.dropTable(tables[i]);
                    }
                }
                this.commit();
                break;
            }
        }
    }

    private class CharRange
    extends Goal {
        private char[][] ranges;

        public CharRange(char[][] ranges) {
            this.ranges = (char[][])ranges.clone();
        }

        public CharRange(char[][] ranges, int option) {
            this.ranges = (char[][])ranges.clone();
            this.option = option;
        }

        @Override
        public boolean matches(char c) {
            for (int i = 0; i < this.ranges.length; ++i) {
                if (c < this.ranges[i][0] || c > this.ranges[i][1]) continue;
                return true;
            }
            return false;
        }
    }

    private class SingleChar
    extends Goal {
        private char c;
        private int option;
        private boolean foundOnce;

        public SingleChar(char c) {
            this.option = -1;
            this.foundOnce = false;
            this.c = c;
        }

        public SingleChar(char c, int option) {
            this.option = -1;
            this.foundOnce = false;
            this.c = c;
            this.option = option;
        }

        @Override
        public boolean matches(char c) {
            return c == this.c;
        }
    }

    abstract class Goal {
        public static final int REPEAT = 0;
        int option = -1;
        boolean foundOnce = false;

        Goal() {
        }

        public abstract boolean matches(char var1);

        public boolean isRepeatable() {
            return this.option == 0;
        }

        public void setFoundOnce() {
            this.foundOnce = true;
        }

        public boolean foundOnce() {
            return this.foundOnce;
        }
    }
}

