/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.invoke.CallSite;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.spi.ObjectFactory;
import junit.framework.Assert;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

public class DataSourceReferenceTest
extends BaseJDBCTestCase {
    private static final int BASE_DS = 0;
    private static final int POOL_DS = 1;
    private static final int XA_DS = 2;
    private static final DataSourceDescriptor BASE_EMBEDDED_DS = new DataSourceDescriptor("Basic embedded data source");
    private static final DataSourceDescriptor BASE_CLIENT_DS;
    private static final DataSourceDescriptor POOL_CLIENT_DS;

    public DataSourceReferenceTest(String string) {
        super(string);
    }

    public static Test suite() {
        Object object = JDBC.vmSupportsJSR169() || !JDBC.vmSupportsJNDI() ? new BaseTestSuite("DatasourceReferenceTest cannot run with JSR169") : TestConfiguration.defaultSuite(DataSourceReferenceTest.class);
        return object;
    }

    public void testDataSourceReference() throws Exception {
        DataSourceDescriptor[] dataSourceDescriptorArray = DataSourceReferenceTest.usingDerbyNetClient() ? new DataSourceDescriptor[]{BASE_CLIENT_DS, POOL_CLIENT_DS, BASE_CLIENT_DS} : new DataSourceDescriptor[]{BASE_EMBEDDED_DS, BASE_EMBEDDED_DS, BASE_EMBEDDED_DS};
        String string = JDBCDataSource.getDataSource().getClass().getName();
        DataSourceReferenceTest.println("Testing base data source: " + string);
        this.assertDataSourceReference(dataSourceDescriptorArray[0], string);
        string = J2EEDataSource.getConnectionPoolDataSource().getClass().getName();
        DataSourceReferenceTest.println("Testing connection pool data source: " + string);
        this.assertDataSourceReference(dataSourceDescriptorArray[1], string);
        string = J2EEDataSource.getXADataSource().getClass().getName();
        DataSourceReferenceTest.println("Testing XA data source: " + string);
        this.assertDataSourceReference(dataSourceDescriptorArray[2], string);
    }

    private void assertDataSourceReference(DataSourceDescriptor dataSourceDescriptor, String string) throws Exception {
        Class<?> clazz = Class.forName(string);
        Object obj = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        String[] stringArray = DataSourceReferenceTest.getPropertyBeanList(obj);
        this.assertDataSourceProperties(dataSourceDescriptor, stringArray);
        this.assertDataSourceReferenceEmpty(dataSourceDescriptor, string);
        this.assertDataSourceReferencePopulated(dataSourceDescriptor, string);
    }

    private void assertDataSourceProperties(DataSourceDescriptor dataSourceDescriptor, String[] stringArray) {
        DataSourceReferenceTest.println("Testing data source bean properties.");
        for (int i = 0; i < stringArray.length; ++i) {
            DataSourceReferenceTest.assertTrue((String)("Property '" + stringArray[i] + "' not in descriptor '" + dataSourceDescriptor.getName() + "'"), (boolean)dataSourceDescriptor.hasProperty(stringArray[i]));
        }
        Iterator iterator = dataSourceDescriptor.getPropertyIterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string)) continue;
                if (bl) {
                    DataSourceReferenceTest.fail((String)("Duplicate entry '" + string + "' in data source property list"));
                }
                bl = true;
            }
            DataSourceReferenceTest.assertTrue((String)("Property '" + string + "' not found in data source property list"), (boolean)bl);
        }
        DataSourceReferenceTest.assertEquals((int)dataSourceDescriptor.getPropertyCount(), (int)stringArray.length);
    }

    private void assertDataSourceReferenceEmpty(DataSourceDescriptor dataSourceDescriptor, String string) throws Exception {
        DataSourceReferenceTest.println("Testing recreated empty data source.");
        Class<?> clazz = Class.forName(string);
        Object obj = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        Referenceable referenceable = (Referenceable)obj;
        Reference reference = referenceable.getReference();
        String string2 = reference.getFactoryClassName();
        clazz = Class.forName(string2);
        ObjectFactory objectFactory = (ObjectFactory)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        Object object = objectFactory.getObjectInstance(reference, null, null, null);
        DataSourceReferenceTest.assertNotNull((String)"Recreated datasource is <null>", (Object)object);
        DataSourceReferenceTest.assertNotSame((Object)object, obj);
        this.compareDataSources(dataSourceDescriptor, obj, object, true);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(obj);
        objectOutputStream.flush();
        objectOutputStream.close();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        object = objectInputStream.readObject();
        this.compareDataSources(dataSourceDescriptor, obj, object, true);
    }

    private void assertDataSourceReferencePopulated(DataSourceDescriptor dataSourceDescriptor, String string) throws Exception {
        Class<?> clazz;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        DataSourceReferenceTest.println("Testing recreated populated data source.");
        Class<?> clazz2 = Class.forName(string);
        Object obj = clazz2.getConstructor(new Class[0]).newInstance(new Object[0]);
        Iterator iterator = dataSourceDescriptor.getPropertyIterator();
        while (iterator.hasNext()) {
            object4 = (String)iterator.next();
            object3 = dataSourceDescriptor.getPropertyValue((String)object4);
            object2 = DataSourceReferenceTest.getGet((String)object4, obj);
            object = DataSourceReferenceTest.getSet((Method)object2, obj);
            clazz = ((Method)object2).getReturnType();
            if (clazz.equals(Integer.TYPE)) {
                ((Method)object).invoke(obj, Integer.valueOf((String)object3));
                continue;
            }
            if (clazz.equals(String.class)) {
                ((Method)object).invoke(obj, object3);
                continue;
            }
            if (clazz.equals(Boolean.TYPE)) {
                ((Method)object).invoke(obj, Boolean.valueOf((String)object3));
                continue;
            }
            if (clazz.equals(Short.TYPE)) {
                ((Method)object).invoke(obj, Short.valueOf((String)object3));
                continue;
            }
            if (clazz.equals(Long.TYPE)) {
                ((Method)object).invoke(obj, Long.valueOf((String)object3));
                continue;
            }
            DataSourceReferenceTest.fail((String)("'" + (String)object4 + "' not settable - update test!!"));
        }
        object4 = (Referenceable)obj;
        object3 = object4.getReference();
        object2 = ((Reference)object3).getFactoryClassName();
        clazz2 = Class.forName((String)object2);
        object = (ObjectFactory)clazz2.getConstructor(new Class[0]).newInstance(new Object[0]);
        clazz = object.getObjectInstance(object3, null, null, null);
        DataSourceReferenceTest.assertNotSame((Object)clazz, obj);
        this.compareDataSources(dataSourceDescriptor, obj, clazz, false);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(obj);
        objectOutputStream.flush();
        objectOutputStream.close();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        clazz = objectInputStream.readObject();
        this.compareDataSources(dataSourceDescriptor, obj, clazz, false);
    }

    private void compareDataSources(DataSourceDescriptor dataSourceDescriptor, Object object, Object object2, boolean bl) throws Exception {
        Iterator iterator = dataSourceDescriptor.getPropertyIterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Method method = DataSourceReferenceTest.getGet(string, object);
            Object object3 = method.invoke(object, null);
            Object object4 = method.invoke(object2, null);
            if (object3 == null) {
                DataSourceReferenceTest.assertNull((Object)object4);
            } else {
                DataSourceReferenceTest.assertEquals((Object)object3, (Object)object4);
            }
            if (bl) {
                if (object3 != null) {
                    DataSourceReferenceTest.assertEquals((String)("Wrong default value for '" + string + "'"), (String)dataSourceDescriptor.getPropertyDefault(string), (String)object3.toString());
                    continue;
                }
                DataSourceReferenceTest.assertNull((Object)dataSourceDescriptor.getPropertyDefault(string));
                continue;
            }
            if (object3 != null) {
                DataSourceReferenceTest.assertEquals((String)("'" + string + "' has incorrect value"), (String)dataSourceDescriptor.getPropertyValue(string), (String)object3.toString());
                continue;
            }
            DataSourceReferenceTest.fail((String)"Test does not handle this situation...");
        }
    }

    private static String[] getPropertyBeanList(Object object) {
        Method[] methodArray = object.getClass().getMethods();
        ArrayList<CallSite> arrayList = new ArrayList<CallSite>();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            String string = method.getName();
            if (string.length() < 5 || !string.startsWith("get") || method.getParameterTypes().length != 0) continue;
            Class<?> clazz = method.getReturnType();
            if (clazz.equals(Integer.TYPE) || clazz.equals(String.class) || clazz.equals(Boolean.TYPE) || clazz.equals(Short.TYPE) || clazz.equals(Long.TYPE)) {
                String string2 = string.substring(3, 4).toLowerCase() + string.substring(4);
                arrayList.add((CallSite)((Object)string2));
                continue;
            }
            DataSourceReferenceTest.assertFalse((String)("Method '" + string + "' with primitive return type not supported - update test!!"), (boolean)clazz.isPrimitive());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static Method getGet(String string, Object object) throws NoSuchMethodException {
        String string2 = "get" + string.substring(0, 1).toUpperCase() + string.substring(1);
        Method method = object.getClass().getMethod(string2, null);
        return method;
    }

    private static Method getSet(Method method, Object object) throws NoSuchMethodException {
        String string = "s" + method.getName().substring(1);
        Method method2 = object.getClass().getMethod(string, method.getReturnType());
        return method2;
    }

    static {
        BASE_EMBEDDED_DS.addProperty("attributesAsPassword", "true", "false");
        BASE_EMBEDDED_DS.addProperty("connectionAttributes", "XX_connectionAttributes_2135");
        BASE_EMBEDDED_DS.addProperty("createDatabase", "create");
        BASE_EMBEDDED_DS.addProperty("dataSourceName", "XX_dataSourceName_1420");
        BASE_EMBEDDED_DS.addProperty("databaseName", "XX_databaseName_1206");
        BASE_EMBEDDED_DS.addProperty("description", "XX_description_1188");
        BASE_EMBEDDED_DS.addProperty("loginTimeout", "1280", "0");
        BASE_EMBEDDED_DS.addProperty("password", "XX_password_883");
        BASE_EMBEDDED_DS.addProperty("shutdownDatabase", "shutdown");
        BASE_EMBEDDED_DS.addProperty("user", "XX_user_447");
        BASE_CLIENT_DS = new DataSourceDescriptor("Basic client data source");
        BASE_CLIENT_DS.addProperty("loginTimeout", "1280", "0");
        BASE_CLIENT_DS.addProperty("portNumber", "1070", "1527");
        BASE_CLIENT_DS.addProperty("retrieveMessageText", "false", "true");
        BASE_CLIENT_DS.addProperty("securityMechanism", "1851", "4");
        BASE_CLIENT_DS.addProperty("serverName", "tmpHostName", "localhost");
        BASE_CLIENT_DS.addProperty("ssl", "basic", "off");
        BASE_CLIENT_DS.addProperty("user", "XX_user_447", "APP");
        BASE_CLIENT_DS.addProperty("connectionAttributes", "XX_connectionAttributes_2135");
        BASE_CLIENT_DS.addProperty("createDatabase", "create");
        BASE_CLIENT_DS.addProperty("databaseName", "XX_databaseName_1206");
        BASE_CLIENT_DS.addProperty("dataSourceName", "XX_dataSourceName_1420");
        BASE_CLIENT_DS.addProperty("description", "XX_description_1188");
        BASE_CLIENT_DS.addProperty("password", "XX_password_883");
        BASE_CLIENT_DS.addProperty("shutdownDatabase", "shutdown");
        BASE_CLIENT_DS.addProperty("traceFile", "XX_traceFile_911");
        BASE_CLIENT_DS.addProperty("traceFileAppend", "true", "false");
        BASE_CLIENT_DS.addProperty("traceLevel", "1031", "-1");
        BASE_CLIENT_DS.addProperty("traceDirectory", "XX_traceDirectory_1476");
        POOL_CLIENT_DS = new DataSourceDescriptor("Connection pool client data source", BASE_CLIENT_DS);
        POOL_CLIENT_DS.addProperty("maxStatements", "10", "0");
    }

    private static class DataSourceDescriptor {
        private final String dsName;
        private final Properties propertyValues;
        private final Properties propertyDefaults;

        DataSourceDescriptor(String string) {
            this.dsName = string;
            this.propertyValues = new Properties();
            this.propertyDefaults = new Properties();
        }

        DataSourceDescriptor(String string, DataSourceDescriptor dataSourceDescriptor) {
            this.dsName = string;
            this.propertyValues = new Properties();
            this.propertyValues.putAll((Map<?, ?>)dataSourceDescriptor.propertyValues);
            this.propertyDefaults = new Properties(dataSourceDescriptor.propertyDefaults);
            this.propertyDefaults.putAll((Map<?, ?>)dataSourceDescriptor.propertyDefaults);
        }

        String getName() {
            return this.dsName;
        }

        void addProperty(String string, String string2) {
            this.propertyValues.setProperty(string, string2);
        }

        void addProperty(String string, String string2, String string3) {
            this.propertyValues.setProperty(string, string2);
            this.propertyDefaults.setProperty(string, string3);
        }

        String getPropertyValue(String string) {
            if (!this.propertyValues.containsKey(string)) {
                Assert.fail((String)("Property '" + string + "' not in data source descriptor '" + this.dsName + "'"));
            }
            return this.propertyValues.getProperty(string);
        }

        String getPropertyDefault(String string) {
            if (!this.propertyValues.containsKey(string)) {
                Assert.fail((String)("Property '" + string + "' not in data source descriptor '" + this.dsName + "'"));
            }
            return this.propertyDefaults.getProperty(string, null);
        }

        Iterator getPropertyIterator() {
            return this.propertyValues.keySet().iterator();
        }

        boolean hasProperty(String string) {
            return this.propertyValues.containsKey(string);
        }

        int getPropertyCount() {
            return this.propertyValues.size();
        }
    }
}

