/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.zip.CRC32;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetReader;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ResultSetStreamTest
extends BaseJDBCTestCase {
    private static String filePath;
    private static String sep;
    static final String TEST_STRING_DATA = "ABCDEFG\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00ff\u0100\u3042\u3044\u3046\u3048\u304a";

    public ResultSetStreamTest(String string) {
        super(string);
    }

    public void testInsertData() throws SQLException, Exception {
        this.insertData();
    }

    private void insertData() throws SQLException, FileNotFoundException, IOException {
        Connection connection = this.getConnection();
        PreparedStatement preparedStatement = connection.prepareStatement("insert into t2 (len, data) values (?, ?)");
        filePath = "extin";
        String string = System.getProperty("user.dir");
        sep = System.getProperty("file.separator");
        filePath = string + sep + filePath;
        File file = new File(filePath + sep + "littleclob.utf");
        int n = (int)file.length();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        preparedStatement.setInt(1, n);
        preparedStatement.setBinaryStream(2, (InputStream)bufferedInputStream, n);
        preparedStatement.executeUpdate();
        bufferedInputStream.close();
        file = new File(filePath + sep + "short.utf");
        n = (int)file.length();
        bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        preparedStatement.setInt(1, n);
        preparedStatement.setBinaryStream(2, (InputStream)bufferedInputStream, n);
        preparedStatement.executeUpdate();
        bufferedInputStream.close();
        preparedStatement.setInt(1, -1);
        preparedStatement.setBinaryStream(2, (InputStream)null, 0);
        preparedStatement.executeUpdate();
        File file2 = new File(filePath + sep + "resultsetStream.gif");
        int n2 = (int)file2.length();
        preparedStatement.setInt(1, n2);
        bufferedInputStream = new BufferedInputStream(new FileInputStream(file2));
        preparedStatement.setBinaryStream(2, (InputStream)bufferedInputStream, n2);
        preparedStatement.executeUpdate();
        bufferedInputStream.close();
        byte[] byArray = new byte[234];
        preparedStatement.setInt(1, 234);
        preparedStatement.setBinaryStream(2, (InputStream)new ByteArrayInputStream(byArray), 234);
        preparedStatement.executeUpdate();
        preparedStatement.setInt(1, 235);
        preparedStatement.setBinaryStream(2, (InputStream)new ByteArrayInputStream(byArray), 235);
        try {
            preparedStatement.executeUpdate();
            ResultSetStreamTest.fail((String)"FAIL - execute with setBinaryStream() with too few bytes succeeded");
        }
        catch (SQLException sQLException) {
            this.assertMisMatchStreamLength(sQLException);
        }
        preparedStatement.setInt(1, 233);
        preparedStatement.setBinaryStream(2, (InputStream)new ByteArrayInputStream(byArray), 233);
        try {
            preparedStatement.executeUpdate();
            ResultSetStreamTest.fail((String)"FAIL - execute with setBinaryStream() with too many bytes succeeded");
        }
        catch (SQLException sQLException) {
            this.assertMisMatchStreamLength(sQLException);
        }
        preparedStatement.close();
    }

    private void assertMisMatchStreamLength(SQLException sQLException) {
        if (ResultSetStreamTest.usingEmbedded()) {
            ResultSetStreamTest.assertEquals((String)"XSDA4", (String)sQLException.getSQLState());
            sQLException = sQLException.getNextException();
            ResultSetStreamTest.assertSQLState("XJ001", sQLException);
        } else {
            String string = sQLException.getSQLState();
            ResultSetStreamTest.assertTrue((String)"SQLState not XN015 or XN017 as expected", ("XN015".equals(string) || "XN017".equals(string) ? 1 : 0) != 0);
        }
    }

    public void testBinaryStreamProcessing() throws SQLException, Exception {
        this.binaryStreamProcessing();
    }

    public void binaryStreamProcessing() throws SQLException, IOException {
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        filePath = "extin";
        String string = System.getProperty("user.dir");
        sep = System.getProperty("file.separator");
        filePath = string + sep + filePath;
        File file = new File(filePath + sep + "resultsetStream.gif");
        int n = (int)file.length();
        ResultSet resultSet = statement.executeQuery("select data from t2 where len = " + n);
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        ResultSetStreamTest.assertEquals((int)1, (int)resultSetMetaData.getColumnCount());
        while (resultSet.next()) {
            int n2;
            int n3;
            int n4;
            InputStream inputStream = resultSet.getBinaryStream(1);
            if (inputStream == null) {
                ResultSetStreamTest.fail((String)"FAIL - getBinaryStream() return null");
                break;
            }
            byte[] byArray = new byte[200];
            for (n3 = 0; n3 < 200 && (n4 = inputStream.read(byArray, n3, 200 - n3)) != -1; n3 += n4) {
            }
            if (n3 != 200) {
                ResultSetStreamTest.fail((String)"FAIL - failed to read 200 bytes from known file");
                break;
            }
            CRC32 cRC32 = new CRC32();
            cRC32.reset();
            cRC32.update(byArray);
            ResultSetStreamTest.assertEquals((String)"Incorrect checksum value", (long)3061553656L, (long)cRC32.getValue());
            n3 = 200;
            while (inputStream.read() != -1) {
                ++n3;
            }
            ResultSetStreamTest.assertEquals((String)"unexpected size of file", (int)3470, (int)n3);
            resultSet.close();
            resultSet = statement.executeQuery("select data, len from t2 where len = " + n);
            resultSetMetaData = resultSet.getMetaData();
            ResultSetStreamTest.assertEquals((int)2, (int)resultSetMetaData.getColumnCount());
            while (resultSet.next()) {
                int n5;
                inputStream = resultSet.getBinaryStream(1);
                if (inputStream == null) {
                    ResultSetStreamTest.fail((String)"FAIL - getBinaryStream() return null");
                    break;
                }
                byArray = new byte[200];
                for (n3 = 0; n3 < 200 && (n5 = inputStream.read(byArray, n3, 200 - n3)) != -1; n3 += n5) {
                }
                if (n3 != 200) {
                    ResultSetStreamTest.fail((String)"FAIL - failed to read 200 bytes from known file");
                    break;
                }
                cRC32 = new CRC32();
                cRC32.reset();
                cRC32.update(byArray);
                ResultSetStreamTest.assertEquals((String)"Incorrect checksum value", (long)3061553656L, (long)cRC32.getValue());
                ResultSetStreamTest.assertEquals((int)3470, (int)resultSet.getInt(2));
                try {
                    inputStream.read();
                    ResultSetStreamTest.fail((String)("FAIL - stream was not closed after a get*() call. " + inputStream.getClass()));
                    break;
                }
                catch (IOException iOException) {
                }
            }
            resultSet.close();
            resultSet = statement.executeQuery("select data from t2 where len = -1");
            resultSetMetaData = resultSet.getMetaData();
            ResultSetStreamTest.assertEquals((int)1, (int)resultSetMetaData.getColumnCount());
            while (resultSet.next()) {
                inputStream = resultSet.getBinaryStream(1);
                if (inputStream == null) continue;
                ResultSetStreamTest.fail((String)"FAIL - getBinaryStream() did not return null for SQL null");
                break;
            }
            resultSet.close();
            File file2 = new File(filePath + sep + "short.utf");
            int n6 = (int)file2.length();
            resultSet = statement.executeQuery("select len, data from t2 where len = " + n6);
            resultSet.next();
            n6 = resultSet.getInt(1);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(resultSet.getBinaryStream(2));
            int n7 = 0;
            while ((n2 = bufferedInputStream.read()) != -1) {
                ++n7;
            }
            bufferedInputStream.close();
            ResultSetStreamTest.assertEquals((int)56, (int)n6);
            ResultSetStreamTest.assertEquals((int)56, (int)n7);
        }
        resultSet.close();
        statement.close();
    }

    public void testGetAsciiStream() throws SQLException, IOException {
        Connection connection = this.getConnection();
        PreparedStatement preparedStatement = connection.prepareStatement("insert into t3(text_data) values(?)");
        preparedStatement.setCharacterStream(1, (Reader)new StringReader(TEST_STRING_DATA), TEST_STRING_DATA.length());
        preparedStatement.executeUpdate();
        preparedStatement = connection.prepareStatement("select text_data as text_data_col1,text_data as text_data_col2 from t3");
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            InputStream inputStream = resultSet.getAsciiStream(1);
            int n = 0;
            int n2 = inputStream.read();
            while (n2 > -1) {
                int n3;
                if ((n3 = TEST_STRING_DATA.charAt(n++)) > 255) {
                    n3 = 63;
                }
                ResultSetStreamTest.assertEquals((int)n3, (int)n2);
                n2 = inputStream.read();
            }
            Statement statement = this.createStatement();
            statement.executeUpdate("delete from t3");
        }
    }

    public void testGetCharacterStream() throws SQLException, IOException {
        AutoCloseable autoCloseable;
        Connection connection = this.getConnection();
        PreparedStatement preparedStatement = connection.prepareStatement("insert into t3(text_data) values(?)");
        preparedStatement.setCharacterStream(1, (Reader)new StringReader(TEST_STRING_DATA), TEST_STRING_DATA.length());
        preparedStatement.executeUpdate();
        preparedStatement = connection.prepareStatement("select text_data as text_data_col1,text_data as text_data_col2 from t3");
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            autoCloseable = resultSet.getCharacterStream(1);
            int n = 0;
            int n2 = ((Reader)autoCloseable).read();
            while (n2 > -1) {
                char c = TEST_STRING_DATA.charAt(n++);
                ResultSetStreamTest.assertEquals((int)c, (int)n2);
                n2 = ((Reader)autoCloseable).read();
            }
        }
        autoCloseable = this.createStatement();
        autoCloseable.executeUpdate("delete from t3");
    }

    public void testSetMaxFieldSizeLarge() throws IOException, SQLException {
        int n = 1;
        int n2 = 0x200000;
        int n3 = 32672;
        int n4 = 10;
        PreparedStatement preparedStatement = this.prepareStatement("insert into setMaxFieldSize values (?,?,?)");
        preparedStatement.setInt(1, n);
        preparedStatement.setCharacterStream(2, (Reader)new LoopingAlphabetReader(n3), n3);
        preparedStatement.setCharacterStream(3, (Reader)new LoopingAlphabetReader(n2), n2);
        preparedStatement.executeUpdate();
        Statement statement = this.createStatement();
        statement.setMaxFieldSize(n4);
        ResultSet resultSet = statement.executeQuery("select dVarchar, dClob from setMaxFieldSize where id = " + n);
        ResultSetStreamTest.assertTrue((boolean)resultSet.next());
        String string = ResultSetStreamTest.drainStringFromSource(resultSet.getCharacterStream(1));
        ResultSetStreamTest.assertEquals((int)n4, (int)string.length());
        String string2 = ResultSetStreamTest.drainStringFromSource(resultSet.getCharacterStream(2));
        ResultSetStreamTest.assertEquals((int)n2, (int)string2.length());
        resultSet.close();
        statement = this.createStatement();
        resultSet = statement.executeQuery("select dVarchar, dClob from setMaxFieldSize where id = " + n);
        ResultSetStreamTest.assertTrue((boolean)resultSet.next());
        string = ResultSetStreamTest.drainStringFromSource(resultSet.getCharacterStream(1));
        ResultSetStreamTest.assertEquals((int)n3, (int)string.length());
        string2 = ResultSetStreamTest.drainStringFromSource(resultSet.getCharacterStream(2));
        ResultSetStreamTest.assertEquals((int)n2, (int)string2.length());
        resultSet.close();
    }

    private static String drainStringFromSource(Reader reader) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[1024];
        while ((n = reader.read(cArray)) != -1) {
            stringBuffer.append(cArray, 0, n);
        }
        return stringBuffer.toString();
    }

    public static Test basesuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite(ResultSetStreamTest.class, string);
        SupportFilesSetup supportFilesSetup = new SupportFilesSetup((Test)baseTestSuite, new String[]{"functionTests/testData/ResultSetStream/littleclob.utf", "functionTests/testData/ResultSetStream/short.utf", "functionTests/testData/ResultSetStream/resultsetStream.gif"});
        return new CleanDatabaseTestSetup((Test)supportFilesSetup){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                statement.execute("create table t2 (len int, data LONG VARCHAR FOR BIT DATA)");
                statement.execute("create table t3(text_data clob)");
                statement.execute("create table setMaxFieldSize(id int unique, dVarchar VARCHAR(32672), dClob clob)");
            }
        };
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("ResultSetStreamTest");
        baseTestSuite.addTest(ResultSetStreamTest.basesuite("ResultSetStreamTest:embedded"));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(ResultSetStreamTest.basesuite("ResultSetStreamTest:client")));
        return baseTestSuite;
    }
}

