/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derby.tools.ij;
import org.apache.derbyTesting.functionTests.util.TestUtil;

public class resultsetJdbc20 {
    private static String[] testObjects = new String[]{"TABLE T"};

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"i", "s", "r", "d", "dt", "t", "ts", "c", "v", "dc"};
        System.out.println("Test resultsetJdbc20 starting");
        try {
            ij.getPropertyArg((String[])stringArray);
            Connection connection = ij.startJBMS();
            Statement statement = connection.createStatement();
            TestUtil.cleanUpTest(statement, testObjects);
            statement.execute("create table t (i int, s smallint, r real, d double precision, dt date, t time, ts timestamp, c char(10), v varchar(40) not null, dc dec(10,2))");
            statement.execute("insert into t values(1,2,3.3,4.4,date('1990-05-05'),time('12:06:06'),timestamp('1990-07-07 07:07:07.07'),'eight','nine', 10.1)");
            ResultSet resultSet = statement.executeQuery("select * from t");
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            System.out.println("getColumnCount(): " + n);
            for (int i = 1; i <= n; ++i) {
                if (i == 2 && resultSetMetaData.getColumnClassName(i).equals("java.lang.Short")) {
                    System.out.println("getColumnName(" + i + "): " + resultSetMetaData.getColumnName(i));
                    System.out.println("FAIL: should be java.lang.Integer - but is java.lang.Short. see beetle 5775");
                    continue;
                }
                System.out.println("getColumnName(" + i + "): " + resultSetMetaData.getColumnName(i));
                System.out.println("getColumnClassName(" + i + "): " + resultSetMetaData.getColumnClassName(i));
            }
            resultSet.close();
            TestUtil.cleanUpTest(statement, testObjects);
            statement.close();
            connection.close();
        }
        catch (SQLException sQLException) {
            resultsetJdbc20.dumpSQLExceptions(sQLException);
            sQLException.printStackTrace();
        }
        catch (Throwable throwable) {
            System.out.println("FAIL -- unexpected exception: " + throwable);
            throwable.printStackTrace();
        }
        System.out.println("Test resultsetJdbc20 finished");
    }

    private static void dumpSQLExceptions(SQLException sQLException) {
        System.out.println("FAIL -- unexpected exception");
        while (sQLException != null) {
            System.out.println("SQLSTATE(" + sQLException.getSQLState() + "): " + sQLException);
            sQLException = sQLException.getNextException();
        }
    }
}

