/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class DriverTest
extends BaseJDBCTestCase {
    private static final String DB_NAME_WITH_SPACES = "db name with spaces";
    private static final String MALFORMED_URL = "XJ028";
    static final String[] ADDITIONAL_DBS = new String[]{"db name with spaces", "testcreatedb1", "testcreatedb2", "testcreatedb3", "trailblank", "'wombat'"};

    public DriverTest(String string) {
        super(string);
    }

    public static Test suite() {
        if (JDBC.vmSupportsJSR169()) {
            return new BaseTestSuite("DriverTest tests java.sql.Driver, not supported with JSR169");
        }
        BaseTestSuite baseTestSuite = new BaseTestSuite("DriverTest");
        baseTestSuite.addTest(DriverTest.baseSuite("DriverTest:embedded"));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(DriverTest.baseSuite("DriverTest:client")));
        return baseTestSuite;
    }

    private static Test baseSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite("DriverTest");
        DriverTest.setBaseProps(baseTestSuite, (Test)new DriverTest("testDriverCompliantVersion"));
        DriverTest.setBaseProps(baseTestSuite, (Test)new DriverTest("testAcceptsURL"));
        DriverTest.setBaseProps(baseTestSuite, (Test)new DriverTest("testEmbeddedAttributes"));
        DriverTest.setBaseProps(baseTestSuite, (Test)new DriverTest("testClientAttributes"));
        DriverTest.setBaseProps(baseTestSuite, (Test)new DriverTest("testClientURL"));
        DriverTest.setBaseProps(baseTestSuite, (Test)new DriverTest("testDbNameWithSpaces"));
        return baseTestSuite;
    }

    private static void setBaseProps(BaseTestSuite baseTestSuite, Test object) {
        Properties properties = new Properties();
        properties.setProperty("derby.infolog.append", "true");
        properties.setProperty("derby.debug.true", "AuthenticationTrace");
        properties.setProperty("derby.user.APP", "xxxx");
        properties.setProperty("derby.user.testuser", "testpass");
        object = new DatabasePropertyTestSetup((Test)object, properties, true);
        baseTestSuite.addTest((Test)object);
    }

    @Override
    public void tearDown() throws Exception {
        for (int i = 0; i < 2; ++i) {
            String object = "trace" + (i + 1) + ".out";
            File file = new File(object);
            if (!PrivilegedFileOpsForTests.exists(file)) continue;
            PrivilegedFileOpsForTests.delete(file);
        }
        TestConfiguration testConfiguration = TestConfiguration.getCurrent();
        for (String string : ADDITIONAL_DBS) {
            DriverTest.removeDirectory(testConfiguration.getDatabasePath(string));
        }
        super.tearDown();
    }

    public void testDriverCompliantVersion() throws Exception {
        String string = TestConfiguration.getCurrent().getDefaultDatabaseName();
        String string2 = TestConfiguration.getCurrent().getJDBCUrl(string);
        DriverTest.loadDriver();
        String string3 = string2 + ";create=true";
        Driver driver = DriverManager.getDriver(string3);
        Properties properties = new Properties();
        properties.put("user", "testuser");
        properties.put("password", "testpass");
        Connection connection = DriverManager.getConnection(string3, properties);
        DriverTest.assertTrue((boolean)driver.jdbcCompliant());
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        DriverTest.assertEquals((int)databaseMetaData.getDriverMajorVersion(), (int)driver.getMajorVersion());
        DriverTest.assertEquals((int)databaseMetaData.getDriverMinorVersion(), (int)driver.getMinorVersion());
        DriverTest.println("Driver is a " + driver.getClass().getName());
        DriverTest.assertEquals((String)(DriverTest.usingEmbedded() ? "AutoloadedDriver" : "ClientAutoloadedDriver"), (String)driver.getClass().getSimpleName());
        try {
            driver.acceptsURL(null);
            DriverTest.fail((String)"Should not have accepted a null connection url");
        }
        catch (SQLException sQLException) {
            DriverTest.assertSQLState(MALFORMED_URL, sQLException);
        }
        try {
            driver.connect(null, properties);
            DriverTest.fail((String)"Should not have accepted a null connection url");
        }
        catch (SQLException sQLException) {
            DriverTest.assertSQLState(MALFORMED_URL, sQLException);
        }
        connection.close();
    }

    public void testAcceptsURL() throws SQLException, Exception {
        String string = TestConfiguration.getCurrent().getDefaultDatabaseName();
        String string2 = TestConfiguration.getCurrent().getJDBCUrl(string);
        DriverTest.loadDriver();
        String string3 = string2 + ";create=true";
        Driver driver = DriverManager.getDriver(string3);
        int n = 0;
        int n2 = 1;
        int n3 = DriverTest.usingDerbyNetClient() ? n2 : n;
        String string4 = "jdbc:derby:";
        String string5 = "jdbc:db2j:";
        String string6 = TestConfiguration.getCurrent().getHostName();
        int n4 = TestConfiguration.getCurrent().getPort();
        String string7 = "jdbc:derby://" + string6 + ":" + n4 + "/" + string + ";create=true";
        String[] stringArray = new String[]{string4, string7, string5};
        boolean[][] blArrayArray = new boolean[][]{{true, false}, {false, true}, {false, false}};
        for (int i = 0; i < stringArray.length; ++i) {
            String string8 = stringArray[i];
            boolean bl = blArrayArray[i][n3];
            boolean bl2 = driver.acceptsURL(string8);
            DriverTest.assertEquals((boolean)bl, (boolean)bl2);
        }
    }

    public void testEmbeddedAttributes() throws SQLException {
        String string = TestConfiguration.getCurrent().getDefaultDatabaseName();
        Object object = TestConfiguration.getCurrent().getJDBCClient().getUrlBase();
        if (DriverTest.usingDerbyNetClient()) {
            object = (String)object + TestConfiguration.getCurrent().getHostName() + ":" + TestConfiguration.getCurrent().getPort() + "/";
        }
        String string2 = TestConfiguration.getCurrent().getJDBCUrl(string);
        Properties properties = new Properties();
        properties.setProperty("create", "true");
        if (DriverTest.usingEmbedded()) {
            DriverTest.assertConnect(true, (String)object + "testcreatedb1", properties);
        } else {
            DriverTest.assertConnect(false, (String)object + "testcreatedb1", properties);
        }
        if (DriverTest.usingEmbedded()) {
            DriverTest.assertConnect(false, (String)object + "testcreatedb2;create=true", null);
        } else {
            DriverTest.assertConnect(true, (String)object + "testcreatedb2;create=true", null);
        }
        properties.clear();
        properties.setProperty("user", "APP");
        properties.setProperty("password", "xxxx");
        if (DriverTest.usingEmbedded()) {
            DriverTest.assertConnect(true, string2, properties);
        } else {
            DriverTest.assertConnect(false, string2, properties);
        }
        DriverTest.assertConnect(false, string2 + ";user=testuser;password=testpass", null);
        properties.clear();
        properties.setProperty("password", "testpass");
        DriverTest.assertConnect(false, string2 + ";user=testusr", properties);
        properties.clear();
        properties.setProperty("user", "APP");
        properties.setProperty("password", "xxxx");
        DriverTest.assertConnect(false, string2 + ";user=testuser;password=testpass", null);
        properties.clear();
        properties.setProperty("shutdown", "true");
        try {
            DriverTest.assertConnect(false, (String)object + "testcreatedb1", properties);
        }
        catch (SQLException sQLException) {
            DriverTest.assertSQLState("08006", sQLException);
        }
        try {
            DriverTest.assertConnect(false, (String)object + "testcreatedb2;shutdown=true", null);
        }
        catch (SQLException sQLException) {
            DriverTest.assertSQLState("08006", sQLException);
        }
    }

    public void testClientAttributes() throws SQLException {
        if (!DriverTest.usingDerbyNetClient()) {
            return;
        }
        String string = TestConfiguration.getCurrent().getDefaultDatabaseName();
        String string2 = TestConfiguration.getCurrent().getJDBCUrl(string);
        Properties properties = new Properties();
        String string3 = "trace1.out";
        DriverTest.assertConnect(true, string2 + ";traceFile=" + string3, properties);
        string3 = "trace2.out";
        properties.setProperty("traceFile", string3);
        DriverTest.assertConnect(false, string2, properties);
        DriverTest.assertTraceFilesExist();
        DriverTest.shutdownDB(string2 + ";shutdown=true", null);
        properties.setProperty("create", "true");
        Properties properties2 = new Properties(properties);
        string2 = TestConfiguration.getCurrent().getJDBCUrl("testcreatedb3");
        DriverTest.assertConnect(false, string2, properties2);
        DriverTest.shutdownDB(string2 + ";shutdown=true", null);
    }

    private static void assertTraceFilesExist() {
        for (int i = 0; i < 2; ++i) {
            String string = "trace" + (i + 1) + ".out";
            File file = new File(string);
            DriverTest.assertTrue((boolean)PrivilegedFileOpsForTests.exists(file));
        }
    }

    public void testClientURL() throws SQLException {
        if (!DriverTest.usingDerbyNetClient()) {
            return;
        }
        String string = TestConfiguration.getCurrent().getDefaultDatabaseName();
        Object object = TestConfiguration.getCurrent().getJDBCClient().getUrlBase();
        if (DriverTest.usingDerbyNetClient()) {
            object = (String)object + TestConfiguration.getCurrent().getHostName() + ":" + TestConfiguration.getCurrent().getPort() + "/";
        }
        Properties properties = null;
        String string2 = (String)object + string + ":create=true";
        String string3 = (String)object + "'" + string + "';create=true";
        String string4 = (String)object + "'" + string + "';shutdown=true";
        String[] stringArray = new String[]{string2, string3};
        for (int i = 0; i < stringArray.length; ++i) {
            String string5 = stringArray[i];
            try {
                if (string5.equals(string2)) {
                    Driver driver = DriverManager.getDriver(string5);
                    DriverTest.assertNull((Object)driver.connect(string5, properties));
                    continue;
                }
                DriverTest.assertConnect(true, string5, properties);
                continue;
            }
            catch (SQLException sQLException) {
                DriverTest.fail((String)"did not expect an exception");
            }
        }
        DriverTest.shutdownDB(string4 + ";shutdown=true", null);
    }

    public void testDbNameWithSpaces() throws SQLException {
        Object var1_1 = null;
        Object object = null;
        Object object2 = TestConfiguration.getCurrent().getJDBCClient().getUrlBase();
        if (DriverTest.usingDerbyNetClient()) {
            object2 = (String)object2 + TestConfiguration.getCurrent().getHostName() + ":" + TestConfiguration.getCurrent().getPort() + "/";
        }
        object = (String)object2 + "db name with spaces;create=true";
        String string = (String)object2 + "db name with spaces;shutdown=true";
        DriverTest.assertConnect(false, (String)object, null);
        DriverTest.shutdownDB(string, null);
        object = TestConfiguration.getCurrent().getJDBCUrl("trailblank");
        object = (String)object + ";create=true";
        DriverTest.assertConnect(false, (String)object, null);
        object = TestConfiguration.getCurrent().getJDBCUrl("trailblank     ");
        DriverTest.assertConnect(true, (String)object, null);
        object = TestConfiguration.getCurrent().getJDBCUrl("trailblank     ");
        object = (String)object + ";shutdown=true";
        DriverTest.shutdownDB((String)object, null);
    }

    private static void assertConnect(boolean bl, String string, Properties properties) throws SQLException {
        Driver driver = DriverManager.getDriver(string);
        Connection connection = driver.connect(string, properties);
        DriverTest.assertNotNull((Object)connection);
        if (bl) {
            DriverTest.assertEquals((String)string, (String)connection.getMetaData().getURL());
        } else {
            DriverTest.assertNotSame((Object)string, (Object)connection.getMetaData().getURL());
        }
        ResultSet resultSet = connection.createStatement().executeQuery("VALUES(CURRENT SCHEMA)");
        resultSet.next();
        DriverTest.assertEquals((String)resultSet.getString(1), (String)connection.getMetaData().getUserName().toUpperCase());
        resultSet.close();
        connection.close();
    }

    private static void shutdownDB(String string, Properties properties) throws SQLException {
        Driver driver = DriverManager.getDriver(string);
        try {
            driver.connect(string, properties);
        }
        catch (SQLException sQLException) {
            DriverTest.assertSQLState("08006", sQLException);
        }
    }

    private static void loadDriver() {
        String string = TestConfiguration.getCurrent().getJDBCClient().getJDBCDriverName();
        try {
            Class<?> clazz = Class.forName(string);
            clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            DriverTest.fail((String)"could not instantiate driver");
        }
    }
}

